"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthController = void 0;
const common_1 = require("@nestjs/common");
const passport_1 = require("@nestjs/passport");
const swagger_1 = require("@nestjs/swagger");
const auth_service_1 = require("./auth.service");
const auth_dto_1 = require("./auth.dto");
const config_service_1 = require("../config/config.service");
let AuthController = class AuthController {
    constructor(authService, configService) {
        this.authService = authService;
        this.configService = configService;
    }
    signIn(body) {
        return this.authService.signIn(body.username, body.password, body.otp);
    }
    getSettings() {
        return this.configService.uiSettings();
    }
    getCustomWallpaper() {
        return this.configService.streamCustomWallpaper();
    }
    getToken() {
        return this.authService.generateNoAuthToken();
    }
    checkAuth() {
        return { status: 'OK' };
    }
};
__decorate([
    swagger_1.ApiOperation({ summary: 'Exchange a username and password for an authentication token.' }),
    common_1.Post('login'),
    __param(0, common_1.Body()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto]),
    __metadata("design:returntype", void 0)
], AuthController.prototype, "signIn", null);
__decorate([
    common_1.Get('/settings'),
    swagger_1.ApiOperation({ summary: 'Return settings required to load the UI before authentication.' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], AuthController.prototype, "getSettings", null);
__decorate([
    swagger_1.ApiExcludeEndpoint(),
    common_1.Get('/wallpaper/:hash'),
    common_1.Header('Content-Type', 'image/jpeg'),
    common_1.Header('Cache-Control', 'public,max-age=31536000,immutable'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], AuthController.prototype, "getCustomWallpaper", null);
__decorate([
    swagger_1.ApiOperation({ summary: 'This method can be used to obtain an access token ONLY when authentication has been disabled.' }),
    common_1.Post('/noauth'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], AuthController.prototype, "getToken", null);
__decorate([
    swagger_1.ApiBearerAuth(),
    swagger_1.ApiOperation({ summary: 'Check to see if an authentication token is still valid.' }),
    common_1.UseGuards(passport_1.AuthGuard()),
    common_1.Get('/check'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], AuthController.prototype, "checkAuth", null);
AuthController = __decorate([
    swagger_1.ApiTags('Authentication'),
    common_1.Controller('auth'),
    __metadata("design:paramtypes", [auth_service_1.AuthService,
        config_service_1.ConfigService])
], AuthController);
exports.AuthController = AuthController;
//# sourceMappingURL=auth.controller.js.map