"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HomebridgeNestCamGateway = void 0;
const websockets_1 = require("@nestjs/websockets");
const common_1 = require("@nestjs/common");
const ws_guard_1 = require("../../../core/auth/guards/ws.guard");
const homebridge_nest_cam_service_1 = require("./homebridge-nest-cam.service");
let HomebridgeNestCamGateway = class HomebridgeNestCamGateway {
    constructor(homebridgeNestCamService) {
        this.homebridgeNestCamService = homebridgeNestCamService;
    }
    connect(client) {
        this.homebridgeNestCamService.linkAccount(client);
    }
};
__decorate([
    websockets_1.SubscribeMessage('link-account'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], HomebridgeNestCamGateway.prototype, "connect", null);
HomebridgeNestCamGateway = __decorate([
    common_1.UseGuards(ws_guard_1.WsGuard),
    websockets_1.WebSocketGateway({
        namespace: 'plugins/custom-plugins/homebridge-nest-cam', allowEIO3: true, cors: {
            origin: ['http://localhost:8080', 'http://localhost:4200'],
            credentials: true
        }
    }),
    __metadata("design:paramtypes", [homebridge_nest_cam_service_1.HomebridgeNestCamService])
], HomebridgeNestCamGateway);
exports.HomebridgeNestCamGateway = HomebridgeNestCamGateway;
//# sourceMappingURL=homebridge-nest-cam.gateway.js.map