"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HomebridgeRingService = void 0;
const common_1 = require("@nestjs/common");
const axios_1 = require("@nestjs/axios");
const logger_service_1 = require("../../../core/logger/logger.service");
let HomebridgeRingService = class HomebridgeRingService {
    constructor(logger, httpService) {
        this.logger = logger;
        this.httpService = httpService;
    }
    async exchangeCredentials(credentials) {
        try {
            return (await this.httpService.post('https://oauth.ring.com/oauth/token', {
                client_id: 'ring_official_android',
                scope: 'client',
                grant_type: 'password',
                password: credentials.password,
                username: credentials.email,
            }, {
                headers: {
                    'content-type': 'application/json',
                    '2fa-support': 'true',
                    '2fa-code': credentials.twoFactorAuthCode || '',
                },
            }).toPromise()).data;
        }
        catch (e) {
            if (e.response && e.response.status === 412) {
                return new common_1.HttpException(e.response.data, 412);
            }
            else if (e.response.data) {
                return new common_1.UnauthorizedException(e.response.data);
            }
            else {
                this.logger.error('[homebridge-ring] - Failed to get credentials');
                this.logger.error(e);
                return new common_1.InternalServerErrorException();
            }
        }
    }
};
HomebridgeRingService = __decorate([
    common_1.Injectable(),
    __metadata("design:paramtypes", [logger_service_1.Logger,
        axios_1.HttpService])
], HomebridgeRingService);
exports.HomebridgeRingService = HomebridgeRingService;
//# sourceMappingURL=homebridge-ring.service.js.map