#define TEST_NAME "aead_aegis128l"
#include "cmptest.h"

static struct {
    const char *key_hex;
    const char *nonce_hex;
    const char *message_hex;
    const char *ad_hex;
    const char *ciphertext_hex;
    const char *mac_hex;
} tests[] = {
    {
        "54662e55bb4771f9711fe5301d7412fe",
        "e51d417ab10a2931d8d22a9fffb98e3a",
        "04f672f8cdb3e71d032d52c064bc33ecf8aad3d40c41d5806cc306766c057c50b500af5c550d076d34cc3a74a2b4bed195ffa3e8eddf953aefe9aed2bc14349c700ab7e4cb974fb31615a9ff70fb44307055523ab378b133fefc883013ce23bb01b23aeda15f85e65cdf02a291a0454900cb261872d5205737fd7410",
        "3b762e3ab5d06cb2896b852ea70303f289f2775401b7808e30272f",
        "d6736371f35eb067244dd7963ad2e0cd3949452cbd4c220be55082498ed3b230f579d78844311652a9958e82f172bb8072c4b1114ec531a6ccb340ddd86caf32a0d4c9c45738e9ec9c0d9154612f7d90465f3a277bebd667c0af0edb6935d8dffbdee96c1a96e4c4318f5d3bc90c1c8d5729e1a402f765bdc9b26b08",
        "53c2fd22b035bf3f3658ede47ef11b9d"
    },
    {
        "46a5c72e03d900b48f829df00ecb88b9",
        "b25187e4b77b6770c35c7a962584597d",
        "fc8083311b38a80c04e57d069661b273264310906781eb7e4e44c6416f7336267674a44a7c54ed6361b43ef9500514e5d9e71f8b5c33aece756b64f3ed011922facbec7c3ffd27d01a853435bde551372806bd0c",
        "b73c81239e01cd81b0de13247ca4e3528b87f3078e2b674a667430b1dbdc3e93657131e654a4182b4c4ab01a33b36e946f1fcc55aab06fc6f56d",
        "51189448af53ae3630c06a167ceefe6b9b5eba746fb9b53f4b3104d2b15b6020fa8998e182eb9c9d6b6463939e50723780f983733206ae6f11b986d95abe83555e64f8d3242d7e8055fcb8e2df8e41d318f06728",
        "f9b7e561ac0316d2ed7debc2484cc3e1"
    },
    {
        "e343d75de99e6d73543968437d3dcf6a",
        "317a5808ed5debf6f527a780e0896b2d",
        "247045cb40dea9c514a885444c526ac867b1b80e4728a23b63f596",
        "323094c01e",
        "18cb5d2fc5e27bdda5ba16f1320da42049759368548e5bd96f2dbc",
        "1659e7d7193b12b4c90ba1e4314ef055"
    },
    {
        "7db9c2721a03931c880f9e714bbf2211",
        "27f642398299ada7fdda1895ee4589f0",
        "dc5180954df0c3391a60b44cbf70aee72b7dbb2addc90a0bf2ceac6113287eb501fe1ea9f4c51822664b82fe0279b039f4",
        "6dd5e43033fa6f021059a353edaf1f870387693054d0a2360fd1f6941a68f48ba972a1bc0816a446a6186e4a9a2f9df556bf709470137b8e60d9daa2",
        "c8a7d9131cebfa5388003cc30deac523aa9b09d148affff06ba40400e09ca900db770e07cedf5cd0647f6723c810ffcb59",
        "6cac51edd6f49cd7be0010a3ac29e704"
    },
    {
        "bef8a47bbf0ffc4ab56ad5d9899f42b6",
        "3a2195a5196a0d785e04b38dd62f056d",
        "5aa0dc37e4db1de35789398b25dc656d05cdc6737de4e30ce944b304ec752bbd10ebfa51feff99dfcfe26b8526cc9b0cf1ba3d1685fb26cfc0c8888fd3cdf55577a516328b289eebda2e14f15eeb1d0f4207efebe3803618d43d99688e6c",
        "a4a290a0d719b1aaf58f24152402b2f36957f44ea8a2d76b045390f5e0a3559a8ec5b2f871fc6095152183b7be7565d4953b593f854b8477e29ce0cdddce5cf8739ab56288c26c81921f1fbae38b90b287b4622ca8b5b6c0b4b02196e73ee56af6ae427ca7ae3ca0",
        "0ead975179d64f2b927440bf9ef666ab921e7a3b0832949f31315c2931451c5ddf810c17ad0330073922c07a18eb665aca01c05de58f7d159a74884f9d90cc10dc8c017ab61b820fc3dd32be52f3f7265e3a7a912a230b2a7ed19992e693",
        "5773c1800d570e5dd8a4d581b5655dab"
    },
    {
        "01f1cea5b7e20db64a67502bb4715033",
        "7336701bbc2d766167b57c452d010f02",
        "b3669d31ef8040dd6f462624977d69cfd1869fb19946595759b7265eb98b51f579fddce4bd38452fe3",
        "d007e9ce654ec9a8b44e3655dcac889176fbf8012b133c4effe70b716eff43264d67d84a3d8504858c01002957cac6eb75d94635fb708343a18e20615e4ecb963bd98a8e7bee66520fba5c2991541c1e7863c1c97ae7ba6c3c34f1161518097b6e75dcfb3aa3e93995eb39",
        "4e643f7a1b8c0d595c8ff2b00c0145deb5bfa13d8a1b75d7a731f2258b690e1a3b2ce2cbacc6d05c42",
        "bb32551a6386fe557f543342130f03fe"
    },
    {
        "76d53860e1c45cf60d76d8336948e337",
        "579c0f0993f13470fa301cd4c6fbe99a",
        "d0f5d2b3b824fe01ca36d00d47434519b2112195093a06d9d07d7f4f9c5b8f2a4c68668265c40d6edd6e12b5a350e4af11f1ee6226bf307a1a6c25318c0d3aa0421edf565ad42d524f69d0fef06c236c1f0d0e50261e205f381c3e1196dd8827b9990d674288f8250596",
        "a7a77cc847afdfb9dc8ceccc621462302f31233a830b3827ca68618e604c95ba8615f6ebb5ff1c2c66727e70c038554619f96f79d08902fc70111f853766a2db04e51d",
        "def4fcb75110820298f08a8a4941434deccb952dec01215f5e7f5a2509fcb9e2a994a77d5eaa617da9cf2f03483faff5831506e5617707b88e08195b6a993219898c3ead769ebaa002934d3c80023833d7ce4a7a989596de6fe78eb0237e8caab0a9fcd2625af80caad6",
        "6eaad25866e9ce7276300f305f63ae5c"
    },
    {
        "cd05e08e14686623fd334780439c4ae3",
        "d05ba5a655bf7b1be7500f205c9c80b9",
        "021c20518825c167a746a728578a0f470b2035c7b39c75f3e492bcc2e6e96035c4fff65dfbfa93cbc7a37828a0cd62bf1b20b3bb89425ae647e021cde586f652eb98c98b1ac1018c6fe3e046f41545bbfdbf94dca48e465aaed8efb7eab5ea143e5b95b72a078f8fb58d8ecfdd9a3a968e2468b6",
        "be9255f750498ce672c877285e649318bd5bf07cdc5902b7de61a8415b6fbf20b1e432ebc9f8f9c8e3094ff6dffd1b1e0c3cc5",
        "faa851ddfe54b01cf1a3caf34815c6db0145ddebd1f34ca9edd479bd4a3bb4bac21c2b5d365ff4d389a764bcc1436e51267ed3e4f225b7cda1fbf25d221d91b59aed0b4d20f71859f41e85e15a02e2bcd59913d8ae019d1f01ede317b4ff94ed2b05650259a705c3b2be2c2a9c82a4809dab7b03",
        "b0292afc74141e969fb653de7ead5009"
    },
    {
        "6870a5652199e2f17407185bd7cf18eb",
        "942988922482351c317244b26587c560",
        "49b2f6765f7f552f8704671271d703b3b02157f71ed84e64481be8bbd4f3493bfd3f313ac62ba4e9a7d86288533a7bc7a4257cad5db04bb80d6574e473519eccd15cd2",
        "6cc34a81ee984b436947b31574473e0a849a341db0ebc67f64efb39c9e118f65cfb25d1d898b4ee8052f700cb43cbe744d70b71d2086a89ad12dd67feceacb092a861ba80e41808c625fbdce017d51916e1fb5b38b0beebb27478d8390ec79b3f3902a4ac22d79",
        "82d3ae3aea3870e40fa48da698adcb596eb43fb063866f6231bb744b687e32e72117a03da08a635e4ed0f255f28f3db6f0b8a7238d0244994a507fe75ddd17138b0605",
        "f529092f2eec3800f565ed7983da4c65"
    },
    {
        "15a87aee858f5723beb477b2cc039d14",
        "6ce71c763784e59fba852ae39b25de3a",
        "25d1d38a8e9e8c34564abbfcba69035ce2f78df8626543e7639f2f23d742853e34880e7bc6d684ed3075abdfb91e36076242dc53d60513333f59d139e680aa246b0e7e6092e8d4e6ab471459068c2a83b07e8b7969c911e3bff7558caf02b3f3e6de7ae9122d533558868d993b8242b2328834a88cd656a941",
        "26fde5885fd22bdcba8b5c1b5f66d09c7da7bfef2790e6dd2a98a351056044495fe4",
        "2e241f3f96e8bde7d2b5cfad94461d6c7282405c77918a2a8731711175211814e20e72ce01139643f58a2336c05cc27458f042ff063bc73fbee2ca8c099ff1f3fbe8517fce6cd3d54567220218cc67b4ef52767f75fe514e8ec49013d9fa787685a5a81efe550248f342eaade9cd61fb5037634f2bf621c944",
        "6aaabc9f958d3a5739985a529e761b56"
    },
    {
        "23e2250df6b870b6eebbce928cd1a80f",
        "279f73beda18846d7170c29414590029",
        "9cdd4e34495b4a03ca2c5bef9074c1",
        "f306eb122b1907b4b6bccc77984ea7be4a28f9ca3615135d4c84ad74d7469efefbbff997bb495806a3d9ab274b4228cb894fceeb24c4905e121efbd3ce8be668dfee4f9e38584ba6c3374337d3c884cdaddcd96f63df225ddc879e0ba4bce0125dd0",
        "8821c6d2c36ae97bef1b9d78c1afba",
        "0240cf940c42c5d600f435101fd6ed5c"
    },
    {
        "82f02cd289d07f40acf9a1d2b1cf7f06",
        "09162f09c3893bd2c5e4f2c8f6ec9930",
        "29f1d0e8aef96c9936eb5bcb32b0f751b25a7a46d4cc5a33d5f96dcaea757b2b",
        "4ccb0ba7f1b2eecbe3dc3ba47f797201ca656ab04e5b38df9b95ef24ba02a5ef04a9a8122f954048581d275e",
        "6b8f329fa3e905b7c0df490f18a13ab3b6be6701cba59a1ee7c12d054c500e58",
        "077cc505ec2cb55daf3ea3eaaa05a369"
    },
    {
        "a28c7a79d3d7d7b372c5cb4eb66201ba",
        "3c27d1ca6e8fd19cbf2dbd81c87d2ac0",
        "0ff33640432edcf34a2df2527ca13a0340d5adcae1d10589edbc89701f5093efeaf6d7d3f97a778052a76a6efe7b37021a4fbc8205f26f17dbd0c68b60c6403c4160985255aeac23c3bc88b1d8c11fd4197ba366962c",
        "96bec6c8014708e9142a8ea0fd496f89f5a2414f4296ae0a185b13f362f2",
        "f20be34587afaa4300683655ea16a292bfc7f2779cb771e520c6b0952e41a2b89e45f6c4b571779d573f1383b5e311f71ca89379b8a3eb9d9cde72b16e0f782058e9bb4df4731cbd7c67af1c459061ccff149da3bcdc",
        "8c713cfa494325148edd37b0ac7ef7a0"
    },
    {
        "24d66092958836e491cf974f34ee7ca9",
        "1c04e8166ef37a2a5d34b4462a7ca8bd",
        "01a77fb558d8d94c16eccc82b49f53823597272de8e6df070fefd202042665ef5788bab86c70dc3e571e3b372654494e552ef00462bf0f7fdeca8efbaa51f3da63e6f18fd13a4668b7fb1a89464a09a17d9ce709b0b8f079d6bf93ed4871c0",
        "3c082dae68ee1cd6b8d1ef79593132e68e373eec746d13583f28d42730bfa18ed77ee83ad6c3db24bcda6d5e2925970dc01d1968b744cf3753e597ef831dcab728ce66ef3da0ab872cb0dedf77922a57abfb",
        "47ec41abfe34c4ece7ff8f3ba179238f38f3e527d97d7f3f6ada79a9609e715cd0acec31f0a0df25c7ac0bb894fe791cc467a098710e92af75a14e68d9241c160d4587f7da279deaa9cc9d9c5a6e97b231021ab2ba9c63473cf269ef294d1b",
        "5ba802006d999c5afb681f71e83dfd21"
    },
    {
        "78f67aada609c94a7c79f2fe9bf9c82e",
        "9ad46b00946c799b17b683ed3d920896",
        "3fc884334f762cede042a56b4a89ad9eaf474459371f2daf7c157a352cd5ae6d45662593bd3eaba7bf59ed569429c52153599f02e3263b2784be00e52e30d0347553fe8aa70a071c3f2e34593d1e78692f9a194800571eaaeedcf2970784426959e0",
        "80bb105971fd223f89efae15ae1b5e252c7e1c761b6abd5509d8354adbbb5007928763e715aad67b2109ac60afc73e386a75084c77a5af1021ddb4bc636c32a70ee95c6ef5eea9cba0d1c944754f328208ff78f7b0718899bacdf5d6e603e1b098acbffc83a86a0e122078338e0bd5",
        "325ce1b0bb065488f9f74f779bdc433da58412b3834005b4661491e7d9d6c2a371560ca7d649093a7ab2475548edb37b425c23f75eb1bf79b972714469174fc85665dbe2af774719d803c2426f067ae68da1ae0783ae376970055cc28d484ecae2e3",
        "8a0a7c3c7b4ad43021d1fcb532741900"
    },
    {
        "ba4c7e6a36e4684631fa5ede07b678cf",
        "ed722d3769b33d82626ce89bb4d212d9",
        "ae106ad8029d73ff984de16db70772ca9adec5f2bffb1d92e12412b6f76f855463f47f1739d6e9a1fab5a9b7ff3ead419efd7fd7b31a0c5b9b992aa8d0ad754cb5ba371adfc60a5cdbcae37c4653b9cf5f46b015d31a03e10e2882567d2c44255c30f1",
        "1955a221ff4b3f271876a4bc04cfb41449881f6ff3a7e9aacaa1e992a5218af3294027709c1ec594bf863000ddb7d561ca4c3f42340ee932e71eb8efd1b7dbd19f6ef0de28d437355b2b4cd1527cee849a315fc9a35ecb6e458e4af4df07a9e108a0",
        "aa24653b20af5925a19e486d0b28e3bafdb240aa984c8b365792443a5411c8385c8197d0a13f1a8a7686c02cc0f7adbe1230736362afeb3c0ada988dec6d35fd298768866f64aac8dd560250e27bb1007a3fd4c312a8ce3af4af9ed27d5859ae56a3ac",
        "20d20d4a549c35b69af946c9fef1837e"
    },
    {
        "639668e0b0fbb192b83f870048d29c1c",
        "48ed7de6da13ba38a1e748eb9ea57529",
        "1ceca7",
        "604b7b904ba56e1f2d17556236150e5bd19ba125f92e9adef0f75b38356fc9a1851ba34105805cae7e99dc7bdcf8744c44f06e709c345cadcffde348d2d55c5c36cf5ee1f288509e7a878dc00daa3d9593afafd7a0d94fa78960b3ca9fdb2b7d5746d1f4702080fadaf0cd6785373a16ceed056641aa4afe725e",
        "0f5286",
        "fd1206b329ad0eb4ff28d19b3ff31310"
    },
    {
        "94b94725497880ff10d89572b62d1029",
        "bbdb56d8112d298fd5686b93787e0011",
        "f062bbe085b5f49ae4064f9ffd",
        "de189cbb1821775cb97888f25d4781ddb82d4664634f41",
        "d317f2a31eaa3f23e84fc3eaa9",
        "405ce9e1ac0450409dc74017ee3e9e41"
    },
    {
        "8e6f1217eaf84aee8e5897f5860f184c",
        "a4e099068ad0b67f28b6902a40921dca",
        "53c939f8d167e49980f8fd3ccc4a2ae3",
        "4bb7fccecf15f0b32be37860507fc53812713194e2844855894ef916abbf9b5d",
        "92e47292a4f02cc22d3392d1b6a089ce",
        "2cf144c2dcf5a240c3d7be308d29313e"
    },
    {
        "6968acc00e83184e6024167672c5df8a",
        "2d5b193c93e8aa5302fb5bb20cd59504",
        "bd6b6830",
        "7f4e725f4b0f84454e823b8193f1d8b39d78a8b12f1a2250beb0def895dd0aef8960652c071a82d9ad89910d97287e72848fba1623f441d4955a019f5c1a955b054db858722b1f15210c3a752fdbd2bd631620cc56c2c30d78ccb16272eeeea1",
        "c01c9b02",
        "c117560718c083b57522688dc7c6604d"
    },
    {
        "1e7e0ef737799bb1e00ccd4e31da5ff9",
        "9d1111da7d3d329ab5d824404e4bdd60",
        "76cbec797c2364c6ed70901db527c6a3471a84f8d297c64c9dbffd7c3204503ca6e51c8c88757500ed503ba86d7367baf6b9f3f5f2b69308bef97232e67698ae10896ed70a66a7c40115770f3192b9168f66a359270c753bfffc549658fc7aba3d3943221e125a6f88e025cc024b753693",
        "7e6c97d0fee9f249c7510c2a0abf9530ac49cecfffe2ae37c9d38ba60cd012d3e00b696ee54591",
        "b04070df9cc5d032d1914eb69f9afeda61559ed98c7e5fbeb81930b242cd30cf097e4130b0cc45b3e3178ba5ff2598493e1d1fe22fd14f3cc2de08fd8cbb3539d4c71c606adb7826c2a9e05ac36a6795293cdfab6d07fcfdedac099f1ab9bfec63a32f7633e424e684ca8744b4ad2288ed",
        "6f442fa62b719a9c751df52033503261"
    },
    {
        "6dbf15415dae57093e6774f4a1b7e4d8",
        "bba38b490d740d7b3df0c9283d4a530c",
        "fafe1562e69a0f5149e0ee65d14b42098a8a53a58d2cf07fd86f6c64cc4e67d9b5cf3655b5ed7f722d2073a3e9cc8372efd9620a32d6443a328436dd5ae394700ddc171bef8cb0674b1fab87b3e93aa426aee92c7ff733c33f9e4e49f614043a7fb42cf657e4e3c2",
        "c742a929d2a766dde0fb0ce2d0faf790bd6c5feb63cb3126402aac7ef7c9ddfd408cd22bc6928a9b67426e20c3d9b340cd7231f87ffbc29a8e6c23602b9dc434f5ab06bb8c049803b45cf088b919e8584091ecfca7259e0d130ddf4ca45d44291024446f58f1271f",
        "d8dda53eeb8b375930698379836e64014c22bd885b5b5cafb4dc65ed00aa947acb2792c46dfed8ecd155b21cfc98ff163b403e3a9961805436678fd34942354094bc47663165341ed0b949c0ecb4da5499c1c8c87eab99ddfd0fc2d80a9a520461e3dc402c3d4b4f",
        "7298173e07e8c20043df74e45daa3e8a"
    },
    {
        "a6d38f5cebee041a0afe035caad48443",
        "cb7e7813c7018b25782f77e0ae7c84c7",
        "6ef6c5d92f3acf78b3e2c8334038f364a51193e4e559b1458dd74c44269e69a7a6af22f531680c63270b22ee71547d72abc9b87bc5639a1b3a13f8613ad4d1742e8209ab",
        "d536bed277bbb5a9",
        "457fff7d0e1b61def59fbe99e81c08bc370bcac0240c9cec6d6a0de2c37f9950f5b2d12b8b21126af18d757c743a2a9bf451ebcba235f9f48c31a63674f0e8a1c5af5094",
        "7b1acd8b9e20cc8b6b1b4e00ade39ddf"
    },
    {
        "753eb1d49c102d1e3a9bcfbcb1cfa369",
        "0e0cc4395844d363ceccc8a07a92a2d8",
        "5166ac0bdba2b660af164fc847e4ad300675cda9f0acda47567f7952eea7084832f6dbfa0aae9f403a5bbbe307ad40845cb08347588063ad3f1df766790c023f160ce21bdf372fb48e0f7e2ced50cb3f86c2fb257ad7863fadc5fe6992bf1c4508308b259480007a628aacee94c258c91cd847f3d05251dadb96",
        "5f590a65034eba433e57a9d089b2924f5f8482db6a467ea435478afc",
        "f2fa7ed4fccf0388b7bb291977d2214d03dd30c4f81bab2df8f2c1cfaa46ff2fd14733cd7b8fefb6dd020ecab3eb478d1fe0b849e057512fe7b897b171771a2b68d7fe6d9b70dcfbb6307dacba5409b7fdafc49752e4392111474388afb6d79ed21a60c59234bafad676f88f7653765b4dc758c9fd930b2632a0",
        "7132028dd8a57c1343b46370cf9d3ed4"
    },
    {
        "711a437629429db2e14058e2a826dcbf",
        "eb036d6e483a212ff6ee25d970fe1ac3",
        "29937c0efb36ed27fe7709d7179b4f38a2fc191b5e8d9616b58f6dc9ba2ab74e13bbdcd233e8726d90f7ded06c3861582f27158732f997df9091446befe75855ab05b348d68f96e45445f44c31e9ba3e4d7be96d9c8e806535e79079139c71fcc599fea8701e0c2edf606986eff1535afdfa51d1be2dfdee",
        "",
        "4a61f5d6b8e746bf6fb49ca2b16c22f4e9ffcdc89a3137b39bf5445fb6b989d5200f0c8d5538891a5e8979b5cd8c734128b4e4ad98b0cd598c40ec9be74725dbca84c65a52f17ac983330b0b74e4193540f6357c3bcde4e8d8fc6942314ba68115bf2a682756e3c42008803a81532708a0e7b5e3b8436145",
        "55a819d187faaedcc36ee67d6711ee46"
    },
    {
        "a26d6028473bf7de23851d00d514455b",
        "05b87c16ebee8bb62365d265ac6818a2",
        "baeef99e6d4d15be9ff68a5d94aee7afa3d898cf42f94ad572b089659708658534d198dd3fba47a48611e8d78dad",
        "5d77dd8066d3cea3b0762602ba6ae3d1ae1c27d1ebe70bfcdc068912def545362a5bd2",
        "e4365eac2e7b5d02e7fc6c110895bcf193a0ebe28e81d0f6128a95e3e9183582ebb964d666972bd7fff8cd3870ca",
        "ae64db8241b14b8733a419f476469bdb"
    },
    {
        "9bb0e363275374f1771ababb7b96851c",
        "08cf3a6355ffbe621ea874e917729d4e",
        "b380355f794d31e6e85fc81a49fdc2af2104471609692f94c994a710be5cabdc9c9a61b94fc3f76927c1cd5c9a5355a0e8ec55a69ef114b3963ec95137b9ff84240c2a71d3b3459056d1a183eae21cc5a7c109e937faf8f61b6232fa30951f030047d7555b60f85a318833afcea80ee4d88a98",
        "a7fc199cb07b6e5e498dbe590af4a4d95d35b043a97d52e11cc1092c70250112e070e49fcb8a3e7bbfca3d0c4467ba332c0dad277a997f2a603fd2d016979c24b3870a",
        "f8ec2722a9aa97d0cab77f7833e6bddc9570bb79a159feec2dac9d2366e7eabeb9d74ab53a846fd8ad052a740dba39801b681e4da903939387ac3578eec4547dc97c43a8824db11cdae4e7ca8330c9a2d4249853a7285c54498e59d645546a5bb5858b8ddfe37a14242d9750b02ccb41b92bbf",
        "95af5d721f0bfd7b27a782d0aaf37d05"
    },
    {
        "7458fcb1fa1a886924a044eccab9c5b2",
        "30565643aa9bae844b87bd459628d093",
        "4227dc17d3e0ec8363c84b989f72d235d3991e57ebe8a6fcbcab1053edf3b323cbf5f5f45aa142494ab0afe78c",
        "d07afef73f3cabbed475b69fa30aac8af674b74448cfd4d6ecb0c5c1b5b58d0c7173eaee440be65715d780d61d346dede7c52724bd76207ada9a3707c1326dffefd04fb29321db617d12b4a607452a5b197460bc524a40672628e5b9d45f821a5b",
        "50c568868de4b49df40d33e6b25abd6b2dfd2f22bdc12a18ee2407dfe82cd3bfa2fc344c91ba6544e079446073",
        "041f26ad531c2538a44d927067ccc395"
    },
    {
        "68df4e697e83c55c822bb3637bb52d54",
        "1b0df23e69aa907856ccb9ca4d6c51b5",
        "59242d6e2d7e612d2aee7e8c08f53f172e0f93d57b0c08e7cffda90da5b2703eed8192511f6f1bd59e9ae781b4f1156ae06ec38b5bc1f5dddefee49f561d692f832030f7a1b506c0ebe26447b3eab68172e7e7810b13d425f6c78e1d6591cb4a24a61c5f9554a083283485175c18cf5df4ecf2f87c98615de9ccb3",
        "fe9643236be4e7aa3998f44b4336a4c1f8fec28e17",
        "46e15eda413037249e584ea1e3007166d70bf9c998ca2a8386bdb8efde70f3bd35a9b0877e333451f7789f4d8b4e797170445eef5f818bd321574e66b7881cdb546eb5528dce75cdd1683e715b2ac7ad259954bca62d8f0f0066fa6adf50f9e13dbe3ca1e503957cb5f8a2dfce0ca7377ca51989e3d8e5275893ab",
        "e30a9b2a9c38f7b05dd32f2b7a9a44f4"
    },
    {
        "a4b06bbf87393d2b921dcba697274f07",
        "5c14d51c52d95ac040e1060a0ffa21eb",
        "8c85ddd8d3f446608e656052062f0cd58e6d58",
        "847d3b95895426225d08865cc9a329f6f14e63bc5a66fb6f2a05bf8eb9bc8166e6fef29e1d573acdb4c3bc699daeadff7df5d6e8dbe2ef713008afcf9b6e97ce6cab4d90594fa4430ecba5bb62a7938f03d57869",
        "cf6c47fec422ee29226b6cbc5092bf670b5434",
        "4a1025c100318a2c68e072ad1210bae1"
    },
    {
        "50034800a878a3e570364540fc862b77",
        "bc92f50c2630f7fe354399fa9a6fc48f",
        "23a93e636d1924a60f3461de1020b73ba18fc3854c9dc9f166d7d4d1912503bdf1",
        "23d5009057b76a00d92db6b280a3a30ba08ba3afec6312197f06ee01dc4a22d73ea010e02b65af7968d8977f9762ff5a6dde278d8b351d3b8efb32cf7cc8a70a7a8b3d79",
        "2cf9f00b66c63518354ea59510c178d75499866218eb5a031a0dc4d743ac8c05c9",
        "c61a63370e6b5c035e3bfb9fb1f10064"
    },
    {
        "d68448b73ae9bd161c9f1f36dbf6163d",
        "3345d820331958c63dd7a129d3ea0de1",
        "ffa236070dc5b464eb034a9332041a014cd7852b498be2dc498dcdab4151d71f47c7a6b17a176c5999a7574fab5ff469cd02226492a38693eb2296a4a7cc2857b28b5b61",
        "c790bb04036883e6e4a6912a9b0afc36607e12b0d457d4b5f6c120cf0c009caa087fc2710439",
        "1474d60067d082706bb0cd823b22582ddc0fd68412ea0e399b03988e616ac5ca0a7a8da6e6fe29292b57046c289ad8a52360ecd19655bb801c6eaa2ccd66ccb14c4c3748",
        "c9e761ec6154ff8ffe23b4ba0a493b22"
    },
    {
        "519fee7049473c7c41f3bcf7b2f63a69",
        "be227d2bb97f2eef62d5fd9203cb63a9",
        "0c121fbcfb4f4f8f150281140e49d71dc5ed82ac4a30263a6b2d92c55ac6fe4f43f64c0f526d3df642c04a5c51e58703c381701b1f4618cf66e27c60dd5e6558b48028d5fb11339c4f2547a3aefd8100",
        "9ebb3c33eda54164b54bf95d4fbe113333edb0fdd62c24532fbd4cb91b11e08b1e74487dbb0f3daaa08c566e759d53ea3974cc3685ec460e608f7d01fd2dc23d9bc283c73ab492bc9fa2ff458d268667504cd47e585826",
        "c0e22cc3aa610bda350a2ebe8f530c05cafa19e7060b064c276a06f0bb430b79839c51e6b22aabf429616480382c86f8c04ea397c976bb08caf8f35c38208e476787ce229a7a300c5411471548b15d9a",
        "3598cb4a1fab6c5fd50dd1249c530e86"
    },
    {
        "58bd2c73aedb31baca592e42d614c68a",
        "bbf76585731b6334fd314e771d9e404f",
        "d238c5f0677c86c001e66691ea9eb8aee429fc490d38abccfed3a546b5f05398288e7232880fa3d485fe3862c5469f980d9ff4caced1cbbe7f97adc15b6919876b8cbdd35320a20eda8a1ad6e853164b0e0ffb2f702e1d6a0eae8b27577bdd4e5a17e6d8",
        "86147d2debc30111b82c1ccc41a13dab1aff144bf2810695a40d02bdeaf519669a1b81864edf",
        "94fccab0dce48d5aaf42ef59764cba95b42410e2d6b2c87c95d8dbc15421c45d7a556e25296df9167cd46def7d10602aeebd0e7e909c52ab7a22f833e976fb76b9b39b1c2889587582d44ad8f484f0382804d7481f1a8d6c903b13190c213102ae273378",
        "f05d5062f636e08281f4633a4242666a"
    },
    {
        "a27d07b0976574c43edba5619b3c1f27",
        "879f4114bf61f1d7b487bcdff6c90778",
        "302994dba80c2268f5b1c77bfad0b780a9be6437a07dcf1fee61e8e72f7fd3ceac24a01be486a2eddc901a19a0f10eaa94cf46b604f98a90c0f62fa6476d27a338bd046fffc26570",
        "b97a43027c5dcb8a95",
        "633c76783dcb88ff677a6f567685ada02d787eb9aa3a527a45fd415180f1fc19cfddcb90583621c2609558703c7c5ed548650c98e591fac7a692b1f921284ebd8b86d3a1f26f1ad2",
        "0b006ed5a955e5f003177b0ba2c7be8e"
    },
    {
        "d55658dd1f27af02885d0f431fb2ebb2",
        "0aba0b9dfc9831aef0203bc61a601176",
        "05805491b667d9ff38147d96493db29441e188243f72668c7ba61b",
        "df403489e3bb67eeae8440569f6fbc1ae072305f5047c5105a7e4e5349d3732d75572298253f60e3821c721941c02dd761edfb081d09b3c7528a0e786a6fcbab709727e7d614ecc604def19c78fe061040bd636d842b16e96158db07d6c2521ad54778acc78f12b450db0474ef700dfd547f9c5b",
        "2e8adbea0e9ef5068fc3abb39ccef59616420d4fa038e2f35b560c",
        "447db66795e52429222e7a9a717f2e1f"
    },
    {
        "adff46e4d7d78b3db5c74c712534db37",
        "c54185637dd281ebf672393cf9bad28f",
        "b3850ad942e221753e4bf30140eb5569cfd9972246b9a6a35f7a8512db333aec59d380973d6a6505d99cb004dd47b33e32f4f238b1342e6756d3619414c31bde45",
        "59bc7a834189b930c8cbff769ef63b5e1a08c352ed779853b36bcd3d0ca7b4e35bd6cdaf2538ebf0e3a0d7cbcf3bcd2b66b910967c226a1da42f84c4a8f81e19161c6593e2c0a0fdddd3c6ab3a864037fbf976e8aebd33d4450be9893da2e37e728916b663944e3fa6ba543d1010",
        "5cc93a30fd8f71befd87fc50112c156b53abfc97466f36e3315915a7d4147f0b3641177b9d08ec13e7315957d078ec73eb0a93a3b7a51e3db63a396e6ea2adfba7",
        "96092f8845da1cdaf48c7e76c9dce580"
    },
    {
        "4a5d7c201ddae018edc9783413dd0329",
        "eb7e038948d3bf61d2cd29d2fe722603",
        "3e6a17d47db58690b895619128645a2782d17e9a3735c1450a7c8e13a9f212208fcf256f",
        "65b8cebd83d3197118fe81dddce22b3947653e04a48d05b4a2dbc42a89e62b0d6b61d5f31487af",
        "a1a858d13540281e1d0a9a82e3caef64ff742e51b1f7476d318729508a68840b371fd300",
        "108023763640241ec06ce1c24c061c10"
    },
    {
        "83190fd90c68cf63648dbc5daa442e3e",
        "3c3683fb5d3f1446f8c0d0127fc59d5f",
        "a5136deb0a795dccc18889c23e9bb21640864981a4ecd903e8fb62",
        "13066ef4f97501fe1854da6e2d57ed43e4c074ad45b7218536e7dd8368a4ee8c6f2b63199fc0a9a679e2b198bd3a43e6e8bbd6",
        "0c8cc3bde1f4933729293718686301b1ce50f5e7521655016f8432",
        "95a1ce7284494c9c8cd76a4639b28b15"
    },
    {
        "05bed4c00afcb8ecacda8daba02585a1",
        "ed014d4e9eb504c70d5d3153473dc146",
        "6fab5ff04c5a74a0a96948501de9167597a42fde4c50ab27719dd1e2b0e0fc0fe6e48e97c79d2a71fcb5e7ef60c67a32bf865decb39bf5ac17969177b2fac849a38e08bbaa3be0d6dcee9ff685ba97e9b54514624d51c270065508c03e96f28667e3c79f6a68859a85048301779da7e2254b1bd1662ae3ea15e0332c",
        "ebb614315ba4b7d69632656d5a4d2810112862ea3e443148100bf2e89d059bc9e2d9563bf34b823c57108ca9a88e4b07441f0ceca4713e2af56f40f35d6f2223d37e9eeb61739a65933712763104a67488d2022a5e033e240969a4d33966b4527035eef0970c69660ab3ee5c00ac815a9ee52d767b0a937b",
        "6edcebf7ac2cd10be8a9a595a00e68e2d3127f5de640323791229141caded658e99fa59539077027ed7b7a433a794bd523ec59f504978964d3e17eb388956e43395ec89b252a93b317c64580426d1ab0b633a972524084be5d4886458718ed42f47967eddabdf7b2f440818e0aab9d932c10a4c7283d05b84ef74a6b",
        "665b4064bda8f0511fa2aa35ff2e8abf"
    },
    {
        "53e1b8de6176c05e04f5a4787e733b3e",
        "574de8c0f914115c9267f7852280fbe8",
        "0ef099d6995b41d4e9227c3aa59da313160afaa32e1753422c1eb45bf102e806aa996a54606c78320e85da74deb39e8b0059bffe32780ec784abf6bd540d3c01e9f13c4209bec2",
        "3d9ca3718f31b4f37f988ec676fc3b5492a44792d1a4f8fd7cc4726fae899f102841e7f5c04b2ae2c5f9eb204c5b74222d89c2bd36b1500b2dd81e9643142becec1b88aa7a0d7ea4c81fb7e8fb37ec1a58e0383e",
        "5cf9292077dbcc9557a1cef51de815facf02a89c9e29ac62098c8e4d0cb49c4f55ed55dd9dc9c36a634ceb8f4dd475837582b9be1c17030c0546b335be95fded1c416e4599851e",
        "e9649f102df1224cc20c24fd54b096d3"
    },
    {
        "81118e9376e515a93dbdda15e58ff387",
        "75a0f02a8e78a0d2d0097cee863aa576",
        "f30c353db4dcb2320ba5fba118e50526800fda7ebabef05bdf15aee5d9b70f2ab697937d77a01bb4bb460fcc4233acc3b970f4f434e9ea85f30aed7d247115fc5db1c333ac6a008dfe65ee02b930ea097d046f2923bf84785d47f382b19651948d69a6e4b861a7112c4e1804f6435f70",
        "6f75857a795e6aff71994dacae41c2b2d9d6d7e67fbaed6d2e20bf89da461f509ef3d284341a8a2059ef1b97e9e6820f1a72ad703e71999be36fd7156d3e3f35663eb4db44a858e08bceb154af51360feadf3bca8f20",
        "0376339c7324168426dbc1f36ee91603f844352817b575ffb25ca6a75e2d0f0d77d853230b7e5a4823195c406298bc3781b40df001d9cfdff16de970df4ffd0aa652fc7732c6311e2665daad93bb2576d43e1a58837513c62a8b74cde75901f9520a29a10e4dad9e4aa981c5e72d6cc0",
        "2d9d3d20dd304d1277deaab457404f5d"
    },
    {
        "2d60824c89bbeb4e2b72434aa0356587",
        "20ad2c51679a7246ca6d0a47ba7292e8",
        "17aa9ed83ff674f959085ecde2a6c5026325265a143d2c772337056a3c66abb5d742f33be39697194fb1",
        "283fa29dc399d07116e43c85eec0adc8a76221669a9bba6554f8e828b680",
        "40fddfe3b15925fe189b25aeb6616538958d43f0c64806f6286a5efc8a4faee98d02314eace7619bd2a3",
        "270d30239c0a9afd5edc28db8323ddf7"
    },
    {
        "e2e2a29db958c6a3f68a52825b844c2a",
        "3210fe0cede911318435fefee1d921d9",
        "45f5fc3a",
        "91209d1202574e",
        "2067b789",
        "eaee3477b6cb3b7a6df8bb4ad493504d"
    },
    {
        "24affb4e364dfcb9be823bda04cdf045",
        "d7db8f0fd20b87ea4ad5e85e026b4b42",
        "296e2b8040a3907fbd8789f660f85f3b49c6050092029a2b",
        "42f31798f0016547fc9126a6919c14fdee91bc68f839dabb24d2249ff5e001b6a2308b57bfa6baa84e635123e8c2110c",
        "3af391d72e60751b10d3f009814673d64cb86a0dc998cbf5",
        "c16019a549f7c6dabf5bae70461ca9e0"
    },
    {
        "e8d14e976fed8be59625b034419fde86",
        "1d3a06b7b80217caa5a4e237c2b94549",
        "fa2d4f764e7399bd346f60f1cee797a9624809373daa3803cdb12717fb48503263b21ab1d99dfde20d588458993d8c33384e897973a9dd74bb7e308c8fdd6a46a9",
        "8c0c2e14cf2ed5c7147d8c50b4c28b232a80247344f21a61dfe4065fdc559200b7a0046e58606e3a3615ff54bb605e7a5f001d215de255ba75366f6be3dd1fd4858aa9e8904ca99647387b1a17c7ff",
        "9427f3a18a22e801a3d7d863cccf4fc8dfc23a51bffab61235e2bdbae311ecc321db38128730818cec04f51ba5f0c3e6b7327402a2a63c95c184f7946756f2c94e",
        "5c9d05bdd3ce8ed1675a13b91c013ec9"
    },
    {
        "73e9b0ca8fb59181dac10130454e3a7c",
        "81c9a08c95fb942c42003aff680b11ea",
        "971adb65be3d885bc115724cc33a0f53aa47606e7bd5",
        "03cc2f305af325f4fa14de7ae8e89a03d040e812f0f4a7f82d72441d83b85a424f3ebc34ad",
        "18ff36eaf9e6f49530db6f886fd85a77d55289d85fcd",
        "7a4a067de96099b4960e5557853d7ad3"
    },
    {
        "59f15a1479f5dbd9c1b879475de9d2e7",
        "060ac95c956235bcc003dfdc92da5d89",
        "a17b5ffce4cc08b23a8b8cd7735e11822f9672691b4dac380835729694f39da377e4d3fd23ef7b8b40a355e271bbfbb8cd632481c7cdb67d99d314609174b10cf370fd9b9ab872346c631127f873573ef61776bb8e154b55bab6d84544cd8fe5f7611840a057",
        "9faf2f97e14d2be029",
        "3a4986b25ac4ebbdf8c62e74790e79f860c5c131f68b540a7a9f0504cbbc36b7484fe76713a53f354f4970613a976a4cc55ed7480d5c5acf876977b74e622926c8309b65a5edd3ea2ad7c2805f2859ce1e2805577d409760b2cf8e84cda7097478491bab3fd9",
        "6628578d2684a14196e13b66aef300b5"
    },
    {
        "5dc5206e6145ce81ffbce717cb425955",
        "a7a6fda319439a67cb679b3cc6076dd7",
        "4244fc95829a69089920",
        "92f48b403ce97f87118605d24314981ec34b958ca0036f0b6acef5e20bfddee370e13bb2cc676dd8d4547668aacc7dfde6af12727789f6ef811e63b391cfa9c4a68ca89e6bd978f38f9228dd9c24e968c4e59e3d34963d6ee942f788e0b5625ad95bd3eb6ae67ffcaf2e4ee9a9cbbd15c40385ae",
        "adc2915b7813f367bd80",
        "68bc6d846f575ff95be003316e804197"
    },
    {
        "8d88268afada2ee19bdc754147d6b04f",
        "119588763bcbdec984a226e9dff179ce",
        "04deb10354489349a273c5cd5d02ee1d71cbda2a20743bdc2cbc48788b9da779ad2f3f1dec4cceb3132b2e4a1c4302c8f9ecd1d37fef",
        "0f32a44fb0edff2f0d2334029e59715f5fe2b8e896068b8488f43b567c0d6fa3de5bfa99c6c8f055e3889309e08822eea3a683d6907675b6f0072438be",
        "bda6c7381492f48849c00a86ba72c8162c09981f593547682b88b7bc6e051a9ab9fa1602e879b8f1e5145bb6192530e7faa76be34dc2",
        "8d844a27362f2e01d293d6b603137747"
    },
    {
        "0049493db4ab12f83fe50f0fb2a88961",
        "fd0dd2556a03ebe50b41446250d56e52",
        "1d3139deaf1046e234189942c2249a7aee9d644f934e6a203a8a69e7683557551dfade301cef8abb29d7308c5a2893a52ce6b1493bf2232606e79c0ae51b0a55cfc0434f2e669cbc56fe7176fd04a1278918c14791e00f88de41d563d3",
        "4c92be6ed0634323014b9ae5c9401f751c5b710c12df357a694c1c25d906ab3beb5bbaa002208e787f448dd0cef84d3d",
        "dc3bb7e4baadeb7c32f70cef3144d04ad199ec429ca6b695f87f997c6e5db58e9d60b34d89ccfe49d5e62c267a871ab7818137f523cde68036ad1d8f7db0b80286ceda9734b32ad73f7f0eaf8d19c80fe74866c1cf785f44513b918a24",
        "3a8877ab87645275262e033308c649cc"
    },
    {
        "b6279f439261d1dfa4b85151caa60e75",
        "d0b003ce641633d48413bf3bbcde6b5c",
        "39ee6f13a66b4ee74cda034a3bfed3fcf36f101f1e5b646d1c93e019174e4bd850417fcd5755264476124a5ee8e68cf2fcb9fba50f872fb1d33a025f8c572b4b5ff034d9ad77ecd33981bdfe3e9554253522",
        "c635cbbf8eace8f911d093544536f38fcfa14b78b1e1eb069c42a351cbc70b7d1f5e93bceacadaf0c9198d3b2ffe54db45cfac70c05d4aecb0c801194642cc070ed223a9e3b65b735af796373db7fb6e3285ee3fd3579dd74be0cd2937f6f825dc3bd77ff7674b06a9ac",
        "9787ff29777e12f86c7281c57c5a345278fa96d8fc6ed949be284bb79f97b34da9f256a6be673ab93829492159e7ba1a19dc727e16ec57e388447c6616626c6af3412cc70432c3dbeafa35b044e7e53456c1",
        "1195abca7c171994919b51baab3e1427"
    },
    {
        "81d8c7bf41cb0e54fa51899660637877",
        "044d29eb40264aa36b976a766108ac88",
        "4712680db09039894cd72e86db111d63c4bcb62058f84f83ef419cc21e36f2169ca340375ff69f9280fa60c99d86a03dec4673901a7029784be2cdae3f63590da312a448d24eef063304545e553fd01ce6ee088e43c8b02c51b155bada983ea1aca4bad804406aad3c92ac75ce4c",
        "897f0ea8d69b962913a9a59ca36b65aa7aefe39d3a",
        "1d5cff8679946302451dc9aed1c601ce46a6f31ef17a53af6ab130605cc2a41da08c932a13b72983ba8cc58376040cc17e3182993dd593f4fc8f2965825173656325942e97db98c584ff0bc913633888a0812ea7675d130d690f9fe8d6eb7f1655de1938fa0163b02c50c8a122df",
        "708706c87c1438b7b1410ac9cf4d533d"
    },
    {
        "8d35dc035a1039af8f3dc653857cef8c",
        "a0df1b717a186cfe86a0ac8343e80217",
        "572bf5295915e7b2f817bd137a6608e09fcb7bad29887b9209eb29e944f2d3231717f9a112e68756948c1fc71dcf6245a0130bbffeef74ccf3ff3860ca5a23753f7539b7a268fb08434b73ba9adc385e6f9ccbfd213f812d7b64d8d6d7bfce1e236c5fd857",
        "94714396e2dc4bc13a6d628563b0db14e189695810a4925a90826de63327942db0508e7453",
        "6f2364c357e257e9b412018a1c702f0d0c1170751393b1f73999f77927d4ec1454e78eda131af56b1b46e348f8775e6a022a746b31ee135651bb2a14e21cbc3f333c13df02a3de6d5128ff1145514605d98e984c28dfa89cbfd2f0d8bc41af3e4c73e7ddc0",
        "b2f8984bed67bcafd95cb0174ca56983"
    },
    {
        "4666ffed66ee2dc3ed18e6345384e828",
        "8c5c38610ee79b818c18e95ed2baf026",
        "dd2baf24c168f99d1868712a43dfda4717650c26c36378127800d8cf",
        "196a5357a0d6c588acc29f85cf38b78b61e0810feefb965d",
        "a58828aa09a6f25e7d4775ba7a2b303085bd5fb43cd61bcd19c8bb8a",
        "e4a45e0440c6f9caee3506b37d1f8563"
    },
    {
        "2d5464646342ceb3039a9d2fa406b90a",
        "8f045fec196343f938902e1bf706e34b",
        "260ab30c42d3356dc39837b28f6f387accc2527aa853dd58f54426d52cdb9ffc0a5ca5a5c00761a7299e72d48874b46ffe18dfaf38f19cfad76d7c9cb4a4cd7784cfb125a58673972b4bb8c894da2a8969f68cb27fab746f8d62fef60664900833dfca7e0be03eb5908f12e74bacda9d35b06e",
        "d4aa5263a31fcc8ccc9e1127f7ba6ea2d3ccc72cd7e98e442890ad3f8763856d90e362",
        "51ede001d1e4ca8a3de43186651a011cd14f4bf93e9375e910a8974ea411343b68e8f6ce80cfc945ae7d9c5adf76e1c0f93de8f5dc48f36b82b65886776f1298b36a2f012140da048da77e09e4d57426abe2b894c425aeb2050b0eea2d8f8255b733bb814abf3ef3d530d87dd7e1504bd683f4",
        "1d4873bab95a220d094a6e88a670f40e"
    },
    {
        "723efa25ce1bf1748d86d9da611be9b1",
        "aff260690905ed2e8618c20963e4b7c9",
        "f7e3eb593d3966c015d63ea0e9211beceb8fa6d9a202bb4fd4128c3177c5",
        "3950b62147fc16429392d41cc4188d5c82537204e93edc7abfe7ce3404f9aa1474ebc4acd8e18aa652a87ee99c2415f9214963becd44720684f67aa814903cde",
        "9d7ee643a2cec28c467d2cc88aa539341dfbc82f72b5d940feecd11d4a7d",
        "5339cc409bfce5820fc99e143ca59b4e"
    },
    {
        "784197d89800aad00105ff7487b6e5df",
        "fdded94dfbb72c77ad81b2ccaaa2de2e",
        "b14ad4fc08d08cb0601289a7ff9127f26c4036606a50bdd2921baadffbc75749b8ca33ddf7b6ac",
        "b82cbea4eaf532d52046bf0bfaf22ec2",
        "a625b4da553686296d5c6f5ce526c4f84c4af779c67cd328c16a7985c9a28737130da855b1f3aa",
        "432c4f4a125b6444091384042e3defc8"
    },
    {
        "4dda1ff559520020513e0a8e554da28e",
        "8b183c7e23130aade134ff8e539d8053",
        "e56d6364a87fb7f40af02b672fd337705ab8a02a5fbf2c2a639a872da16895774d90658269437160cd22d7370ab0fd3e81d746",
        "675b6d9e6c4c479798038b06561f1ac0dba2ce54988efa3393cb6265d901df1f815937a6e42db8c64c76dae0c8aba0ee20",
        "0b2f31b8b15ec535c7e8c732e91f4e119bca192b1fe2eaabdac037dd1568e4a8d786c7048c16ebd4c513324b18ac9ee0281fac",
        "2bc20cf2d6bbe36d379f794824ad190e"
    },
    {
        "66dbe969ec0adfbe1b99874de53417d8",
        "13ee71e9dc02d592700c04ca0bcc6344",
        "fb420a6751909185796656a952759b4b794bd4eb98c82456af4f596093f5615962e62a9ce3fd9c4e0cb31a649cb5c17d30f66ad3d52e16589b174102cb5ad9973ce03f44cd3776e0d9c538d255ffe81ddff81e06cff8e4d8adef4f08cca416d52ee3aade52341e5cfb5de80c71",
        "db499d6cf13840accc40e3d14733662885768f7541b2615138c498b087e51b20f1c0c373a589b510de546d372a40cad0f92ac3f6f7bc1b85290c4553c83b",
        "7a7786b03d18c1f2edb2d9015da13a327f364895751c32b8ab840079b08e47870b4ecb49474d2da2bc0a53977aeb4d63f3b4e56f6a3d22ccd64fbe098fb9b27eb5e5b1f179ac69eb3d57175bf9ee37345e6f48161adcaa27bfb5363889e38cf7297b3fb9b41a0d61e751ca5184",
        "559c1df2d0a7807a79a160921835eddd"
    },
    {
        "3a00ee1e8877248065cd26e3b9a857de",
        "950529b19697df5b0ce43a3f429e9509",
        "d6fdd1746e8e7c7b84adef010951f60fd19b5aa74b1a8ab1ef2dbd5487318fdf7844b436dd1063f10e609bc58604ada5c41ae2ea1b5303f84c",
        "30a5f3a4e4543dca2b4d53a59a6a11b97a7d",
        "06ffcb4a0da10ae1a5a1c5b6205ccf4882a9c796370e7793d9b3ff3a857c156b3285e3dcc2181d8c0df26167ab4f8709db6870c9e10e75b90f",
        "a89ee72561154c209fff00ae7634f4c4"
    },
    {
        "b611b23912f0c44c8f0a452e181016a3",
        "aa0321dae967b75f958a3949fa08fda2",
        "16320a4eabdcbbb1e600058d308cd8aa650ec35985906489d1ed3210ad402589b33de4a68088cec878461e54ce60ebac399457d4f4ffaea77fef304f9363817fd797afac854d0ca313321fbaca4b0f",
        "d0b0ea43a3fcbcf70e5d4b21ad115e503ada6f43a74a0585481b249db3c00645f06005b1b3da91600a14a40ae5c045127cf8cb6bcb",
        "39f3258b852471d9b9a289027f26c3a7e49fa8cb61983c429b3b306edb1f0d34d9718774005d71ef2e89212c6c538f647335d85a2d0b4c72b97a7eee96d5b6976a602d82a294bc2a4887b16aa327f6",
        "9d35c571446755b395fdc634a69e25f9"
    },
    {
        "2ed2ab0c5548c1e97879a6c3ec7ebadc",
        "3e15d94c7dd22593caa8be653b6d59d2",
        "76b1d92662d472c87ba9b27e2756cf62513ec190f709996e",
        "f1e64c14a92e952036305ceef2535f65295b2803f7396a5e88f2ac993e201782e2f1edba92011a1530278b6d3d1c9a",
        "8c9fe2da6b58f0a9d40609bfd9ac6855badaef814588ebc8",
        "a13ce63402a3c58949a7c4cb8a2b7d36"
    },
    {
        "37263267c4f24129d9db09a2a96d7c14",
        "39e5c4f2b36c9ed5077765b89cea1bed",
        "3581b4424c",
        "6ea6a9f99350a38601162f2e24928ee2",
        "9ace0569f7",
        "b194fe3eaff122ca4bcba925f4013320"
    }
};

static int
tv(void)
{
    unsigned char      *ad;
    unsigned char      *ciphertext;
    unsigned char      *decrypted;
    unsigned char      *detached_ciphertext;
    unsigned char      *expected_ciphertext;
    unsigned char      *key;
    unsigned char      *message;
    unsigned char      *mac;
    unsigned char      *nonce;
    char               *hex;
    unsigned long long  found_ciphertext_len;
    unsigned long long  found_mac_len;
    unsigned long long  found_message_len;
    size_t              ad_len;
    size_t              ciphertext_len;
    size_t              detached_ciphertext_len;
    size_t              i = 0U;
    size_t              message_len;

    key = (unsigned char *) sodium_malloc(crypto_aead_aegis128l_KEYBYTES);
    nonce = (unsigned char *) sodium_malloc(crypto_aead_aegis128l_NPUBBYTES);
    mac = (unsigned char *) sodium_malloc(crypto_aead_aegis128l_ABYTES);

    do {
        assert(strlen(tests[i].key_hex) == 2 * crypto_aead_aegis128l_KEYBYTES);
        sodium_hex2bin(key, crypto_aead_aegis128l_KEYBYTES, tests[i].key_hex,
                       strlen(tests[i].key_hex), NULL, NULL, NULL);
        assert(strlen(tests[i].nonce_hex) == 2 * crypto_aead_aegis128l_NPUBBYTES);
        sodium_hex2bin(nonce, crypto_aead_aegis128l_NPUBBYTES, tests[i].nonce_hex,
                       strlen(tests[i].nonce_hex), NULL, NULL, NULL);
        message_len = strlen(tests[i].message_hex) / 2;
        message = (unsigned char *) sodium_malloc(message_len);
        sodium_hex2bin(message, message_len, tests[i].message_hex, strlen(tests[i].message_hex),
                       NULL, NULL, NULL);
        ad_len = strlen(tests[i].ad_hex) / 2;
        ad = (unsigned char *) sodium_malloc(ad_len);
        sodium_hex2bin(ad, ad_len, tests[i].ad_hex, strlen(tests[i].ad_hex), NULL, NULL, NULL);
        ciphertext_len = message_len + crypto_aead_aegis128l_ABYTES;
        detached_ciphertext_len = message_len;
        expected_ciphertext = (unsigned char *) sodium_malloc(ciphertext_len);
        assert(strlen(tests[i].ciphertext_hex) == 2 * message_len);
        sodium_hex2bin(expected_ciphertext, message_len, tests[i].ciphertext_hex,
                       strlen(tests[i].ciphertext_hex), NULL, NULL, NULL);
        assert(strlen(tests[i].mac_hex) == 2 * crypto_aead_aegis128l_ABYTES);
        sodium_hex2bin(expected_ciphertext + message_len, crypto_aead_aegis128l_ABYTES,
                       tests[i].mac_hex, strlen(tests[i].mac_hex), NULL, NULL, NULL);
        ciphertext = (unsigned char *) sodium_malloc(ciphertext_len);
        detached_ciphertext = (unsigned char *) sodium_malloc(detached_ciphertext_len);

        crypto_aead_aegis128l_encrypt_detached(detached_ciphertext, mac, &found_mac_len, message,
                                               message_len, ad, ad_len, NULL, nonce, key);
        assert(found_mac_len == crypto_aead_aegis128l_ABYTES);
        if (memcmp(detached_ciphertext, expected_ciphertext, detached_ciphertext_len) != 0 ||
            memcmp(mac, expected_ciphertext + message_len, crypto_aead_aegis128l_ABYTES) != 0) {
            printf("Detached encryption of test vector #%u failed\n", (unsigned int) i);
            hex = (char *) sodium_malloc((size_t) ciphertext_len * 2 + 1);
            sodium_bin2hex(hex, (size_t) ciphertext_len * 2 + 1, ciphertext, ciphertext_len);
            printf("Computed: [%s]\n", hex);
            sodium_free(hex);
        }

        crypto_aead_aegis128l_encrypt(ciphertext, &found_ciphertext_len, message, message_len, ad,
                                     ad_len, NULL, nonce, key);

        assert((size_t) found_ciphertext_len == ciphertext_len);
        if (memcmp(ciphertext, expected_ciphertext, ciphertext_len) != 0) {
            printf("Encryption of test vector #%u failed\n", (unsigned int) i);
            hex = (char *) sodium_malloc((size_t) found_ciphertext_len * 2 + 1);
            sodium_bin2hex(hex, (size_t) found_ciphertext_len * 2 + 1, ciphertext, ciphertext_len);
            printf("Computed: [%s]\n", hex);
            sodium_free(hex);
        }

        decrypted = (unsigned char *) sodium_malloc(message_len);
        found_message_len = 1;
        if (crypto_aead_aegis128l_decrypt(decrypted, &found_message_len, NULL, ciphertext,
                                         randombytes_uniform((uint32_t) ciphertext_len), ad, ad_len,
                                         nonce, key) != -1) {
            printf("Verification of test vector #%u after truncation succeeded\n",
                   (unsigned int) i);
        }
        if (found_message_len != 0) {
            printf("Message length should have been set to zero after a failure\n");
        }
        if (crypto_aead_aegis128l_decrypt(decrypted, &found_message_len, NULL, guard_page,
                                          randombytes_uniform(crypto_aead_aegis128l_ABYTES), ad,
                                          ad_len, nonce, key) != -1) {
            printf("Verification of test vector #%u with a truncated tag failed\n",
                   (unsigned int) i);
        }
        if (i == 0 && crypto_aead_aegis128l_decrypt(NULL, NULL,
                                                   NULL, ciphertext, ciphertext_len,
                                                   ad, ad_len, nonce, key) != 0) {
            printf("Verification of test vector #%u's tag failed\n", (unsigned int) i);
        }
        if (crypto_aead_aegis128l_decrypt(decrypted, &found_message_len, NULL, ciphertext,
                                          ciphertext_len, ad, ad_len, nonce, key) != 0) {
            printf("Verification of test vector #%u failed\n", (unsigned int) i);
        }
        assert((size_t) found_message_len == message_len);
        if (memcmp(decrypted, message, message_len) != 0) {
            printf("Incorrect decryption of test vector #%u\n", (unsigned int) i);
        }
        memset(decrypted, 0xd0, message_len);
        if (crypto_aead_aegis128l_decrypt_detached(decrypted, NULL, detached_ciphertext,
                                                   detached_ciphertext_len, mac, ad, ad_len, nonce,
                                                   key) != 0) {
            printf("Detached verification of test vector #%u failed\n", (unsigned int) i);
        }
        if (memcmp(decrypted, message, message_len) != 0) {
            printf("Incorrect decryption of test vector #%u\n", (unsigned int) i);
        }

        sodium_free(message);
        sodium_free(ad);
        sodium_free(expected_ciphertext);
        sodium_free(ciphertext);
        sodium_free(decrypted);
        sodium_free(detached_ciphertext);
    } while (++i < (sizeof tests) / (sizeof tests[0]));

    sodium_free(key);
    sodium_free(mac);
    sodium_free(nonce);

    return 0;
}

int
main(void)
{
    if (crypto_aead_aegis128l_is_available()) {
        tv();
    }
    assert(crypto_aead_aegis128l_keybytes() == crypto_aead_aegis128l_KEYBYTES);
    assert(crypto_aead_aegis128l_nsecbytes() == crypto_aead_aegis128l_NSECBYTES);
    assert(crypto_aead_aegis128l_npubbytes() == crypto_aead_aegis128l_NPUBBYTES);
    assert(crypto_aead_aegis128l_abytes() == crypto_aead_aegis128l_ABYTES);
    assert(crypto_aead_aegis128l_messagebytes_max() == crypto_aead_aegis128l_MESSAGEBYTES_MAX);
    printf("OK\n");

    return 0;
}
