"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const promises_1 = __importDefault(require("fs/promises"));
const os_1 = __importDefault(require("os"));
const path_1 = __importDefault(require("path"));
/** Creates and returns the path to a temporary directory. */
const tempDir = () => {
    // fallback to random directory name in test directory since Windows cannot write to test directory for some reason
    const dir = os_1.default.tmpdir() || 'test/tmp-' + Math.random();
    return promises_1.default.mkdtemp(path_1.default.join(dir, 'npm-check-updates-'));
};
exports.default = tempDir;
//# sourceMappingURL=tempDir.js.map