--[[
# Copyright 2001-2014 Cisco Systems, Inc. and/or its affiliates. All rights
# reserved.
#
# This file contains proprietary Detector Content created by Cisco Systems,
# Inc. or its affiliates ("Cisco") and is distributed under the GNU General
# Public License, v2 (the "GPL").  This file may also include Detector Content
# contributed by third parties. Third party contributors are identified in the
# "authors" file.  The Detector Content created by Cisco is owned by, and
# remains the property of, Cisco.  Detector Content from third party
# contributors is owned by, and remains the property of, such third parties and
# is distributed under the GPL.  The term "Detector Content" means specifically
# formulated patterns and logic to identify applications based on network
# traffic characteristics, comprised of instructions in source code or object
# code form (including the structure, sequence, organization, and syntax
# thereof), and all documentation related thereto that have been officially
# approved by Cisco.  Modifications are considered part of the Detector
# Content.
--]]
--[[
detection_name: SSL Group "334 part2"
version: 14
description: Group of SSL Host detectors.
bundle_description: $VAR1 = {
          'Sears' => 'Department store retailer.',
          'Vanguard' => 'Investment management company.',
          'China News' => 'Chinese news site.',
          'Infusionsoft' => 'Software company providing solutions for sales and marketing.',
          'CDiscount' => 'French online retailer.',
          'Clear Channel' => 'Aggregates online radio broadcasting.',
          'Moat' => 'Ad search and analystics.',
          'schuelerVZ' => 'German online classroom / social network.',
          'Joomla' => 'Content Management System for building web sites.',
          'Intuit' => 'Software company for financial and tax related services.',
          'WDT' => 'Weather Decision Technologies, a company that provides weather nowcasting apps.',
          'WordReference.com' => 'Online dictionaries, translator and word games.',
          'Reuters' => 'News portal.',
          'Kohl\'s' => 'Department store/retailer.',
          'Home Depot' => 'Retailer for home improvement and construction goods/products.',
          'Food Network' => 'Official website for the TV network about food and cooking.',
          'CloudMe' => 'Web desktop service.',
          'Shoplet' => 'Office products retailer.',
          'Kay Jewelers' => 'Retail jeweller.',
          'Kogan Technologies' => 'Australian retailer of consumer electronic devices.',
          'Gaia Online' => 'Anime themed social networking and forums website.',
          'Discover' => 'Financial services company.',
          'OwnerIQ' => 'Advertisement site.',
          'Yandex' => 'Russian search engine.',
          '247 Inc.' => 'Advertisement site.',
          'T. Rowe Price' => 'Public investment firm.',
          'Neiman Marcus' => 'Luxury retail department store.',
          'Playstation.com' => 'Sony Playstation related e-commerce.',
          'American Express' => 'Financial services company.',
          'Dillards' => 'Retail department store.',
          'vente-privee.com' => 'Private online shopping club focused on fashion and lifestyle products.',
          'SimplePie' => 'RSS Feed.',
          'Skyrock' => 'Social networking site popular in France.',
          'Washington Times' => 'Official web site for the Washington times news portal.',
          'Ancestry.com' => 'Online family history resource.',
          'Crutchfield' => 'Electronics retailer.',
          'DCinside' => 'Internet forum for photography and Digital camera.',
          'Redmine' => 'Web based bug tracking and project management tool.',
          'Ad Nexus' => 'Web advertisement services.',
          'Guangming Online' => 'Chinese news site.',
          'Motorola' => 'Manufacturer of mobile devices and telephony equipment.',
          'Zales' => 'Jewelry retailer.',
          'Letterpress' => 'Word game for iOS.',
          'HSBC' => 'Global banking and financial services company.',
          'Viki' => 'Watch and upload movies, TV shows and music online.',
          'NPR' => 'National Public Radio - Associates US national radio station to provide news and other programs.',
          'SpeedRunsLive' => 'Online gaming.',
          'Ad Master' => 'Advertisement site.',
          'Wimbledon' => 'Tennis related website.',
          'CBS Sports' => 'Sports news website.',
          '39.net' => 'Chinese health information web portal.',
          'Flipkart' => 'India-based shopping site.',
          'Webhard' => 'Online storage service available in Korean and English.',
          'ESTsoft' => 'Provides software tools and online games.',
          'Daily Mail' => 'Web Portal for news update.',
          'AllRecipes' => 'Recipes and cooking guide.',
          'Weather.gov' => 'Weather web portal.',
          'Xunlei Kankan' => 'Chinese webportal for video-on-demand service.',
          'The Free Dictionary' => 'Online dictionary aggregator.',
          'Ameba' => 'Japanese blogging and social networking website.',
          'REI' => 'Outdoor sporting clothing and gear retailer.',
          'Kayak' => 'Online Flight and Hotel reservation/deals website.',
          'Western Digital' => 'Data storage company and hard disk drive manufacturers.',
          'Publishers Clearing House' => 'Online marketing company.',
          'Flexera Software' => 'Software tools for creating packages with compatible to cross platforms.',
          'Admin5' => 'Chinese directory of web admins.',
          'studiVZ' => 'German online classroom / social network.',
          'Tmall' => 'Chinese web portal and online retailer.',
          'Lineage' => 'Online game for multiplayer.',
          'Associated Press' => 'Official web site for the Associated Press, non-profit news agency.',
          'FileDropper' => 'File hosting and sharing service.',
          'Rackspace' => 'Virtual and physical server hosting providers.',
          'GOMTV Remote Control' => 'Mobile app that allows for remote control of GOM streaming to a television set or media player.',
          'Naver Blog' => 'Naver blogging app.',
          'Libsyn' => 'Podcast hosting services.',
          'VKontakte' => 'Russian social networking service.',
          'Evony' => 'Browser-based online multiplayer game.',
          'XM Radio Online' => 'Streaming audio.',
          'ShopNBC' => 'General shopping website in association with it\'s related televised shopNBC broadcasts.',
          'UOL' => 'Brazilian web portal for news and entertainment.',
          'Blue Nile' => 'Online jewelry and diamonds retailer.',
          'California.gov' => 'California government official website.',
          'Fnac' => 'International retail chain focused on cultural and electronic products.',
          'Disney' => 'Official Disney website.',
          'Ganji' => 'Chinese website for classified information.',
          'Zappos' => 'Online shoe and apparel retailer.',
          'Tvigle' => 'Russian Video syndication website.',
          'TD Ameritrade' => 'Online stock brokerage service.',
          'Gateway' => 'Manufacturer and retailer of PCs.',
          'Slacker' => 'Internet radio service.',
          'Sky.com' => 'Web portal for news.',
          'Chosun' => 'News aggregates from BBC in Korean.',
          'VLC Media Player' => 'Free and open source media player.',
          'Scribd' => 'Web based document posting and sharing service.',
          'Salesforce.com Live Agent' => 'Salesforce.com\'s live chat support service.',
          'CNBC' => 'Official website for the CNBC channel which is basically meant for Business and Financial market related news.',
          'BigBlueButton' => 'Web conferencing system.',
          'TwitPic' => 'Site for posting and sharing photos and videos on twitter.',
          'Walgreens' => 'Online Pharmacy in United States.',
          'SHOWTIME ANYTIME' => 'On-Demand access for Showtime series, movies and other entertainments.',
          'DomainTools' => 'A domain name registrar.',
          'City Sports' => 'Sporting goods and athletic apparel retailer.',
          '2345.com' => 'Web portal.',
          'Times Union' => 'News local to Albany, New York.',
          'Blackboard' => 'Online course management system.',
          'IKEA.com' => 'Online storefront for international furniture retailer.',
          'StayFriends' => 'German school focused social network.',
          'Rona' => 'Hardware, home improvement, and gardening products retailer based in Canada.',
          'F-secure' => 'Antivirus software.',
          'Vonage' => 'Vonage is a VoIP company that provides telephone service via a broadband connection.',
          'Capital One' => 'U.S. based bank holding company.',
          'Verizon' => 'Internet, TV and Phone service provider.',
          'Wall Street Journal' => 'Web Portal for news update.',
          'CareerBuilder.com' => 'Online job search portal.',
          'The Washington Post' => 'American daily newspaper.',
          'Nokia Maps' => 'Nokia mapping and directions service.',
          'Yesky' => 'Chinese IT portal.',
          'OpenBSD' => 'Open source code for security, enterprise and server.',
          'Sanook.com' => 'Web portal for Entertainment purpose like games, lotery, news and music.',
          'BitCoin' => 'Application and website for mining and exchanging BitCoins, a cryptographic currency.',
          'Rhapsody' => 'Online streaming music service.',
          'REVOLVEclothing' => 'Designer clothing and accessories retailer.',
          'FTD' => 'Floral retailer.',
          'Online File Folder' => 'Cloud-based file storage.',
          'Rockstar Games' => 'Developer and Publisher of video games.',
          'FriendFinder' => 'Online friend finder and dating site.',
          'LeTV' => 'Chinese online video portal.',
          'Eset' => 'Eset Antivirus/Security software download and updates.',
          'AutoZone' => 'Automotive parts and accessories retailer.',
          'LeadBolt' => 'Advertisement site.',
          'Zhihu.com' => 'Chinese Q&A website.',
          'Inbox.com' => 'Free web-based email service provider.',
          'CNET Download' => 'Download of content from CNET.',
          'Tomatopang' => 'Korean Peer to Peer file-sharing application.',
          'Y8' => 'Internet gaming website.',
          'Netvibes' => 'Web portal.',
          'StubHub' => 'Website for buying and selling tickets for sports, concerts, and other events.',
          'Lowe\'s' => 'Home improvement and appliance retailer.',
          'Disqus' => 'Company which provides discussion forum features.',
          'Funny or Die' => 'Site that presents humorous videos and media.',
          'Adblade' => 'Advertising platform.',
          'PubNub' => 'Cloud-based system for apps that require data to be pushed in real time.',
          'Trac' => 'Web based bug tracking and project management tool.',
          'CBS Interactive' => 'Division of CBS Corporation which coordinates ad sales and television programs together.',
          'Quickflix' => 'DVD rental company based in Australia.',
          'SUPERAntiSpyware' => 'Antivirus / antimalware application.',
          'Indeed' => 'The job search engine.',
          'FC2' => 'Web server, sites and Blog provider.',
          'Schwab' => 'Brokerage and banking company.',
          'Best Buy' => 'Website and online retailer for national chain of electronics stores.',
          'CamerasDirect.com.au' => 'Australian camera and photography gear retailer.',
          'Realtor.com' => 'Web portal Real Estate.',
          'OCLC' => 'Online Computer Library Center - Nonprofit collaboration for providing online public access catalog.',
          'Viewsurf' => 'French video streaming and download site.',
          'Stack Overflow' => 'Question and Answering site for programmers.',
          'NBC' => 'Official website for NBC\'s Television network.',
          'Newegg' => 'Computer hardware and software retailer.',
          'PC Connection' => 'Computer and electronic products retailer.',
          'Tickets.com' => 'Ticket sales and distribution website for concerts, sports events, etc.',
          'CNET' => 'Tech and gadget related news, reviews, and shopping.',
          'USAA' => 'Insurance company.',
          'Avaya' => 'Network and Communication solution provider.',
          'Tuenti' => 'Invite only social networking website based in Spain.',
          'TMZ' => 'Entertainment news.',
          'Al Jazeera' => 'News network based in the Arab world.',
          'T Mobile' => 'Telecommunication and phone service provider.',
          'J.C. Penney' => 'Clothing and accessory retailer.',
          'Adorama' => 'Online camera retailer.',
          'Acer' => 'Manufacturer of PCs and laptops.',
          'Jamendo' => 'Website that allows for the streaming, downloading, and uploading of free music.',
          'Feedly' => 'News Aggregator.',
          'Kontiki' => 'Cloud based enterprise for video platform.',
          'Picsearch' => 'Image search engine.',
          'CTV News' => 'News channel by CTV.',
          'FilmOn' => 'Subscription based video on demand and TV streaming service.',
          'Lijit' => 'Advertising and analystics company.',
          'AdSame' => 'Chinese digital marketting platform.',
          'phpBB' => 'PHP based open source bulletin board software.',
          'MapQuest' => 'Map and Driving service by AOL.',
          'TripAdvisor' => 'Travel services site for information and reviews regarding travel related content.',
          'RuneScape' => 'Browser based fantasy role-playing game.',
          'myUdutu' => 'Online course authoring tool.',
          'WorldstarHipHop' => 'Entertainment, hip hop, music videos and blogs.',
          'eyeReturn' => 'Advertisement site.',
          'WebM Files' => 'Site for sharing videos in webm format.',
          'VeriSign' => 'SSL Certificates provider.',
          'USAIP' => 'VPN software.',
          'RealClearPolitics' => 'Political news, opinions and polls website.',
          'Fileguri' => 'Korean file sharing web site.',
          'Southwest Airlines' => 'Airlines service in United States.',
          '360 Safeguard' => 'Chinese anti-virus software.',
          'Livefyre' => 'Real-Time tools for socializing the web-sites.',
          'Nike' => 'Shoe and sports apparel manufacturer.',
          'ESPN' => 'Online Sports news and show.',
          'eBay Bid' => 'Bidding in an eBay Auction.',
          'MetaFilter' => 'Community weblog for link sharing.',
          'Sohu.com' => 'Chinese search engine with other services like games, advertising, etc.',
          'Goal' => 'Football news and statistics.',
          'SmugMug' => 'Photo sharing website.',
          'Tinder' => 'Social Network for connecting people.',
          'Proxistore' => 'Advertising and analytics site.',
          'Web Of Trust' => 'Community-based website reputation rating tool.',
          'Woot' => 'Online retailer that sells one discount product a day.',
          'InSkin Media' => 'Advertisement site.',
          'Overstock.com' => 'Online discount retailer.',
          'De Telegraaf' => 'Dutch daily newspaper site.',
          'Fox Sports' => 'Web Portal for Sports news update.',
          'VTunnel' => 'Web based proxy service.',
          'Sprint' => 'Voice, data and internet service provider.',
          'AutoTrader.com' => 'Used car listings by owner or dealer.',
          'Baidu' => 'Chinese Search engine.',
          'Naver Cafe' => 'Naver forums and social networking.',
          'Naver Mail' => 'Naver webmail.',
          'Hulu' => 'Video streaming.',
          'Ustream.tv' => 'Video streaming and sharing.',
          'Newser' => 'Online new portal.',
          'Glype' => 'Web-based proxy.',
          'G4' => 'Video game news website to accompany its associated television channel.',
          'Dilbert.com' => 'Offcial website for Dilbert, American comic strips.',
          'Library of Congress' => 'Online collection of American history memories and culture.',
          'OkCupid' => 'Online Dating website.',
          'ZergNet' => 'Content aggregator for Sci-Fi Article.',
          'Pandora TV' => 'Pandora streaming TV service.',
          'WarriorForum' => 'Internet Marketing Forums.',
          'Synology DSM' => 'Synology is a Network Attached Storage (NAS) appliances running Synology\'s DSM Software.',
          'MobiTV' => 'A content aggregation company focusing on video.',
          '56.com' => 'Large Chinese video sharing site.',
          'EarthLink' => 'IT Solution provider for network and communications.',
          'Kmart' => 'Discount department store/retailer.',
          'CafeMom' => 'Social networking site targeted towards mothers.',
          'Wachovia' => 'Financial services company.',
          'Blackberry sites' => 'Website for RIM\'s smartphone.',
          'LiveJournal' => 'Social blogging site.',
          'Crackle' => 'Digital network providing streaming video content.',
          'Bild.de' => 'Online edition of German tabloid.',
          'spin.de' => 'German social network and dating site.',
          'Manta' => 'Provides US company profiles and information.',
          'RitzCamera.com' => 'Photography goods and electronics retailer.',
          'Balatarin' => 'Social bookmarking and community website aimed at an Iranian audience.',
          'NewsNow' => 'News aggregator website that links to thousands of publications.',
          'Phoca' => 'Software components useful for web design.',
          'China.com' => 'Chinese social networking site.',
          'Words With Friends' => 'Word game.',
          'WD softwares Download/Update' => 'Update/Download software provided by western digital.',
          'NFL.com' => 'American football news.',
          'EA Games' => 'Web portal for Electronics Arts, a video games distributor.',
          'QVC' => 'General shopping website in association with its related televised QVC broadcasts.',
          'Bloomingdales' => 'Retail department store.',
          'InsightExpress' => 'Analyser for online and Mobile advertisements.',
          'Costco' => 'Warehouse club\'s online retail website.',
          'Tesco.com' => 'General E-commerce website.',
          'Drugs.com' => 'Online pharmacy.',
          'Cheezburger' => 'Hang-out place for funny Photos and stories.',
          'Monster.com' => 'Online job search portal.',
          'Liberty Mutual' => 'Insurance company.',
          'Fidelity' => 'Mutual fund and financial services company.',
          'Wikia' => 'Web portal to contribute and share the knowledge.',
          'Commvault' => 'Enterprise data backup and storage management software.',
          'RuTube' => 'Russian online video sharing service.',
          'BBC' => 'Web Portal for news update.',
          'Indiatimes' => 'Online news portal.',
          'QDown' => 'Korean Entertainment web portal.',
          'Kiwoom' => 'Investment firm.',
          'Level 3' => 'Level 3 Communications content delivery network.',
          'Zol.com.cn' => 'Online website for IT professional.',
          'Youku' => 'Chinese video hosting and sharing service.',
          'Ad4mat' => 'Ad site.',
          'China Daily' => 'Chinese news site.',
          'Newsvine' => 'Community based collaborative news website.',
          'Okta' => 'An enterprise service that manages login credentials in the cloud.',
          'Speedtest' => 'Test the download and upload speed of the internet.',
          'OneDrive' => 'Microsoft cloud storage offering, successor to SkyDrive.',
          'ShowClix' => 'A full-service ticketing company.',
          'Aweber' => 'Email marketing Service.',
          'Cedexis' => 'Advertising and analytics site.',
          'AMD' => 'A manufacturer or PC chipsets.',
          'CarMax' => 'New and used car retailer.',
          'Tchibo' => 'German retailer with weekly changing products.',
          'Filemail' => 'File hosting and sharing service.',
          'B&H Photo Video' => 'Online retailer of cameras.',
          'Neckermann' => 'General goods online retailer.',
          'Ad Advisor' => 'Web advertisement services.',
          'Saks Fifth Avenue' => 'Luxury, high-end specialty store.',
          'w3schools.com' => 'A web development learning website.',
          'The Hype Machine' => 'MP3 blog aggregator.',
          'The Gap' => 'Clothing and accessories retailer, encompassing Gap, Old Navy, Banana Republic, Piperlime, and Athleta.',
          'PerfectIBE' => 'An air travel booking consolidation engine.',
          'Weather Underground' => 'Weather web portal.',
          'Boxcar.io' => 'Social media and RSS aggregator. Different site than boxcar.com.',
          'Black & Decker Corporation' => 'Power tools, hardware, and home improvement products retailer.',
          'beRecruited' => 'College athletic social networking site.',
          'Fox News' => 'Web Portal for news update.',
          'Qriocity' => 'Streaming music and video on demand service from Sony.',
          'CheapOAir' => 'Travel booking and price comparison site.',
          'POLITICO.com' => 'News portal.',
          'AccuWeather' => 'Weather forecasting website.',
          'HootSuite' => 'Social Network management.',
          'Tiffany & Co.' => 'Jewelry and silverware retailer.',
          'WPS Office' => 'Mobile app for viewing and editing documents, spreadsheet and PPTs.',
          'Deezer' => 'Music streaming service based in Paris.',
          'Staples' => 'Office supply retailer.',
          'Softpedia' => 'Software download site.',
          'YY' => 'Chinese Chat application.',
          'Swagbucks' => 'Online rewards program.',
          'Goodreads' => 'Book review and cataloging.',
          'IMDB' => 'Movie information, reviews and previews.',
          'Showbox' => 'Mobile application providing streaming video content.',
          '1-800-Flowers' => 'Online retailer of flowers and other gifts.',
          'GameStop' => 'Video game retailer.',
          'Renren' => 'Chinese social networking site.',
          'Diigo' => 'Social bookmarking website for storing, sharing, and finding web bookmarks.',
          'Chatroulette' => 'Service that pairs random strangers for video chat.',
          'Nordstrom' => 'Retail department store.',
          'HostGator' => 'Web hosting portal.',
          'Game Front' => 'Gaming news, reviews, cheats, and walkthroughs.',
          'Douban' => 'Chinese social networking service.',
          'Swarovski' => 'Retailer for jewelry and other related luxury products.',
          'Coupons.com' => 'An online coupons and deals website.',
          'Zippyshare' => 'File hosting site.',
          'SoulSeek' => 'Peer-to-peer network.',
          'Tianya' => 'Chinese forum for blogging, microblogging and photo album services.',
          'SLI Systems' => 'Advertisement site.',
          'Live365' => 'Internet radio.',
          '4399.com' => 'Chinese gaming website.',
          'Adobe Software' => 'Adobe software and updates.',
          'Haiku Learning Systems' => 'Online tool for teaching and learning.',
          'Mibbit' => 'Web based chat client that supports IRC and Twitter.',
          'The Guardian' => 'Online news portal.',
          'Weebly' => 'Free, online website creation tool.',
          'SOUNDROP' => 'Listen to music online.',
          'WhitePages Inc' => 'Business and People\'s Contact directory in United States.',
          'TV Guide' => 'Listings and schedules for television programming.',
          'Sam\'s Club' => 'Warehouse club\'s online retail site.',
          'Macy\'s' => 'Department store chain.',
          'Autodesk' => 'A CAD and 3D printing software company.',
          'Afreeca' => 'Video streaming service based in South Korea.',
          'Yellow Pages' => 'Online directory and Mapping services.',
          'news.com.au' => 'News site based in Australia.',
          'Examiner.com' => 'News portal.',
          'Microsoft Azure' => 'Cloud computing by Microsoft.',
          'FogBugz' => 'Web-based project management and bug tracking system.',
          'L\'equipe.fr' => 'French sports news site.',
          'Bizrate' => 'Lists best deals for online shopping.',
          'Federated Media' => 'Advertisement site.',
          '1&1 Internet' => 'Internet and Domain name service provider.',
          'The Sharper Image' => 'General electronics and gifts retailer.',
          'Nate' => 'Web portal and Search engine.',
          'Office Depot' => 'Office supply retailer.',
          'Jubii' => 'Web portal providing search engine, e-mail, and file sharing services.',
          'FOX' => 'Official website for Fox entertainment.',
          'Wolfram Alpha' => 'Online answering for queries from the structred data.',
          'The Seattle Times' => 'Newspaper with a focus on the Seattle metro area.',
          'European Union' => 'Official website for European Union.',
          'NBC News' => 'NBCUniversal\'s news website.'
        };

--]]

require "DetectorCommon"


local DC = DetectorCommon

DetectorPackageInfo = {
    name =  'ssl_host_group_334_part2',
    proto =  DC.ipproto.tcp,
    client = {
        init =  'DetectorInit',
        clean =  'DetectorClean',
        minimum_matches =  1
    }
}

gSSLCnamePatternList = {
    -- Qriocity
    { 0, 1002, 'ebookstore.sony.com' },
    -- RuneScape
    { 0, 1003, 'www.jagex.com' },
    -- Scribd
    { 0, 1005, 'scribd.com' },
    -- Tuenti
    { 0, 1016, 'tuenti.com' },
    -- VKontakte
    { 0, 1018, 'vk.com' },
    -- VTunnel
    { 0, 1019, 'vtunnel.com' },
    -- Webhard
    { 0, 1020, 'www.webhard.co.kr' },
    { 0, 1020, 'www.webhard.net' },
    -- 56.com
    { 0, 1031, 'www.56.com' },
    -- Youku
    { 0, 1033, 'youku.com' },
    -- Crackle
    { 0, 1034, 'crackle.com' },
    -- RuTube
    { 0, 1035, 'rutube.ru' },
    -- Afreeca
    { 0, 1037, 'afreeca.com' },
    { 0, 1037, 'afreecatv.com' },
    -- FilmOn
    { 0, 1048, 'filmon.com' },
    -- Mibbit
    { 0, 1049, 'mibbit.com' },
    -- BigBlueButton
    { 0, 1050, 'bigbluebutton.org' },
    -- CloudMe
    { 0, 1055, 'cloudme.com' },
    -- Skyrock
    { 0, 1057, 'skyrock.com' },
    -- Jubii
    { 0, 1060, 'konto.jubii.dk' },
    -- TwitPic
    { 0, 1063, 'twimg.com' },
    -- Slacker
    { 0, 1068, 'slacker.com' },
    -- Douban
    { 0, 1069, 'douban.com' },
    -- Gaia Online
    { 0, 1071, 'gaiaonline.com' },
    -- AutoZone
    { 0, 1073, 'www.autozone.com' },
    -- Tesco.com
    { 0, 1077, 'tesco.com' },
    -- Rhapsody
    { 0, 1081, 'rhapsody.com' },
    -- Balatarin
    { 0, 1082, 'balatarin.com' },
    -- PC Connection
    { 0, 1109, 'www.pcconnection.com' },
    -- CafeMom
    { 0, 1129, 'cafemom.com' },
    -- Words With Friends
    { 0, 1163, 'zyngawithfriends.com' },
    -- CNET
    { 0, 1170, 'cnet.com' },
    -- CNET Download
    { 0, 1171, 'download.cnet.com' },
    -- DomainTools
    { 0, 1172, 'domaintools.com' },
    -- w3schools.com
    { 0, 1180, 'w3schools.com' },
    -- Weebly
    { 0, 1181, 'redirect.weebly.com' },
    -- IMDB
    { 0, 1191, 'us.dd.imdb.com' },
    -- BC News
    { 0, 1192, 'online.nbcuni.com' },
    -- Bild.de
    { 0, 1196, 'ak.token.bild.de' },
    -- 39.net
    { 0, 1207, '39.net' },
    -- Online File Folder
    { 0, 1223, 'secureserver.net' },
    -- 4399.com
    { 0, 1256, '4399.com' },
    -- Admin5
    { 0, 1258, 'admin5.com' },
    -- Y8
    { 0, 1263, 'y8.com' },
    -- Ad Advisor
    { 0, 1306, 'adadvisor.net' },
    -- Ad Nexus
    { 0, 1314, 'adnxs.com' },
    -- Pandora TV
    { 0, 1327, 'pandora.tv' },
    -- Bay Bid
    { 0, 133, 'offer.ebay.com' },
    -- Weather Underground
    { 0, 1338, 'www.weather.com' },
    -- Kiwoom
    { 0, 1341, 'kiwoom.com' },
    -- DCinside
    { 0, 1342, 'dcinside.com' },
    -- te
    { 0, 1343, 'nate.com' },
    -- Fileguri
    { 0, 1344, 'disk.fileguri.com' },
    -- Baidu
    { 0, 1345, 'www.baidu.cn' },
    -- CanvasRider
    --{ 0, 1361, 'bonoboplanet-jeu.com' },
    --{ 0, 1361, 'canvasrider.com' },
    -- ESPN
    { 0, 1364, 'espn.com' },
    -- Fox News
    { 0, 1366, 'wildcard.foxnews.com' },
    -- Weather.gov
    { 0, 1368, 'weather.gov' },
    -- BBC
    { 0, 1376, 'bbcpreview.com' },
    -- BBC
    { 0, 1376, 'www.bbc.co.uk' },
    -- BBC
    { 0, 1376, 'www.bbc.com' },
    -- Indeed
    { 0, 1378, 'indeed.com' },
    -- Publishers Clearing House
    { 0, 1379, 'pch.com' },
    -- Aweber
    { 0, 1381, 'aweber.com' },
    -- Fox Sports
    { 0, 1382, 'san.foxsports.com' },
    -- Wall Street Journal
    { 0, 1390, 'efinancialcareers.com' },
    -- Wall Street Journal
    { 0, 1390, 'www.marketwatch.com' },
    -- Daily Mail
    { 0, 1391, 'secured.dailymail.co.uk' },
    -- Taobao
    --{ 0, 1399, 'tmall.com' },
    -- Tmall
    { 0, 2387, 'tmall.com' },
    -- FC2
    { 0, 1422, 'fc2.com' },
    -- okia Maps
    { 0, 1427, 'here.com' },
    -- Wolfram Alpha
    { 0, 1429, 'stephenwolfram.com' },
    -- Eset
    { 0, 143, 'www.eset.eu' },
    -- VeriSign
    { 0, 1458, 'www.verisign.com' },
    -- CBS Sports
    { 0, 1459, 'cbssports.com' },
    -- InsightExpress
    { 0, 1461, 'insightexpress.com' },
    { 0, 1461, 'insightexpressai.com' },
    -- Monster.com
    { 0, 1481, 'monster.com' },
    -- MapQuest
    { 0, 1482, 'www.mapquest.com' },
    -- Swagbucks
    { 0, 1483, 'swagbucks.com' },
    -- Verizon
    { 0, 1484, 'can.transactcdn.com' },
    -- Verizon
    { 0, 1484, 'www.verizon.com' },
    -- Wikia
    { 0, 1485, 'wikia-services.com' },
    { 0, 1485, 'wikia.nocookie.net' },
    -- TMZ
    { 0, 1486, 'wbdevops.com' },
    -- HootSuite
    { 0, 1489, 'hootsuite.com' },
    -- Coupons.com
    { 0, 1490, 'coupons.com' },
    -- CareerBuilder.com
    { 0, 1491, 'careerbuilder.com' },
    -- CareerBuilder.com
    { 0, 1491, 'www.caresouthcareers.co.uk' },
    -- AllRecipes
    { 0, 1496, 'allrecipes.com' },
    -- Yellow Pages
    { 0, 1497, 'yellowpages.com' },
    { 0, 1497, 'yellowpages.in' },
    -- Stack Overflow
    { 0, 1499, 'stackexchange.com' },
    -- Ancestry.com
    { 0, 1501, 'ancestry.com' },
    -- Reuters
    { 0, 1507, 'reuters.com' },
    -- California.gov
    { 0, 1509, 'www.ca.gov' },
    -- Southwest Airlines
    { 0, 1510, 'www.southwest.com' },
    -- WhitePages Inc
    { 0, 1512, 'whitepages.com' },
    -- EarthLink
    { 0, 1514, 'earthlink.net' },
    { 0, 1514, 'earthlinkbusiness.com' },
    -- Disney
    { 0, 1515, 'disney.co.uk' },
    { 0, 1515, 'disneyinternational.com' },
    -- POLITICO.com
    { 0, 1516, 'politico.com' },
    -- Examiner.com
    { 0, 1518, 'energycurb.com' },
    -- OkCupid
    { 0, 1522, 'okcupid.com' },
    -- Realtor.com
    { 0, 1525, 'realtor.com' },
    -- Intuit
    { 0, 1526, 'intuitstatic.com' },
    { 0, 1526, 'mktg.intuit.com' },
    -- HostGator
    { 0, 1528, 'hostgator.com' },
    -- Food Network
    { 0, 1529, 'scrippsnetworks.com' },
    -- AccuWeather
    { 0, 1533, 'accuweather.com' },
    -- Sprint
    { 0, 1534, 'www.sprint.com' },
    -- Goodreads
    { 0, 1535, 'www.goodreads.com' },
    -- RealClearPolitics
    { 0, 1537, 'realclearpolitics.com' },
    -- Manta
    { 0, 1538, 'manta.com' },
    -- CNBC
    { 0, 1540, 'cnbc.com' },
    -- Inbox.com
    { 0, 1542, 'inbox.com' },
    -- T Mobile
    { 0, 1545, 'www.t-mobile.com' },
    { 0, 1545, 'redirects.t-mobile.com' },
    -- Walgreens
    { 0, 1546, 'walgreens.com' },
    -- WorldstarHipHop
    { 0, 1547, 'worldstarhiphop.com' },
    -- PR
    { 0, 1548, 'npr.org' },
    -- Kayak
    { 0, 1549, 'www.kayak.com' },
    -- Sohu.com
    { 0, 1552, 'www.sohu.com' },
    -- 1&1 Internet
    { 0, 1553, 'www.1and1.com' },
    -- Ameba
    { 0, 1554, 'ameba.jp' },
    -- Avaya
    { 0, 1555, 'www.avaya.com' },
    -- Disqus
    { 0, 1558, 'disqus.com' },
    -- Infusionsoft
    { 0, 1559, 'infusionsoft.com' },
    -- Alisoft
    --{ 0, 1561, 'websitewelcome.com' },
    -- Salesforce.com Live Agent
    { 0, 1562, 'flexshopper.com' },
    -- FogBugz
    { 0, 161, 'fogbugz.com' },
    -- Yandex
    { 0, 1616, 'crypta.yandex.ru' },
    -- The Guardian
    { 0, 1618, 'theguardian.com' },
    -- WarriorForum
    { 0, 1622, 'warriorforum.com' },
    -- Indiatimes
    { 0, 1623, 'indiatimes.com' },
    -- UOL
    { 0, 1626, 'imguol.com' },
    { 0, 1626, 'jsuol.com' },
    -- LeTV
    { 0, 1650, 'le.com' },
    -- Tianya
    { 0, 1651, 'tianya.cn' },
    -- YY
    { 0, 1663, 'hiido.com' },
    { 0, 1663, 'yy.com' },
    -- Flexera Software
    { 0, 1676, 'flexera.com' },
    -- SOUNDROP
    { 0, 1695, 'soundrop.com' },
    -- The Washington Post
    { 0, 1709, 'www.washingtonpost.com' },
    -- Playstation.com
    { 0, 1754, 'www.playstation.com' },
    -- VLC Media Player
    { 0, 1756, 'www.videolan.org' },
    -- Bizrate
    { 0, 1782, 'bizrate.com' },
    -- Cheezburger
    { 0, 1785, 'cheezburger.com' },
    -- ZergNet
    { 0, 1790, 'www.zergnet.com' },
    -- Feedly
    { 0, 1799, 'feedly.com' },
    -- PubNub
    { 0, 1822, 'pubnub.com' },
    -- BC
    { 0, 1988, 'murtl.nbcudps.com' },
    { 0, 1988, 'nbcuni.com' },
    -- ESTsoft
    { 0, 1996, 'estsoft.com' },
    -- wser
    { 0, 2020, 'newser.com' },
    -- FOX
    { 0, 2050, 'secure.fox.com' },
    -- Washington Times
    { 0, 2051, 'washingtontimes.com' },
    -- OpenBSD
    { 0, 2053, 'www.openbsd.org' },
    -- Associated Press
    { 0, 2054, 'ap.org' },
    -- Livefyre
    { 0, 2062, 'www.livefyre.com' },
    -- Clear Channel
    { 0, 2064, 'clearchannelinternational.com' },
    -- Woopra
    --{ 0, 2069, 'disqus.com' },
    -- OCLC
    { 0, 2070, 'oclc.org' },
    -- Chosun
    { 0, 2071, 'chosun.com' },
    -- Game Front
    { 0, 2082, 'bwinaffiliates.gr' },
    -- BitCoin
    { 0, 2083, 'bitcoin.org' },
    -- Letterpress
    { 0, 2091, 'atebits.com' },
    -- FriendFinder
    { 0, 2093, 'adultfriendfinder.com' },
    -- Speedtest
    { 0, 2103, 'speedtest.centurylink.net' },
    -- Speedtest
    { 0, 2103, 'www.speedtest.net' },
    -- Microsoft Azure
    { 0, 2111, 'azureedge.net' },
    -- Adblade
    { 0, 2116, 'adblade.com' },
    -- Blackberry sites
    { 0, 2119, 'origin-www.blackberry.com' },
    -- SmugMug
    { 0, 2124, 'smugmug.com' },
    -- USAA
    { 0, 2126, 'www.usaa.com' },
    -- MobiTV
    { 0, 2131, 'mobitv.com' },
    -- TV Guide
    { 0, 2132, 'tvguide.com' },
    -- CheapOAir
    { 0, 2137, 'www.cheapoair.com' },
    -- AMD
    { 0, 2144, 'www-edit.amd.com' },
    -- Acer
    { 0, 2146, 'acer.com' },
    -- Gateway
    { 0, 2147, 'gateway.com' },
    -- Motorola
    { 0, 2149, 'motorola.com' },
    -- Liberty Mutual
    { 0, 2156, 'search.libertymutual.com' },
    -- PerfectIBE
    { 0, 2162, 'perfectibe.com' },
    -- Funny or Die
    { 0, 2163, 'voxmedia.com' },
    -- Viki
    { 0, 2171, 'viki.com' },
    -- Al Jazeera
    { 0, 2180, 'aljazeera.com' },
    { 0, 2180, 'aljazeera.net' },
    -- Wimbledon
    { 0, 2181, 'wimbledon.com' },
    -- Times Union
    { 0, 2183, 'newstimes.com' },
    -- beRecruited
    { 0, 2184, 'berecruited.com' },
    -- De Telegraaf
    { 0, 2189, 'telegraaf.nl' },
    -- The Free Dictionary
    { 0, 2192, 'thefreedictionary.com' },
    -- WordReference.com
    { 0, 2208, 'wordreference.com' },
    -- SpeedRunsLive
    { 0, 2238, 'api.speedrunslive.com' },
    -- WDT
    { 0, 2240, 'wdtinc.com' },
    -- The Seattle Times
    { 0, 2242, 'seattletimes.com' },
    -- Okta
    { 0, 2246, 'community.okta.com' },
    -- ike
    { 0, 2247, 'redirect.nike.com' },
    -- Libsyn
    { 0, 2248, 'libsyn.com' },
    -- CNET TV
    --{ 0, 2256, 'cnet.com' },
    -- Drugs.com
    { 0, 2269, 'drugs.com' },
    -- Tinder
    { 0, 2302, 'gotinder.com' },
    -- 2345.com
    { 0, 2346, '2345.com' },
    -- IKEA.com
    { 0, 2349, 'www.ikea.is' },
    -- CBS Interactive
    { 0, 2354, 'cbsinteractive.com' },
    -- China.com
    { 0, 2371, 'china.com' },
    -- NFL.com
    { 0, 2376, 'shield-thortest-lv1.nfl.com' },
    -- Alibaba
    --{ 0, 2386, 'taobao.com' },
    -- Google ads
    --{ 0, 2403, 'g.doubleclick.net' },
    -- Goal
    { 0, 2484, 'goal.com' },
    -- 247 Inc.
    { 0, 2492, '247.ai' },
    -- SLI Systems
    { 0, 2494, 'www.sli-systems.com.au' },
    -- OwnerIQ
    { 0, 2495, 'owneriq.com' },
    -- LeadBolt
    { 0, 2505, 'websitewelcome.com' },
    -- eyeReturn
    { 0, 2526, 'eyereturn.com' },
    -- InSkin Media
    { 0, 2527, 'inskin.media' },
    { 0, 2527, 'inskinad.com' },
    -- Federated Media
    { 0, 2559, 'fmpub.net' },
    -- Boxcar.io
    { 0, 2605, 'boxcar-api.io' },
    -- Softpedia
    { 0, 2606, 'softpedia.com' },
    -- China News
    { 0, 2610, 'chinanews.com' },
    -- GOMTV Remote Control
    { 0, 2638, 'gomlab.com' },
    -- Live365
    { 0, 264, 'live365.com' },
    -- Dilbert.com
    { 0, 2657, 'www.dilbert.com' },
    -- Lijit
    { 0, 2663, 'lijit.com' },
    -- Moat
    { 0, 2664, 'moat.com' },
    { 0, 2664, 'moatads.com' },
    -- SHOWTIME ANYTIME
    { 0, 2697, 'sho.com' },
    -- Sky.com
    { 0, 2699, 'feeds.skynews.com' },
    { 0, 2699, 'skysports.com' },
    -- EA Games
    { 0, 2701, 'account.swtor.com' },
    -- SimplePie
    { 0, 2706, 'bugs.simplepie.org' },
    -- Zippyshare
    { 0, 2738, 'zippyshare.com' },
    -- Rockstar Games
    { 0, 2747, 'www.rockstarnorth.com' },
    -- CTV News
    { 0, 2751, 'news.bellmedia.ca' },
    -- Tvigle
    { 0, 2761, 'tvigle.ru' },
    -- Library of Congress
    { 0, 2766, 'loc.gov' },
    -- Phoca
    { 0, 2771, 'phoca.cz' },
    -- hpBB
    { 0, 2772, 'area51.phpbb.com' },
    -- Joomla
    { 0, 2779, 'joomla-org.directrouter.com' },
    -- European Union
    { 0, 2786, 'europa.eu' },
    -- Picsearch
    { 0, 2816, 'picsearch.com' },
    -- Zhihu.com
    { 0, 2840, 'zhihu.com' },
    -- AdSame
    { 0, 2849, 'adsame.com' },
    -- Ganji
    { 0, 2854, 'ganji.com' },
    -- BBC iPlayer
    --{ 0, 2857, 'www.bbc.com' },
    -- Zol.com.cn
    { 0, 2866, 'zol.com.cn' },
    -- Xunlei Kankan
    { 0, 2878, 'pad.kankan.com' },
    { 0, 2878, 'xunlei.com' },
    -- Glype
    { 0, 2891, 'glype.com' },
    -- Sanook.com
    { 0, 2893, 'sanook.com' },
    -- Tomatopang
    { 0, 2943, 'www.tomatopang.net' },
    -- news.com.au
    { 0, 3671, 'news.com.au' },
    -- Soso
    --{ 0, 3673, 'sogou.com' },
    -- Ad4mat
    { 0, 3702, 'ad4mat.info' },
    -- Ad4mat
    { 0, 3702, 'cloud.advanced-audience.com' },
    -- Cedexis
    { 0, 3705, 'cedexis.com' },
    -- L'equipe.fr
    { 0, 3711, 'lequipe.fr' },
    -- Proxistore
    { 0, 3717, 'proxistore.com' },
    -- Viewsurf
    { 0, 3722, 'viewsurf.com' },
    -- OneDrive
    { 0, 3735, 'storage.live.com' },
    -- Rackspace
    { 0, 3737, 'rackspace.com' },
    -- USAIP
    { 0, 3755, 'usaip.eu' },
    -- Yesky
    { 0, 3790, 'yesky.com' },
    -- Lineage
    { 0, 3801, 'ncsoft.com' },
    { 0, 3801, 'plaync.com' },
    -- Level 3
    { 0, 3805, 'www.level3.com' },
    -- QDown
    { 0, 3817, 'www.qdown.com' },
    -- Ad Master
    { 0, 3846, 'admaster.com.cn' },
    -- 360 Safeguard
    { 0, 3866, '360.cn' },
    -- China Daily
    { 0, 3871, 'chinadaily.com.cn' },
    -- Guangming Online
    { 0, 3872, 'gmw.cn' },
    -- Autodesk
    { 0, 3888, 'autodesk.com' },
    -- Flipkart
    { 0, 3970, 'flipkart.com' },
    -- F-secure
    { 0, 3989, 'f-secure.com' },
    -- SUPERAntiSpyware
    { 0, 3991, 'superantispyware.com' },
    -- WPS Office
    { 0, 4010, 'wps.cn' },
    -- Kontiki
    { 0, 4013, 'www.kontiki.com' },
    -- Western Digital
    { 0, 4039, 'sandisk.com' },
    -- WD softwares Download/Update
    { 0, 4040, 'download.wdc.com' },
    -- Naver Blog
    { 0, 4050, 'poll.naver.com' },
    -- Naver Cafe
    { 0, 4051, 'cc.naver.com' },
    -- Naver Mail
    { 0, 4054, 'mail.naver.com' },
    -- Synology DSM
    { 0, 4089, 'fake.synology.io' },
    { 0, 4089, 'update.synology.com' },
    -- WebM Files
    { 0, 4109, 'av1.webmfiles.org' },
    -- Showbox
    { 0, 4149, 'downloadsshowbox.com' },
    -- SoulSeek
    { 0, 442, 'www.slsknet.org' },
    -- Vonage
    { 0, 495, 'www.vonage.com' },
    -- 1-800-Flowers
    { 0, 535, '800-flowers.net' },
    -- Adobe Software
    { 0, 541, 'redirect.adobe.com' },
    -- Adorama
    { 0, 542, 'adorama.com' },
    -- American Express
    { 0, 544, 'www.americanexpress.ch' },
    -- AutoTrader.com
    { 0, 558, 'autotrader.com' },
    -- B&H Photo Video
    { 0, 559, 'secure.bhphotovideo.com' },
    -- Best Buy
    { 0, 567, 'www.bestbuy.com' },
    -- Black & Decker Corporation
    { 0, 572, 'www.blackanddecker.com' },
    -- Blockbuster
    -- { 0, 575, '104.168.135.30' },
    -- Bloomingdales
    { 0, 577, 'www.bloomingdales.com' },
    -- Blue Nile
    { 0, 578, 'bnsec.bluenile.com' },
    -- CamerasDirect.com.au
    { 0, 581, 'www.camerasdirect.com.au' },
    -- Capital One
    { 0, 582, 'capitalone.ca' },
    -- CarMax
    { 0, 584, 'mykmxhr.com' },
    -- CDiscount
    { 0, 585, 'cdiscount.com' },
    -- City Sports
    { 0, 591, 'citysports.com' },
    -- Costco
    { 0, 593, 'costco.ca' },
    -- Crutchfield
    { 0, 595, 'www.crutchfield.com' },
    -- Diigo
    { 0, 612, 'www.diigo.com' },
    -- Dillards
    { 0, 613, 'dillards.com' },
    -- Discover
    { 0, 615, 'www.discoverbank.com' },
    -- Blackboard
    { 0, 62, 'blackboard.com' },
    -- Fidelity
    { 0, 636, 'www.fidelity.se' },
    { 0, 636, 'www.fidelityinternational.com' },
    -- Fnac
    { 0, 640, 'www.fnac.com' },
    { 0, 640, 'www.fnac.es' },
    { 0, 640, 'www.fnac.pt' },
    { 0, 640, 'www.fr.fnac.ch' },
    -- FTD
    { 0, 644, 'www.ftd.com' },
    -- G4
    { 0, 646, 'usanetwork.com' },
    -- GameStop
    { 0, 650, 'gamerfund.org' },
    { 0, 650, 'gamestop.ie' },
    -- Haiku Learning Systems
    { 0, 669, 'haikulearning.com' },
    -- Home Depot
    { 0, 670, 'homedepot.com' },
    -- Home Depot
    { 0, 670, 'www.homedepot.ca' },
    -- HSBC
    { 0, 675, 'www.hsbc.am' },
    { 0, 675, 'www.hsbc.bm' },
    { 0, 675, 'www.hsbc.ca' },
    { 0, 675, 'www.hsbc.fr' },
    { 0, 675, 'www.hsbc.gr' },
    { 0, 675, 'www.hsbc.lk' },
    { 0, 675, 'www.hsbctrinkaus.de' },
    -- Hulu
    { 0, 677, 'assets.huluqa.com' },
    -- J.C. Penney
    { 0, 690, 'jcpenney.com' },
    -- Kay Jewelers
    { 0, 698, 'www.kay.com' },
    -- Kmart
    { 0, 702, 'kmart.com' },
    -- Kogan Technologies
    { 0, 703, 'koganmobile.com.au' },
    -- Kohl's
    { 0, 704, 'www.kohls.com' },
    -- LiveJournal
    { 0, 716, 'livejournal.com' },
    -- Lord & Taylor
    --{ 0, 719, 'saks.com' },
    -- Lowe's
    { 0, 722, 'www1.lowes.com' },
    -- MetaFilter
    { 0, 729, 'metafilter.com' },
    -- yUdutu
    { 0, 748, 'udutu.com' },
    -- Neckermann
    { 0, 750, 'neckermann.at' },
    { 0, 750, 'www.neckermann.de' },
    -- Neiman Marcus
    { 0, 751, 'www.neimanmarcus.com' },
    -- Netvibes
    { 0, 758, 'netvibes.com' },
    -- Newegg
    { 0, 759, 'newegg.cn' },
    { 0, 759, 'newegg.io' },
    -- NewsNow
    { 0, 760, 'newsnow.co.uk' },
    -- Newsvine
    { 0, 761, 'newsvine.com' },
    -- Nordstrom
    { 0, 764, 'nordstrom.com' },
    -- Office Depot
    { 0, 768, 'officedepot.hu' },
    { 0, 768, 'officedepot.sk' },
    { 0, 768, 'origin-prd.officedepot.eu' },
    { 0, 768, 'www.grandandtoy.com' },
    { 0, 768, 'www.officedepot.cz' },
    -- Overstock.com
    { 0, 778, 'www.overstock.com' },
    -- Quickflix
    { 0, 796, 'quickflix.com.au' },
    -- QVC
    { 0, 798, 'qvc.jp' },
    -- Redmine
    { 0, 805, 'redmine.org' },
    -- REI
    { 0, 806, 'rei.com' },
    -- Renren
    { 0, 808, 'renren.com' },
    -- REVOLVEclothing
    { 0, 809, 'revolve.com' },
    -- Rona
    { 0, 810, 'rona.ca' },
    -- Saks Fifth Avenue
    { 0, 816, 'saks.com' },
    -- Sam's Club
    { 0, 817, 'origin-www.sams.com.mx' },
    { 0, 817, 'www.samsclub.com' },
    -- schuelerVZ
    { 0, 818, 'bidswitch.net' },
    -- Schwab
    { 0, 819, 'www.schwab.com' },
    -- Sears
    { 0, 821, 'club.ourvacationcenter.com' },
    { 0, 821, 'searscarpet.com' },
    -- Shoplet
    { 0, 825, 'www.shoplet.com' },
    -- ShopNBC
    { 0, 826, 'evine.com' },
    -- ShowClix
    { 0, 830, 'showclix.com' },
    -- spin.de
    { 0, 841, 'spin.de' },
    -- Staples
    { 0, 848, 'www.staples.eu' },
    -- StayFriends
    { 0, 849, 'zweiteliebe.de' },
    -- StubHub
    { 0, 850, 'www.stubhub.com' },
    -- studiVZ
    { 0, 851, 'studivz.net' },
    -- Swarovski
    { 0, 854, 'swarovski.com' },
    -- T. Rowe Price
    { 0, 855, 'www.troweprice.com' },
    -- Tchibo
    { 0, 859, 'eduscho.at' },
    -- Tchibo
    { 0, 859, 'tchibo.ch' },
    { 0, 859, 'tchibo.com.tr' },
    { 0, 859, 'tchibo.cz' },
    { 0, 859, 'tchibo.de' },
    { 0, 859, 'tchibo.pl' },
    -- TD Ameritrade
    { 0, 860, 'tdameritrade.com' },
    -- The Gap
    { 0, 863, 'www.gap.com' },
    { 0, 863, 'www.gap.eu' },
    -- The Sharper Image
    { 0, 864, 'www.sharperimage.com' },
    -- Tickets.com
    { 0, 868, 'tickets.com' },
    -- Tiffany & Co.
    { 0, 870, 'origin-ecom-az.tiffany.cn' },
    -- Tiffany & Co.
    { 0, 870, 'www.estore-tco.com' },
    -- Trac
    { 0, 878, 'edgewall.org' },
    -- TripAdvisor
    { 0, 881, 'tripadvisor.com' },
    -- Ustream.tv
    { 0, 884, 'video.ibm.com' },
    -- Vanguard
    { 0, 885, 'www.vanguardinvestments.ch' },
    { 0, 885, 'www.vanguardinvestments.de' },
    { 0, 885, 'www.vanguardinvestments.dk' },
    { 0, 885, 'www.vanguardinvestments.fr' },
    { 0, 885, 'www.vanguardinvestments.nl' },
    { 0, 885, 'www.vanguardinvestments.se' },
    -- vente-privee.com
    { 0, 888, 'front.vpgrp.net' },
    -- Wachovia
    { 0, 900, 'wachovia.com' },
    -- Web Of Trust
    { 0, 903, 'mywot.com' },
    -- Woot
    { 0, 917, 'woot.com' },
    -- XM Radio Online
    { 0, 923, 'siriusxm.com' },
    -- Zales
    { 0, 930, 'www.zales.com' },
    -- Zappos
    { 0, 931, 'zappos.com' },
    -- RitzCamera.com
    { 0, 951, 'www.ritzcamera.com' },
    -- Macy's
    { 0, 952, 'www.macys.com' },
    -- Commvault
    { 0, 96, 'commvault.com' },
    -- Chatroulette
    { 0, 962, 'chatroulette.com' },
    -- Deezer
    { 0, 965, 'deezer.com' },
    -- Evony
    { 0, 970, 'ucool.com' },
    -- FileDropper
    { 0, 971, 'serv.filedropper.com' },
    -- Filemail
    { 0, 972, 'filemail.com' },
    -- The Hype Machine
    { 0, 982, 'hypem.com' },
    -- Jamendo
    { 0, 986, 'jamendo.com' },
}


function DetectorInit(detectorInstance)

    gDetector = detectorInstance;

    if gDetector.addSSLCnamePattern then
        for i,v in ipairs(gSSLCnamePatternList) do
            gDetector:addSSLCnamePattern(v[1],v[2],v[3]);
        end
    end

    return gDetector;
end

function DetectorClean()
end



