/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../../../base/Page');
import Response = require('../../../../../../http/response');
import V2010 = require('../../../../V2010');
import { SerializableClass } from '../../../../../../interfaces';

/**
 * Initialize the PayloadList
 *
 * @param version - Version of the resource
 * @param accountSid - The SID of the Account that created the resource
 * @param referenceSid - The SID of the recording to which the AddOnResult resource that contains the payload belongs
 * @param addOnResultSid - The SID of the AddOnResult to which the payload belongs
 */
declare function PayloadList(version: V2010, accountSid: string, referenceSid: string, addOnResultSid: string): PayloadListInstance;

interface PayloadListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): PayloadContext;
  /**
   * Streams PayloadInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: PayloadInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams PayloadInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: PayloadListInstanceEachOptions, callback?: (item: PayloadInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a payload
   *
   * @param sid - The unique string that identifies the resource to fetch
   */
  get(sid: string): PayloadContext;
  /**
   * Retrieve a single target page of PayloadInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: PayloadPage) => any): Promise<PayloadPage>;
  /**
   * Retrieve a single target page of PayloadInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: PayloadPage) => any): Promise<PayloadPage>;
  /**
   * Lists PayloadInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: PayloadInstance[]) => any): Promise<PayloadInstance[]>;
  /**
   * Lists PayloadInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: PayloadListInstanceOptions, callback?: (error: Error | null, items: PayloadInstance[]) => any): Promise<PayloadInstance[]>;
  /**
   * Retrieve a single page of PayloadInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: PayloadPage) => any): Promise<PayloadPage>;
  /**
   * Retrieve a single page of PayloadInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: PayloadListInstancePageOptions, callback?: (error: Error | null, items: PayloadPage) => any): Promise<PayloadPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface PayloadListInstanceEachOptions {
  callback?: (item: PayloadInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface PayloadListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface PayloadListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface PayloadPayload extends PayloadResource, Page.TwilioResponsePayload {
}

interface PayloadResource {
  account_sid: string;
  add_on_configuration_sid: string;
  add_on_result_sid: string;
  add_on_sid: string;
  content_type: string;
  date_created: Date;
  date_updated: Date;
  label: string;
  reference_sid: string;
  sid: string;
  subresource_uris: string;
}

interface PayloadSolution {
  accountSid?: string;
  addOnResultSid?: string;
  referenceSid?: string;
}


declare class PayloadContext {
  /**
   * Initialize the PayloadContext
   *
   * @param version - Version of the resource
   * @param accountSid - The SID of the Account that created the resource to fetch
   * @param referenceSid - The SID of the recording to which the AddOnResult resource that contains the payload to fetch belongs
   * @param addOnResultSid - The SID of the AddOnResult to which the payload to fetch belongs
   * @param sid - The unique string that identifies the resource to fetch
   */
  constructor(version: V2010, accountSid: string, referenceSid: string, addOnResultSid: string, sid: string);

  /**
   * fetch a PayloadInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: PayloadInstance) => any): Promise<PayloadInstance>;
  /**
   * remove a PayloadInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: PayloadInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class PayloadInstance extends SerializableClass {
  /**
   * Initialize the PayloadContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param accountSid - The SID of the Account that created the resource
   * @param referenceSid - The SID of the recording to which the AddOnResult resource that contains the payload belongs
   * @param addOnResultSid - The SID of the AddOnResult to which the payload belongs
   * @param sid - The unique string that identifies the resource to fetch
   */
  constructor(version: V2010, payload: PayloadPayload, accountSid: string, referenceSid: string, addOnResultSid: string, sid: string);

  private _proxy: PayloadContext;
  accountSid: string;
  addOnConfigurationSid: string;
  addOnResultSid: string;
  addOnSid: string;
  contentType: string;
  dateCreated: Date;
  dateUpdated: Date;
  /**
   * fetch a PayloadInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: PayloadInstance) => any): Promise<PayloadInstance>;
  label: string;
  referenceSid: string;
  /**
   * remove a PayloadInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: PayloadInstance) => any): Promise<boolean>;
  sid: string;
  subresourceUris: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class PayloadPage extends Page<V2010, PayloadPayload, PayloadResource, PayloadInstance> {
  /**
   * Initialize the PayloadPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2010, response: Response<string>, solution: PayloadSolution);

  /**
   * Build an instance of PayloadInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: PayloadPayload): PayloadInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { PayloadContext, PayloadInstance, PayloadList, PayloadListInstance, PayloadListInstanceEachOptions, PayloadListInstanceOptions, PayloadListInstancePageOptions, PayloadPage, PayloadPayload, PayloadResource, PayloadSolution }
