/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the UsecaseList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 */
declare function UsecaseList(version: V1): UsecaseListInstance;

interface UsecaseListInstance {
  /**
   * fetch a UsecaseInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: UsecaseListInstance) => any): Promise<UsecaseInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface UsecasePayload extends UsecaseResource, Page.TwilioResponsePayload {
}

interface UsecaseResource {
  usecases: object[];
}

interface UsecaseSolution {
}


declare class UsecaseInstance extends SerializableClass {
  /**
   * Initialize the UsecaseContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   */
  constructor(version: V1, payload: UsecasePayload);

  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  usecases: object[];
}


declare class UsecasePage extends Page<V1, UsecasePayload, UsecaseResource, UsecaseInstance> {
  /**
   * Initialize the UsecasePage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: UsecaseSolution);

  /**
   * Build an instance of UsecaseInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: UsecasePayload): UsecaseInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { UsecaseInstance, UsecaseList, UsecaseListInstance, UsecasePage, UsecasePayload, UsecaseResource, UsecaseSolution }
