'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../base/deserialize');  /* jshint ignore:line */
var values = require('../../../../base/values');  /* jshint ignore:line */

var MessagingConfigurationList;
var MessagingConfigurationPage;
var MessagingConfigurationInstance;
var MessagingConfigurationContext;

/* jshint ignore:start */
/**
 * Initialize the MessagingConfigurationList
 *
 * @constructor Twilio.Verify.V2.ServiceContext.MessagingConfigurationList
 *
 * @param {Twilio.Verify.V2} version - Version of the resource
 * @param {string} serviceSid -
 *          The SID of the Service that the resource is associated with
 */
/* jshint ignore:end */
MessagingConfigurationList = function MessagingConfigurationList(version,
    serviceSid) {
  /* jshint ignore:start */
  /**
   * @function messagingConfigurations
   * @memberof Twilio.Verify.V2.ServiceContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Verify.V2.ServiceContext.MessagingConfigurationContext}
   */
  /* jshint ignore:end */
  function MessagingConfigurationListInstance(sid) {
    return MessagingConfigurationListInstance.get(sid);
  }

  MessagingConfigurationListInstance._version = version;
  // Path Solution
  MessagingConfigurationListInstance._solution = {serviceSid: serviceSid};
  MessagingConfigurationListInstance._uri = `/Services/${serviceSid}/MessagingConfigurations`;
  /* jshint ignore:start */
  /**
   * create a MessagingConfigurationInstance
   *
   * @function create
   * @memberof Twilio.Verify.V2.ServiceContext.MessagingConfigurationList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.country -
   *          The ISO-3166-1 country code of the country or `all`.
   * @param {string} opts.messagingServiceSid -
   *          The SID of the Messaging Service used for this configuration.
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed MessagingConfigurationInstance
   */
  /* jshint ignore:end */
  MessagingConfigurationListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts.country)) {
      throw new Error('Required parameter "opts.country" missing.');
    }
    if (_.isUndefined(opts.messagingServiceSid)) {
      throw new Error('Required parameter "opts.messagingServiceSid" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({
      'Country': _.get(opts, 'country'),
      'MessagingServiceSid': _.get(opts, 'messagingServiceSid')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new MessagingConfigurationInstance(
        this._version,
        payload,
        this._solution.serviceSid,
        this._solution.country
      ));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Streams MessagingConfigurationInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Verify.V2.ServiceContext.MessagingConfigurationList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  MessagingConfigurationListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists MessagingConfigurationInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Verify.V2.ServiceContext.MessagingConfigurationList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  MessagingConfigurationListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of MessagingConfigurationInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Verify.V2.ServiceContext.MessagingConfigurationList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  MessagingConfigurationListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new MessagingConfigurationPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of MessagingConfigurationInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Verify.V2.ServiceContext.MessagingConfigurationList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  MessagingConfigurationListInstance.getPage = function getPage(targetUrl,
      callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new MessagingConfigurationPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a messaging_configuration
   *
   * @function get
   * @memberof Twilio.Verify.V2.ServiceContext.MessagingConfigurationList#
   *
   * @param {string} country - The ISO-3166-1 country code of the country or `all`.
   *
   * @returns {Twilio.Verify.V2.ServiceContext.MessagingConfigurationContext}
   */
  /* jshint ignore:end */
  MessagingConfigurationListInstance.get = function get(country) {
    return new MessagingConfigurationContext(this._version, this._solution.serviceSid, country);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Verify.V2.ServiceContext.MessagingConfigurationList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  MessagingConfigurationListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  MessagingConfigurationListInstance[util.inspect.custom] = function
      inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return MessagingConfigurationListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the MessagingConfigurationPage
 *
 * @constructor Twilio.Verify.V2.ServiceContext.MessagingConfigurationPage
 *
 * @param {V2} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {MessagingConfigurationSolution} solution - Path solution
 *
 * @returns MessagingConfigurationPage
 */
/* jshint ignore:end */
MessagingConfigurationPage = function MessagingConfigurationPage(version,
    response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(MessagingConfigurationPage.prototype, Page.prototype);
MessagingConfigurationPage.prototype.constructor = MessagingConfigurationPage;

/* jshint ignore:start */
/**
 * Build an instance of MessagingConfigurationInstance
 *
 * @function getInstance
 * @memberof Twilio.Verify.V2.ServiceContext.MessagingConfigurationPage#
 *
 * @param {MessagingConfigurationPayload} payload - Payload response from the API
 *
 * @returns MessagingConfigurationInstance
 */
/* jshint ignore:end */
MessagingConfigurationPage.prototype.getInstance = function getInstance(payload)
    {
  return new MessagingConfigurationInstance(this._version, payload, this._solution.serviceSid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Verify.V2.ServiceContext.MessagingConfigurationPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
MessagingConfigurationPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

MessagingConfigurationPage.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the MessagingConfigurationContext
 *
 * @constructor Twilio.Verify.V2.ServiceContext.MessagingConfigurationInstance
 *
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {string} serviceSid -
 *          The SID of the Service that the resource is associated with
 * @property {string} country -
 *          The ISO-3166-1 country code of the country or `all`.
 * @property {string} messagingServiceSid -
 *          The SID of the Messaging Service used for this configuration.
 * @property {Date} dateCreated -
 *          The RFC 2822 date and time in GMT when the resource was created
 * @property {Date} dateUpdated -
 *          The RFC 2822 date and time in GMT when the resource was last updated
 * @property {string} url - The URL of this resource.
 *
 * @param {V2} version - Version of the resource
 * @param {MessagingConfigurationPayload} payload - The instance payload
 * @param {sid} serviceSid -
 *          The SID of the Service that the resource is associated with
 * @param {string} country - The ISO-3166-1 country code of the country or `all`.
 */
/* jshint ignore:end */
MessagingConfigurationInstance = function
    MessagingConfigurationInstance(version, payload, serviceSid, country) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.serviceSid = payload.service_sid; // jshint ignore:line
  this.country = payload.country; // jshint ignore:line
  this.messagingServiceSid = payload.messaging_service_sid; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {serviceSid: serviceSid, country: country || this.country, };
};

Object.defineProperty(MessagingConfigurationInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new MessagingConfigurationContext(
          this._version,
          this._solution.serviceSid,
          this._solution.country
        );
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * update a MessagingConfigurationInstance
 *
 * @function update
 * @memberof Twilio.Verify.V2.ServiceContext.MessagingConfigurationInstance#
 *
 * @param {object} opts - Options for request
 * @param {string} opts.messagingServiceSid -
 *          The SID of the Messaging Service used for this configuration.
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed MessagingConfigurationInstance
 */
/* jshint ignore:end */
MessagingConfigurationInstance.prototype.update = function update(opts,
    callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * fetch a MessagingConfigurationInstance
 *
 * @function fetch
 * @memberof Twilio.Verify.V2.ServiceContext.MessagingConfigurationInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed MessagingConfigurationInstance
 */
/* jshint ignore:end */
MessagingConfigurationInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * remove a MessagingConfigurationInstance
 *
 * @function remove
 * @memberof Twilio.Verify.V2.ServiceContext.MessagingConfigurationInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed MessagingConfigurationInstance
 */
/* jshint ignore:end */
MessagingConfigurationInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Verify.V2.ServiceContext.MessagingConfigurationInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
MessagingConfigurationInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

MessagingConfigurationInstance.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the MessagingConfigurationContext
 *
 * @constructor Twilio.Verify.V2.ServiceContext.MessagingConfigurationContext
 *
 * @param {V2} version - Version of the resource
 * @param {sid} serviceSid -
 *          The SID of the Service that the resource is associated with
 * @param {string} country - The ISO-3166-1 country code of the country or `all`.
 */
/* jshint ignore:end */
MessagingConfigurationContext = function MessagingConfigurationContext(version,
    serviceSid, country) {
  this._version = version;

  // Path Solution
  this._solution = {serviceSid: serviceSid, country: country, };
  this._uri = `/Services/${serviceSid}/MessagingConfigurations/${country}`;
};

/* jshint ignore:start */
/**
 * update a MessagingConfigurationInstance
 *
 * @function update
 * @memberof Twilio.Verify.V2.ServiceContext.MessagingConfigurationContext#
 *
 * @param {object} opts - Options for request
 * @param {string} opts.messagingServiceSid -
 *          The SID of the Messaging Service used for this configuration.
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed MessagingConfigurationInstance
 */
/* jshint ignore:end */
MessagingConfigurationContext.prototype.update = function update(opts, callback)
    {
  if (_.isUndefined(opts)) {
    throw new Error('Required parameter "opts" missing.');
  }
  if (_.isUndefined(opts.messagingServiceSid)) {
    throw new Error('Required parameter "opts.messagingServiceSid" missing.');
  }

  var deferred = Q.defer();
  var data = values.of({'MessagingServiceSid': _.get(opts, 'messagingServiceSid')});

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new MessagingConfigurationInstance(
      this._version,
      payload,
      this._solution.serviceSid,
      this._solution.country
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * fetch a MessagingConfigurationInstance
 *
 * @function fetch
 * @memberof Twilio.Verify.V2.ServiceContext.MessagingConfigurationContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed MessagingConfigurationInstance
 */
/* jshint ignore:end */
MessagingConfigurationContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new MessagingConfigurationInstance(
      this._version,
      payload,
      this._solution.serviceSid,
      this._solution.country
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a MessagingConfigurationInstance
 *
 * @function remove
 * @memberof Twilio.Verify.V2.ServiceContext.MessagingConfigurationContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed MessagingConfigurationInstance
 */
/* jshint ignore:end */
MessagingConfigurationContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Verify.V2.ServiceContext.MessagingConfigurationContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
MessagingConfigurationContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

MessagingConfigurationContext.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  MessagingConfigurationList: MessagingConfigurationList,
  MessagingConfigurationPage: MessagingConfigurationPage,
  MessagingConfigurationInstance: MessagingConfigurationInstance,
  MessagingConfigurationContext: MessagingConfigurationContext
};
