'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var MemberList = require('./queue/member').MemberList;
var Page = require('../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../base/deserialize');  /* jshint ignore:line */
var values = require('../../../../base/values');  /* jshint ignore:line */

var QueueList;
var QueuePage;
var QueueInstance;
var QueueContext;

/* jshint ignore:start */
/**
 * Initialize the QueueList
 *
 * @constructor Twilio.Api.V2010.AccountContext.QueueList
 *
 * @param {Twilio.Api.V2010} version - Version of the resource
 * @param {string} accountSid - The SID of the Account that created this resource
 */
/* jshint ignore:end */
QueueList = function QueueList(version, accountSid) {
  /* jshint ignore:start */
  /**
   * @function queues
   * @memberof Twilio.Api.V2010.AccountContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Api.V2010.AccountContext.QueueContext}
   */
  /* jshint ignore:end */
  function QueueListInstance(sid) {
    return QueueListInstance.get(sid);
  }

  QueueListInstance._version = version;
  // Path Solution
  QueueListInstance._solution = {accountSid: accountSid};
  QueueListInstance._uri = `/Accounts/${accountSid}/Queues.json`;
  /* jshint ignore:start */
  /**
   * Streams QueueInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Api.V2010.AccountContext.QueueList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  QueueListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists QueueInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Api.V2010.AccountContext.QueueList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  QueueListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of QueueInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Api.V2010.AccountContext.QueueList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  QueueListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new QueuePage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of QueueInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Api.V2010.AccountContext.QueueList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  QueueListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new QueuePage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * create a QueueInstance
   *
   * @function create
   * @memberof Twilio.Api.V2010.AccountContext.QueueList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.friendlyName - A string to describe this resource
   * @param {number} [opts.maxSize] - The max number of calls allowed in the queue
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed QueueInstance
   */
  /* jshint ignore:end */
  QueueListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts.friendlyName)) {
      throw new Error('Required parameter "opts.friendlyName" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({
      'FriendlyName': _.get(opts, 'friendlyName'),
      'MaxSize': _.get(opts, 'maxSize')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new QueueInstance(
        this._version,
        payload,
        this._solution.accountSid,
        this._solution.sid
      ));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a queue
   *
   * @function get
   * @memberof Twilio.Api.V2010.AccountContext.QueueList#
   *
   * @param {string} sid - The unique string that identifies this resource
   *
   * @returns {Twilio.Api.V2010.AccountContext.QueueContext}
   */
  /* jshint ignore:end */
  QueueListInstance.get = function get(sid) {
    return new QueueContext(this._version, this._solution.accountSid, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Api.V2010.AccountContext.QueueList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  QueueListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  QueueListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return QueueListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the QueuePage
 *
 * @constructor Twilio.Api.V2010.AccountContext.QueuePage
 *
 * @param {V2010} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {QueueSolution} solution - Path solution
 *
 * @returns QueuePage
 */
/* jshint ignore:end */
QueuePage = function QueuePage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(QueuePage.prototype, Page.prototype);
QueuePage.prototype.constructor = QueuePage;

/* jshint ignore:start */
/**
 * Build an instance of QueueInstance
 *
 * @function getInstance
 * @memberof Twilio.Api.V2010.AccountContext.QueuePage#
 *
 * @param {QueuePayload} payload - Payload response from the API
 *
 * @returns QueueInstance
 */
/* jshint ignore:end */
QueuePage.prototype.getInstance = function getInstance(payload) {
  return new QueueInstance(this._version, payload, this._solution.accountSid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Api.V2010.AccountContext.QueuePage#
 *
 * @returns Object
 */
/* jshint ignore:end */
QueuePage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

QueuePage.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the QueueContext
 *
 * @constructor Twilio.Api.V2010.AccountContext.QueueInstance
 *
 * @property {Date} dateUpdated -
 *          The RFC 2822 date and time in GMT that this resource was last updated
 * @property {number} currentSize - The number of calls currently in the queue.
 * @property {string} friendlyName -
 *          A string that you assigned to describe this resource
 * @property {string} uri -
 *          The URI of this resource, relative to `https://api.twilio.com`
 * @property {string} accountSid -
 *          The SID of the Account that created this resource
 * @property {number} averageWaitTime - Average wait time of members in the queue
 * @property {string} sid - The unique string that identifies this resource
 * @property {Date} dateCreated -
 *          The RFC 2822 date and time in GMT that this resource was created
 * @property {number} maxSize - The max number of calls allowed in the queue
 *
 * @param {V2010} version - Version of the resource
 * @param {QueuePayload} payload - The instance payload
 * @param {sid} accountSid - The SID of the Account that created this resource
 * @param {sid} sid - The unique string that identifies this resource
 */
/* jshint ignore:end */
QueueInstance = function QueueInstance(version, payload, accountSid, sid) {
  this._version = version;

  // Marshaled Properties
  this.dateUpdated = deserialize.rfc2822DateTime(payload.date_updated); // jshint ignore:line
  this.currentSize = deserialize.integer(payload.current_size); // jshint ignore:line
  this.friendlyName = payload.friendly_name; // jshint ignore:line
  this.uri = payload.uri; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.averageWaitTime = deserialize.integer(payload.average_wait_time); // jshint ignore:line
  this.sid = payload.sid; // jshint ignore:line
  this.dateCreated = deserialize.rfc2822DateTime(payload.date_created); // jshint ignore:line
  this.maxSize = deserialize.integer(payload.max_size); // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {accountSid: accountSid, sid: sid || this.sid, };
};

Object.defineProperty(QueueInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new QueueContext(this._version, this._solution.accountSid, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a QueueInstance
 *
 * @function fetch
 * @memberof Twilio.Api.V2010.AccountContext.QueueInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed QueueInstance
 */
/* jshint ignore:end */
QueueInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * update a QueueInstance
 *
 * @function update
 * @memberof Twilio.Api.V2010.AccountContext.QueueInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.friendlyName] - A string to describe this resource
 * @param {number} [opts.maxSize] - The max number of calls allowed in the queue
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed QueueInstance
 */
/* jshint ignore:end */
QueueInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * remove a QueueInstance
 *
 * @function remove
 * @memberof Twilio.Api.V2010.AccountContext.QueueInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed QueueInstance
 */
/* jshint ignore:end */
QueueInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * Access the members
 *
 * @function members
 * @memberof Twilio.Api.V2010.AccountContext.QueueInstance#
 *
 * @returns {Twilio.Api.V2010.AccountContext.QueueContext.MemberList}
 */
/* jshint ignore:end */
QueueInstance.prototype.members = function members() {
  return this._proxy.members;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Api.V2010.AccountContext.QueueInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
QueueInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

QueueInstance.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the QueueContext
 *
 * @constructor Twilio.Api.V2010.AccountContext.QueueContext
 *
 * @property {Twilio.Api.V2010.AccountContext.QueueContext.MemberList} members -
 *          members resource
 *
 * @param {V2010} version - Version of the resource
 * @param {sid} accountSid -
 *          The SID of the Account that created the resource(s) to fetch
 * @param {sid} sid - The unique string that identifies this resource
 */
/* jshint ignore:end */
QueueContext = function QueueContext(version, accountSid, sid) {
  this._version = version;

  // Path Solution
  this._solution = {accountSid: accountSid, sid: sid, };
  this._uri = `/Accounts/${accountSid}/Queues/${sid}.json`;

  // Dependents
  this._members = undefined;
};

/* jshint ignore:start */
/**
 * fetch a QueueInstance
 *
 * @function fetch
 * @memberof Twilio.Api.V2010.AccountContext.QueueContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed QueueInstance
 */
/* jshint ignore:end */
QueueContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new QueueInstance(
      this._version,
      payload,
      this._solution.accountSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * update a QueueInstance
 *
 * @function update
 * @memberof Twilio.Api.V2010.AccountContext.QueueContext#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.friendlyName] - A string to describe this resource
 * @param {number} [opts.maxSize] - The max number of calls allowed in the queue
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed QueueInstance
 */
/* jshint ignore:end */
QueueContext.prototype.update = function update(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({
    'FriendlyName': _.get(opts, 'friendlyName'),
    'MaxSize': _.get(opts, 'maxSize')
  });

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new QueueInstance(
      this._version,
      payload,
      this._solution.accountSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a QueueInstance
 *
 * @function remove
 * @memberof Twilio.Api.V2010.AccountContext.QueueContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed QueueInstance
 */
/* jshint ignore:end */
QueueContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

Object.defineProperty(QueueContext.prototype,
  'members', {
    get: function() {
      if (!this._members) {
        this._members = new MemberList(this._version, this._solution.accountSid, this._solution.sid);
      }
      return this._members;
    }
});

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Api.V2010.AccountContext.QueueContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
QueueContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

QueueContext.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  QueueList: QueueList,
  QueuePage: QueuePage,
  QueueInstance: QueueInstance,
  QueueContext: QueueContext
};
