'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../base/deserialize');  /* jshint ignore:line */
var values = require('../../../../base/values');  /* jshint ignore:line */

var QueryList;
var QueryPage;
var QueryInstance;
var QueryContext;

/* jshint ignore:start */
/**
 * Initialize the QueryList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Autopilot.V1.AssistantContext.QueryList
 *
 * @param {Twilio.Autopilot.V1} version - Version of the resource
 * @param {string} assistantSid -
 *          The SID of the Assistant that is the parent of the resource
 */
/* jshint ignore:end */
QueryList = function QueryList(version, assistantSid) {
  /* jshint ignore:start */
  /**
   * @function queries
   * @memberof Twilio.Autopilot.V1.AssistantContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Autopilot.V1.AssistantContext.QueryContext}
   */
  /* jshint ignore:end */
  function QueryListInstance(sid) {
    return QueryListInstance.get(sid);
  }

  QueryListInstance._version = version;
  // Path Solution
  QueryListInstance._solution = {assistantSid: assistantSid};
  QueryListInstance._uri = `/Assistants/${assistantSid}/Queries`;
  /* jshint ignore:start */
  /**
   * Streams QueryInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Autopilot.V1.AssistantContext.QueryList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.language] -
   *          The ISO language-country string that specifies the language used by the Query resources to read
   * @param {string} [opts.modelBuild] -
   *          The SID or unique name of the Model Build to be queried
   * @param {string} [opts.status] - The status of the resources to read
   * @param {string} [opts.dialogueSid] -
   *          The SID of the {@link https://www.twilio.com/docs/autopilot/api/dialogue|Dialogue}.
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  QueryListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists QueryInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Autopilot.V1.AssistantContext.QueryList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.language] -
   *          The ISO language-country string that specifies the language used by the Query resources to read
   * @param {string} [opts.modelBuild] -
   *          The SID or unique name of the Model Build to be queried
   * @param {string} [opts.status] - The status of the resources to read
   * @param {string} [opts.dialogueSid] -
   *          The SID of the {@link https://www.twilio.com/docs/autopilot/api/dialogue|Dialogue}.
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  QueryListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of QueryInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Autopilot.V1.AssistantContext.QueryList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.language] -
   *          The ISO language-country string that specifies the language used by the Query resources to read
   * @param {string} [opts.modelBuild] -
   *          The SID or unique name of the Model Build to be queried
   * @param {string} [opts.status] - The status of the resources to read
   * @param {string} [opts.dialogueSid] -
   *          The SID of the {@link https://www.twilio.com/docs/autopilot/api/dialogue|Dialogue}.
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  QueryListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'Language': _.get(opts, 'language'),
      'ModelBuild': _.get(opts, 'modelBuild'),
      'Status': _.get(opts, 'status'),
      'DialogueSid': _.get(opts, 'dialogueSid'),
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new QueryPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of QueryInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Autopilot.V1.AssistantContext.QueryList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  QueryListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new QueryPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * create a QueryInstance
   *
   * @function create
   * @memberof Twilio.Autopilot.V1.AssistantContext.QueryList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.language -
   *          The ISO language-country string that specifies the language used for the new query
   * @param {string} opts.query - The end-user's natural language input
   * @param {string} [opts.tasks] - The list of tasks to limit the new query to
   * @param {string} [opts.modelBuild] -
   *          The SID or unique name of the Model Build to be queried
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed QueryInstance
   */
  /* jshint ignore:end */
  QueryListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts.language)) {
      throw new Error('Required parameter "opts.language" missing.');
    }
    if (_.isUndefined(opts.query)) {
      throw new Error('Required parameter "opts.query" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({
      'Language': _.get(opts, 'language'),
      'Query': _.get(opts, 'query'),
      'Tasks': _.get(opts, 'tasks'),
      'ModelBuild': _.get(opts, 'modelBuild')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new QueryInstance(
        this._version,
        payload,
        this._solution.assistantSid,
        this._solution.sid
      ));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a query
   *
   * @function get
   * @memberof Twilio.Autopilot.V1.AssistantContext.QueryList#
   *
   * @param {string} sid - The unique string that identifies the resource
   *
   * @returns {Twilio.Autopilot.V1.AssistantContext.QueryContext}
   */
  /* jshint ignore:end */
  QueryListInstance.get = function get(sid) {
    return new QueryContext(this._version, this._solution.assistantSid, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Autopilot.V1.AssistantContext.QueryList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  QueryListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  QueryListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return QueryListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the QueryPage
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Autopilot.V1.AssistantContext.QueryPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {QuerySolution} solution - Path solution
 *
 * @returns QueryPage
 */
/* jshint ignore:end */
QueryPage = function QueryPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(QueryPage.prototype, Page.prototype);
QueryPage.prototype.constructor = QueryPage;

/* jshint ignore:start */
/**
 * Build an instance of QueryInstance
 *
 * @function getInstance
 * @memberof Twilio.Autopilot.V1.AssistantContext.QueryPage#
 *
 * @param {QueryPayload} payload - Payload response from the API
 *
 * @returns QueryInstance
 */
/* jshint ignore:end */
QueryPage.prototype.getInstance = function getInstance(payload) {
  return new QueryInstance(this._version, payload, this._solution.assistantSid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Autopilot.V1.AssistantContext.QueryPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
QueryPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

QueryPage.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the QueryContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Autopilot.V1.AssistantContext.QueryInstance
 *
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {Date} dateCreated -
 *          The RFC 2822 date and time in GMT when the resource was created
 * @property {Date} dateUpdated -
 *          The RFC 2822 date and time in GMT when the resource was last updated
 * @property {object} results -
 *          The natural language analysis results that include the Task recognized and a list of identified Fields
 * @property {string} language -
 *          The ISO language-country string that specifies the language used by the Query
 * @property {string} modelBuildSid -
 *          The SID of the {@link https://www.twilio.com/docs/autopilot/api/model-build|Model Build} queried
 * @property {string} query - The end-user's natural language input
 * @property {string} sampleSid -
 *          The SID of an optional reference to the Sample created from the query
 * @property {string} assistantSid -
 *          The SID of the Assistant that is the parent of the resource
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} status - The status of the Query
 * @property {string} url - The absolute URL of the Query resource
 * @property {string} sourceChannel -
 *          The communication channel from where the end-user input came
 * @property {string} dialogueSid -
 *          The SID of the {@link https://www.twilio.com/docs/autopilot/api/dialogue|Dialogue}.
 *
 * @param {V1} version - Version of the resource
 * @param {QueryPayload} payload - The instance payload
 * @param {sid} assistantSid -
 *          The SID of the Assistant that is the parent of the resource
 * @param {sid_like} sid - The unique string that identifies the resource
 */
/* jshint ignore:end */
QueryInstance = function QueryInstance(version, payload, assistantSid, sid) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.results = payload.results; // jshint ignore:line
  this.language = payload.language; // jshint ignore:line
  this.modelBuildSid = payload.model_build_sid; // jshint ignore:line
  this.query = payload.query; // jshint ignore:line
  this.sampleSid = payload.sample_sid; // jshint ignore:line
  this.assistantSid = payload.assistant_sid; // jshint ignore:line
  this.sid = payload.sid; // jshint ignore:line
  this.status = payload.status; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.sourceChannel = payload.source_channel; // jshint ignore:line
  this.dialogueSid = payload.dialogue_sid; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {assistantSid: assistantSid, sid: sid || this.sid, };
};

Object.defineProperty(QueryInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new QueryContext(this._version, this._solution.assistantSid, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a QueryInstance
 *
 * @function fetch
 * @memberof Twilio.Autopilot.V1.AssistantContext.QueryInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed QueryInstance
 */
/* jshint ignore:end */
QueryInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * update a QueryInstance
 *
 * @function update
 * @memberof Twilio.Autopilot.V1.AssistantContext.QueryInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.sampleSid] -
 *          The SID of an optional reference to the Sample created from the query
 * @param {string} [opts.status] - The new status of the resource
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed QueryInstance
 */
/* jshint ignore:end */
QueryInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * remove a QueryInstance
 *
 * @function remove
 * @memberof Twilio.Autopilot.V1.AssistantContext.QueryInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed QueryInstance
 */
/* jshint ignore:end */
QueryInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Autopilot.V1.AssistantContext.QueryInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
QueryInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

QueryInstance.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the QueryContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Autopilot.V1.AssistantContext.QueryContext
 *
 * @param {V1} version - Version of the resource
 * @param {sid_like} assistantSid -
 *          The SID of the Assistant that is the parent of the resource to fetch
 * @param {sid_like} sid - The unique string that identifies the resource
 */
/* jshint ignore:end */
QueryContext = function QueryContext(version, assistantSid, sid) {
  this._version = version;

  // Path Solution
  this._solution = {assistantSid: assistantSid, sid: sid, };
  this._uri = `/Assistants/${assistantSid}/Queries/${sid}`;
};

/* jshint ignore:start */
/**
 * fetch a QueryInstance
 *
 * @function fetch
 * @memberof Twilio.Autopilot.V1.AssistantContext.QueryContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed QueryInstance
 */
/* jshint ignore:end */
QueryContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new QueryInstance(
      this._version,
      payload,
      this._solution.assistantSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * update a QueryInstance
 *
 * @function update
 * @memberof Twilio.Autopilot.V1.AssistantContext.QueryContext#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.sampleSid] -
 *          The SID of an optional reference to the Sample created from the query
 * @param {string} [opts.status] - The new status of the resource
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed QueryInstance
 */
/* jshint ignore:end */
QueryContext.prototype.update = function update(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({'SampleSid': _.get(opts, 'sampleSid'), 'Status': _.get(opts, 'status')});

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new QueryInstance(
      this._version,
      payload,
      this._solution.assistantSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a QueryInstance
 *
 * @function remove
 * @memberof Twilio.Autopilot.V1.AssistantContext.QueryContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed QueryInstance
 */
/* jshint ignore:end */
QueryContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Autopilot.V1.AssistantContext.QueryContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
QueryContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

QueryContext.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  QueryList: QueryList,
  QueryPage: QueryPage,
  QueryInstance: QueryInstance,
  QueryContext: QueryContext
};
