'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../../base/deserialize');  /* jshint ignore:line */
var values = require('../../../../../base/values');  /* jshint ignore:line */

var BundleCopyList;
var BundleCopyPage;
var BundleCopyInstance;

/* jshint ignore:start */
/**
 * Initialize the BundleCopyList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Numbers.V2.RegulatoryComplianceContext.BundleContext.BundleCopyList
 *
 * @param {Twilio.Numbers.V2} version - Version of the resource
 * @param {string} bundleSid - The unique string that identifies the resource.
 */
/* jshint ignore:end */
BundleCopyList = function BundleCopyList(version, bundleSid) {
  /* jshint ignore:start */
  /**
   * @function bundleCopies
   * @memberof Twilio.Numbers.V2.RegulatoryComplianceContext.BundleContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Numbers.V2.RegulatoryComplianceContext.BundleContext.BundleCopyContext}
   */
  /* jshint ignore:end */
  function BundleCopyListInstance(sid) {
    return BundleCopyListInstance.get(sid);
  }

  BundleCopyListInstance._version = version;
  // Path Solution
  BundleCopyListInstance._solution = {bundleSid: bundleSid};
  BundleCopyListInstance._uri = `/RegulatoryCompliance/Bundles/${bundleSid}/Copies`;
  /* jshint ignore:start */
  /**
   * create a BundleCopyInstance
   *
   * @function create
   * @memberof Twilio.Numbers.V2.RegulatoryComplianceContext.BundleContext.BundleCopyList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.friendlyName] -
   *          The string that you assigned to describe the copied bundle
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed BundleCopyInstance
   */
  /* jshint ignore:end */
  BundleCopyListInstance.create = function create(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({'FriendlyName': _.get(opts, 'friendlyName')});

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new BundleCopyInstance(this._version, payload));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Numbers.V2.RegulatoryComplianceContext.BundleContext.BundleCopyList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  BundleCopyListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  BundleCopyListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return BundleCopyListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the BundleCopyPage
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Numbers.V2.RegulatoryComplianceContext.BundleContext.BundleCopyPage
 *
 * @param {V2} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {BundleCopySolution} solution - Path solution
 *
 * @returns BundleCopyPage
 */
/* jshint ignore:end */
BundleCopyPage = function BundleCopyPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(BundleCopyPage.prototype, Page.prototype);
BundleCopyPage.prototype.constructor = BundleCopyPage;

/* jshint ignore:start */
/**
 * Build an instance of BundleCopyInstance
 *
 * @function getInstance
 * @memberof Twilio.Numbers.V2.RegulatoryComplianceContext.BundleContext.BundleCopyPage#
 *
 * @param {BundleCopyPayload} payload - Payload response from the API
 *
 * @returns BundleCopyInstance
 */
/* jshint ignore:end */
BundleCopyPage.prototype.getInstance = function getInstance(payload) {
  return new BundleCopyInstance(this._version, payload, this._solution.bundleSid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Numbers.V2.RegulatoryComplianceContext.BundleContext.BundleCopyPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
BundleCopyPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

BundleCopyPage.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the BundleCopyContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Numbers.V2.RegulatoryComplianceContext.BundleContext.BundleCopyInstance
 *
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {string} regulationSid - The unique string of a regulation
 * @property {string} friendlyName -
 *          The string that you assigned to describe the resource
 * @property {bundle_copy.status} status -
 *          The verification status of the Bundle resource
 * @property {Date} validUntil -
 *          The ISO 8601 date and time in GMT when the resource will be valid until
 * @property {string} email - The email address
 * @property {string} statusCallback -
 *          The URL we call to inform your application of status changes
 * @property {Date} dateCreated -
 *          The ISO 8601 date and time in GMT when the resource was created
 * @property {Date} dateUpdated -
 *          The ISO 8601 date and time in GMT when the resource was last updated
 *
 * @param {V2} version - Version of the resource
 * @param {BundleCopyPayload} payload - The instance payload
 * @param {sid} bundleSid - The unique string that identifies the resource.
 */
/* jshint ignore:end */
BundleCopyInstance = function BundleCopyInstance(version, payload, bundleSid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.regulationSid = payload.regulation_sid; // jshint ignore:line
  this.friendlyName = payload.friendly_name; // jshint ignore:line
  this.status = payload.status; // jshint ignore:line
  this.validUntil = deserialize.iso8601DateTime(payload.valid_until); // jshint ignore:line
  this.email = payload.email; // jshint ignore:line
  this.statusCallback = payload.status_callback; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {bundleSid: bundleSid, };
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Numbers.V2.RegulatoryComplianceContext.BundleContext.BundleCopyInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
BundleCopyInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

BundleCopyInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  BundleCopyList: BundleCopyList,
  BundleCopyPage: BundleCopyPage,
  BundleCopyInstance: BundleCopyInstance
};
