/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../../base/Page');
import Response = require('../../../../../http/response');
import V1 = require('../../../V1');
import { SerializableClass } from '../../../../../interfaces';

/**
 * Initialize the NotificationList
 *
 * @param version - Version of the resource
 * @param chatServiceSid - The unique string that identifies the resource
 */
declare function NotificationList(version: V1, chatServiceSid: string): NotificationListInstance;

/**
 * Options to pass to update
 *
 * @property addedToConversation.enabled - Whether to send a notification when a participant is added to a conversation.
 * @property addedToConversation.sound - The name of the sound to play when a participant is added to a conversation.
 * @property addedToConversation.template - The template to use to create the notification text displayed when a participant is added to a conversation.
 * @property logEnabled - Weather the notification logging is enabled.
 * @property newMessage.badgeCountEnabled - Whether the new message badge is enabled.
 * @property newMessage.enabled - Whether to send a notification when a new message is added to a conversation.
 * @property newMessage.sound - The name of the sound to play when a new message is added to a conversation.
 * @property newMessage.template - The template to use to create the notification text displayed when a new message is added to a conversation.
 * @property newMessage.withMedia.enabled - Whether to send a notification when a new message with media/file attachments is added to a conversation.
 * @property newMessage.withMedia.template - The template to use to create the notification text displayed when a new message with media/file attachments is added to a conversation.
 * @property removedFromConversation.enabled - Whether to send a notification to a user when they are removed from a conversation.
 * @property removedFromConversation.sound - The name of the sound to play to a user when they are removed from a conversation.
 * @property removedFromConversation.template - The template to use to create the notification text displayed to a user when they are removed.
 */
interface NotificationInstanceUpdateOptions {
  addedToConversation?: {
    enabled?: boolean;
    template?: string;
    sound?: string;
  };
  logEnabled?: boolean;
  newMessage?: {
    enabled?: boolean;
    template?: string;
    sound?: string;
    badgeCountEnabled?: boolean;
    withMedia?: {
      enabled?: boolean;
      template?: string;
    };
  };
  removedFromConversation?: {
    enabled?: boolean;
    template?: string;
    sound?: string;
  };
}

interface NotificationListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): NotificationContext;
  /**
   * Constructs a notification
   */
  get(): NotificationContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface NotificationPayload extends NotificationResource, Page.TwilioResponsePayload {
}

interface NotificationResource {
  account_sid: string;
  added_to_conversation: object;
  chat_service_sid: string;
  log_enabled: boolean;
  new_message: object;
  removed_from_conversation: object;
  url: string;
}

interface NotificationSolution {
  chatServiceSid?: string;
}


declare class NotificationContext {
  /**
   * Initialize the NotificationContext
   *
   * @param version - Version of the resource
   * @param chatServiceSid - The SID of the Conversation Service that the Configuration applies to.
   */
  constructor(version: V1, chatServiceSid: string);

  /**
   * fetch a NotificationInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: NotificationInstance) => any): Promise<NotificationInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a NotificationInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: NotificationInstance) => any): Promise<NotificationInstance>;
  /**
   * update a NotificationInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: NotificationInstanceUpdateOptions, callback?: (error: Error | null, items: NotificationInstance) => any): Promise<NotificationInstance>;
}


declare class NotificationInstance extends SerializableClass {
  /**
   * Initialize the NotificationContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param chatServiceSid - The unique string that identifies the resource
   */
  constructor(version: V1, payload: NotificationPayload, chatServiceSid: string);

  private _proxy: NotificationContext;
  accountSid: string;
  addedToConversation: any;
  chatServiceSid: string;
  /**
   * fetch a NotificationInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: NotificationInstance) => any): Promise<NotificationInstance>;
  logEnabled: boolean;
  newMessage: any;
  removedFromConversation: any;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a NotificationInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: NotificationInstance) => any): Promise<NotificationInstance>;
  /**
   * update a NotificationInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: NotificationInstanceUpdateOptions, callback?: (error: Error | null, items: NotificationInstance) => any): Promise<NotificationInstance>;
  url: string;
}


declare class NotificationPage extends Page<V1, NotificationPayload, NotificationResource, NotificationInstance> {
  /**
   * Initialize the NotificationPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: NotificationSolution);

  /**
   * Build an instance of NotificationInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: NotificationPayload): NotificationInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { NotificationContext, NotificationInstance, NotificationInstanceUpdateOptions, NotificationList, NotificationListInstance, NotificationPage, NotificationPayload, NotificationResource, NotificationSolution }
