/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import { SerializableClass } from '../../../../interfaces';

type BillingPeriodBpType = 'ready'|'active';

/**
 * Initialize the BillingPeriodList
 *
 * @param version - Version of the resource
 * @param simSid - The SID of the Super SIM the Billing Period belongs to
 */
declare function BillingPeriodList(version: V1, simSid: string): BillingPeriodListInstance;

interface BillingPeriodListInstance {
  /**
   * Streams BillingPeriodInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: BillingPeriodInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams BillingPeriodInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: BillingPeriodListInstanceEachOptions, callback?: (item: BillingPeriodInstance, done: (err?: Error) => void) => void): void;
  /**
   * Retrieve a single target page of BillingPeriodInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: BillingPeriodPage) => any): Promise<BillingPeriodPage>;
  /**
   * Retrieve a single target page of BillingPeriodInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: BillingPeriodPage) => any): Promise<BillingPeriodPage>;
  /**
   * Lists BillingPeriodInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: BillingPeriodInstance[]) => any): Promise<BillingPeriodInstance[]>;
  /**
   * Lists BillingPeriodInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: BillingPeriodListInstanceOptions, callback?: (error: Error | null, items: BillingPeriodInstance[]) => any): Promise<BillingPeriodInstance[]>;
  /**
   * Retrieve a single page of BillingPeriodInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: BillingPeriodPage) => any): Promise<BillingPeriodPage>;
  /**
   * Retrieve a single page of BillingPeriodInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: BillingPeriodListInstancePageOptions, callback?: (error: Error | null, items: BillingPeriodPage) => any): Promise<BillingPeriodPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface BillingPeriodListInstanceEachOptions {
  callback?: (item: BillingPeriodInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface BillingPeriodListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface BillingPeriodListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface BillingPeriodPayload extends BillingPeriodResource, Page.TwilioResponsePayload {
}

interface BillingPeriodResource {
  account_sid: string;
  date_created: Date;
  date_updated: Date;
  end_time: Date;
  period_type: BillingPeriodBpType;
  sid: string;
  sim_sid: string;
  start_time: Date;
}

interface BillingPeriodSolution {
  simSid?: string;
}


declare class BillingPeriodInstance extends SerializableClass {
  /**
   * Initialize the BillingPeriodContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param simSid - The SID of the Super SIM the Billing Period belongs to
   */
  constructor(version: V1, payload: BillingPeriodPayload, simSid: string);

  accountSid: string;
  dateCreated: Date;
  dateUpdated: Date;
  endTime: Date;
  periodType: BillingPeriodBpType;
  sid: string;
  simSid: string;
  startTime: Date;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class BillingPeriodPage extends Page<V1, BillingPeriodPayload, BillingPeriodResource, BillingPeriodInstance> {
  /**
   * Initialize the BillingPeriodPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: BillingPeriodSolution);

  /**
   * Build an instance of BillingPeriodInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: BillingPeriodPayload): BillingPeriodInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { BillingPeriodBpType, BillingPeriodInstance, BillingPeriodList, BillingPeriodListInstance, BillingPeriodListInstanceEachOptions, BillingPeriodListInstanceOptions, BillingPeriodListInstancePageOptions, BillingPeriodPage, BillingPeriodPayload, BillingPeriodResource, BillingPeriodSolution }
