/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

type UsageRecordGranularity = 'hour'|'day'|'all';

type UsageRecordGroup = 'sim'|'fleet'|'network'|'isoCountry';

type UsageRecordSortBy = 'time';

/**
 * Initialize the UsageRecordList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 */
declare function UsageRecordList(version: V1): UsageRecordListInstance;

interface UsageRecordListInstance {
  /**
   * Streams UsageRecordInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: UsageRecordInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams UsageRecordInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: UsageRecordListInstanceEachOptions, callback?: (item: UsageRecordInstance, done: (err?: Error) => void) => void): void;
  /**
   * Retrieve a single target page of UsageRecordInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: UsageRecordPage) => any): Promise<UsageRecordPage>;
  /**
   * Retrieve a single target page of UsageRecordInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: UsageRecordPage) => any): Promise<UsageRecordPage>;
  /**
   * Lists UsageRecordInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: UsageRecordInstance[]) => any): Promise<UsageRecordInstance[]>;
  /**
   * Lists UsageRecordInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: UsageRecordListInstanceOptions, callback?: (error: Error | null, items: UsageRecordInstance[]) => any): Promise<UsageRecordInstance[]>;
  /**
   * Retrieve a single page of UsageRecordInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: UsageRecordPage) => any): Promise<UsageRecordPage>;
  /**
   * Retrieve a single page of UsageRecordInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: UsageRecordListInstancePageOptions, callback?: (error: Error | null, items: UsageRecordPage) => any): Promise<UsageRecordPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property endTime - Only include usage that occurred before this time (exclusive).
 * @property fleet - SID or unique name of a Fleet resource. Only show UsageRecords representing usage for Super SIMs belonging to this Fleet resource at the time the usage occurred.
 * @property granularity - Time-based grouping that UsageRecords should be aggregated by. Can be: `hour`, `day`, or `all`. Default is `all`.
 * @property group - Dimension over which to aggregate usage records.
 * @property isoCountry - Alpha-2 ISO Country Code. Only show UsageRecords representing usage in this country.
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property network - SID of a Network resource. Only show UsageRecords representing usage on this network.
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 * @property sim - SID or unique name of a Sim resource. Only show UsageRecords representing usage incurred by this Super SIM.
 * @property startTime - Only include usage that occurred at or after this time.
 */
interface UsageRecordListInstanceEachOptions {
  callback?: (item: UsageRecordInstance, done: (err?: Error) => void) => void;
  done?: Function;
  endTime?: Date;
  fleet?: string;
  granularity?: UsageRecordGranularity;
  group?: UsageRecordGroup;
  isoCountry?: string;
  limit?: number;
  network?: string;
  pageSize?: number;
  sim?: string;
  startTime?: Date;
}

/**
 * Options to pass to list
 *
 * @property endTime - Only include usage that occurred before this time (exclusive).
 * @property fleet - SID or unique name of a Fleet resource. Only show UsageRecords representing usage for Super SIMs belonging to this Fleet resource at the time the usage occurred.
 * @property granularity - Time-based grouping that UsageRecords should be aggregated by. Can be: `hour`, `day`, or `all`. Default is `all`.
 * @property group - Dimension over which to aggregate usage records.
 * @property isoCountry - Alpha-2 ISO Country Code. Only show UsageRecords representing usage in this country.
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property network - SID of a Network resource. Only show UsageRecords representing usage on this network.
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 * @property sim - SID or unique name of a Sim resource. Only show UsageRecords representing usage incurred by this Super SIM.
 * @property startTime - Only include usage that occurred at or after this time.
 */
interface UsageRecordListInstanceOptions {
  endTime?: Date;
  fleet?: string;
  granularity?: UsageRecordGranularity;
  group?: UsageRecordGroup;
  isoCountry?: string;
  limit?: number;
  network?: string;
  pageSize?: number;
  sim?: string;
  startTime?: Date;
}

/**
 * Options to pass to page
 *
 * @property endTime - Only include usage that occurred before this time (exclusive).
 * @property fleet - SID or unique name of a Fleet resource. Only show UsageRecords representing usage for Super SIMs belonging to this Fleet resource at the time the usage occurred.
 * @property granularity - Time-based grouping that UsageRecords should be aggregated by. Can be: `hour`, `day`, or `all`. Default is `all`.
 * @property group - Dimension over which to aggregate usage records.
 * @property isoCountry - Alpha-2 ISO Country Code. Only show UsageRecords representing usage in this country.
 * @property network - SID of a Network resource. Only show UsageRecords representing usage on this network.
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 * @property sim - SID or unique name of a Sim resource. Only show UsageRecords representing usage incurred by this Super SIM.
 * @property startTime - Only include usage that occurred at or after this time.
 */
interface UsageRecordListInstancePageOptions {
  endTime?: Date;
  fleet?: string;
  granularity?: UsageRecordGranularity;
  group?: UsageRecordGroup;
  isoCountry?: string;
  network?: string;
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
  sim?: string;
  startTime?: Date;
}

interface UsageRecordPayload extends UsageRecordResource, Page.TwilioResponsePayload {
}

interface UsageRecordResource {
  account_sid: string;
  billed_unit: string;
  data_download: number;
  data_total: number;
  data_total_billed: number;
  data_upload: number;
  fleet_sid: string;
  iso_country: string;
  network_sid: string;
  period: object;
  sim_sid: string;
}

interface UsageRecordSolution {
}


declare class UsageRecordInstance extends SerializableClass {
  /**
   * Initialize the UsageRecordContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   */
  constructor(version: V1, payload: UsageRecordPayload);

  accountSid: string;
  billedUnit: string;
  dataDownload: number;
  dataTotal: number;
  dataTotalBilled: number;
  dataUpload: number;
  fleetSid: string;
  isoCountry: string;
  networkSid: string;
  period: any;
  simSid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class UsageRecordPage extends Page<V1, UsageRecordPayload, UsageRecordResource, UsageRecordInstance> {
  /**
   * Initialize the UsageRecordPage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: UsageRecordSolution);

  /**
   * Build an instance of UsageRecordInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: UsageRecordPayload): UsageRecordInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { UsageRecordGranularity, UsageRecordGroup, UsageRecordInstance, UsageRecordList, UsageRecordListInstance, UsageRecordListInstanceEachOptions, UsageRecordListInstanceOptions, UsageRecordListInstancePageOptions, UsageRecordPage, UsageRecordPayload, UsageRecordResource, UsageRecordSolution, UsageRecordSortBy }
