'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../base/Page');  /* jshint ignore:line */
var values = require('../../../../base/values');  /* jshint ignore:line */

var UsageList;
var UsagePage;
var UsageInstance;
var UsageContext;

/* jshint ignore:start */
/**
 * Initialize the UsageList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Wireless.SimContext.UsageList
 *
 * @param {Twilio.Preview.Wireless} version - Version of the resource
 * @param {string} simSid - The sim_sid
 */
/* jshint ignore:end */
UsageList = function UsageList(version, simSid) {
  /* jshint ignore:start */
  /**
   * @function usage
   * @memberof Twilio.Preview.Wireless.SimContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Preview.Wireless.SimContext.UsageContext}
   */
  /* jshint ignore:end */
  function UsageListInstance(sid) {
    return UsageListInstance.get(sid);
  }

  UsageListInstance._version = version;
  // Path Solution
  UsageListInstance._solution = {simSid: simSid};
  /* jshint ignore:start */
  /**
   * Constructs a usage
   *
   * @function get
   * @memberof Twilio.Preview.Wireless.SimContext.UsageList#
   *
   * @returns {Twilio.Preview.Wireless.SimContext.UsageContext}
   */
  /* jshint ignore:end */
  UsageListInstance.get = function get() {
    return new UsageContext(this._version, this._solution.simSid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Preview.Wireless.SimContext.UsageList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  UsageListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  UsageListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return UsageListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the UsagePage
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Wireless.SimContext.UsagePage
 *
 * @param {Wireless} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {UsageSolution} solution - Path solution
 *
 * @returns UsagePage
 */
/* jshint ignore:end */
UsagePage = function UsagePage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(UsagePage.prototype, Page.prototype);
UsagePage.prototype.constructor = UsagePage;

/* jshint ignore:start */
/**
 * Build an instance of UsageInstance
 *
 * @function getInstance
 * @memberof Twilio.Preview.Wireless.SimContext.UsagePage#
 *
 * @param {UsagePayload} payload - Payload response from the API
 *
 * @returns UsageInstance
 */
/* jshint ignore:end */
UsagePage.prototype.getInstance = function getInstance(payload) {
  return new UsageInstance(this._version, payload, this._solution.simSid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Wireless.SimContext.UsagePage#
 *
 * @returns Object
 */
/* jshint ignore:end */
UsagePage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

UsagePage.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the UsageContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Wireless.SimContext.UsageInstance
 *
 * @property {string} simSid - The sim_sid
 * @property {string} simUniqueName - The sim_unique_name
 * @property {string} accountSid - The account_sid
 * @property {object} period - The period
 * @property {object} commandsUsage - The commands_usage
 * @property {object} commandsCosts - The commands_costs
 * @property {object} dataUsage - The data_usage
 * @property {object} dataCosts - The data_costs
 * @property {string} url - The url
 *
 * @param {Wireless} version - Version of the resource
 * @param {UsagePayload} payload - The instance payload
 * @param {sid} simSid - The sim_sid
 */
/* jshint ignore:end */
UsageInstance = function UsageInstance(version, payload, simSid) {
  this._version = version;

  // Marshaled Properties
  this.simSid = payload.sim_sid; // jshint ignore:line
  this.simUniqueName = payload.sim_unique_name; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.period = payload.period; // jshint ignore:line
  this.commandsUsage = payload.commands_usage; // jshint ignore:line
  this.commandsCosts = payload.commands_costs; // jshint ignore:line
  this.dataUsage = payload.data_usage; // jshint ignore:line
  this.dataCosts = payload.data_costs; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {simSid: simSid, };
};

Object.defineProperty(UsageInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new UsageContext(this._version, this._solution.simSid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a UsageInstance
 *
 * @function fetch
 * @memberof Twilio.Preview.Wireless.SimContext.UsageInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.end] - The end
 * @param {string} [opts.start] - The start
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed UsageInstance
 */
/* jshint ignore:end */
UsageInstance.prototype.fetch = function fetch(opts, callback) {
  return this._proxy.fetch(opts, callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Wireless.SimContext.UsageInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
UsageInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

UsageInstance.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the UsageContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Wireless.SimContext.UsageContext
 *
 * @param {Wireless} version - Version of the resource
 * @param {sid_like} simSid - The sim_sid
 */
/* jshint ignore:end */
UsageContext = function UsageContext(version, simSid) {
  this._version = version;

  // Path Solution
  this._solution = {simSid: simSid, };
  this._uri = `/Sims/${simSid}/Usage`;
};

/* jshint ignore:start */
/**
 * fetch a UsageInstance
 *
 * @function fetch
 * @memberof Twilio.Preview.Wireless.SimContext.UsageContext#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.end] - The end
 * @param {string} [opts.start] - The start
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed UsageInstance
 */
/* jshint ignore:end */
UsageContext.prototype.fetch = function fetch(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({'End': _.get(opts, 'end'), 'Start': _.get(opts, 'start')});

  var promise = this._version.fetch({uri: this._uri, method: 'GET', params: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new UsageInstance(this._version, payload, this._solution.simSid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Wireless.SimContext.UsageContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
UsageContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

UsageContext.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  UsageList: UsageList,
  UsagePage: UsagePage,
  UsageInstance: UsageInstance,
  UsageContext: UsageContext
};
