"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Preview
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DialogueListInstance = exports.DialogueInstance = exports.DialogueContextImpl = void 0;
const util_1 = require("util");
const deserialize = require("../../../../base/deserialize");
const serialize = require("../../../../base/serialize");
const utility_1 = require("../../../../base/utility");
class DialogueContextImpl {
    constructor(_version, assistantSid, sid) {
        this._version = _version;
        if (!(0, utility_1.isValidPathParam)(assistantSid)) {
            throw new Error("Parameter 'assistantSid' is not valid.");
        }
        if (!(0, utility_1.isValidPathParam)(sid)) {
            throw new Error("Parameter 'sid' is not valid.");
        }
        this._solution = { assistantSid, sid };
        this._uri = `/Assistants/${assistantSid}/Dialogues/${sid}`;
    }
    fetch(callback) {
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.fetch({
            uri: instance._uri,
            method: "get",
        });
        operationPromise = operationPromise.then((payload) => new DialogueInstance(operationVersion, payload, instance._solution.assistantSid, instance._solution.sid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.DialogueContextImpl = DialogueContextImpl;
class DialogueInstance {
    constructor(_version, payload, assistantSid, sid) {
        this._version = _version;
        this.accountSid = payload.account_sid;
        this.assistantSid = payload.assistant_sid;
        this.sid = payload.sid;
        this.data = payload.data;
        this.url = payload.url;
        this._solution = { assistantSid, sid: sid || this.sid };
    }
    get _proxy() {
        this._context =
            this._context ||
                new DialogueContextImpl(this._version, this._solution.assistantSid, this._solution.sid);
        return this._context;
    }
    /**
     * Fetch a DialogueInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed DialogueInstance
     */
    fetch(callback) {
        return this._proxy.fetch(callback);
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            accountSid: this.accountSid,
            assistantSid: this.assistantSid,
            sid: this.sid,
            data: this.data,
            url: this.url,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.DialogueInstance = DialogueInstance;
function DialogueListInstance(version, assistantSid) {
    if (!(0, utility_1.isValidPathParam)(assistantSid)) {
        throw new Error("Parameter 'assistantSid' is not valid.");
    }
    const instance = ((sid) => instance.get(sid));
    instance.get = function get(sid) {
        return new DialogueContextImpl(version, assistantSid, sid);
    };
    instance._version = version;
    instance._solution = { assistantSid };
    instance._uri = ``;
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
exports.DialogueListInstance = DialogueListInstance;
