/*
* Copyright (c) 2003-2010 Rony Shapiro <ronys@users.sourceforge.net>.
* All rights reserved. Use of the code is allowed under the
* Artistic License 2.0 terms, as specified in the LICENSE file
* distributed with this code, or available from
* http://www.opensource.org/licenses/artistic-license-2.0.php
*/

#ifndef __XMLFILEHANDLERS_H
#define __XMLFILEHANDLERS_H

// PWS includes
#include "../ItemData.h"
#include "../UUIDGen.h"
#include "../UnknownField.h"
#include "../Command.h"
#include "../Report.h"

// Entry types
enum {NORMAL = 0, ALIAS, SHORTCUT};

// New imported entry
struct pw_entry {
  int id;
  StringX group;
  StringX title;
  StringX username;
  StringX password;
  StringX url;
  StringX autotype;
  StringX ctime;
  StringX atime;
  StringX xtime;
  StringX xtime_interval;
  StringX pmtime;
  StringX rmtime;
  StringX pwhistory;
  StringX notes;
  StringX uuid;
  StringX run_command;
  StringX dca;
  StringX email;
  PWPolicy pwp;
  UnknownFieldList uhrxl;  // Note: use header format for record unknown fields!
  int entrytype;
  bool bforce_normal_entry;
};

struct pwhistory_entry {
  StringX changed;
  StringX oldpassword;
};

typedef std::vector<pw_entry *> vdb_entries;

class PWScore;

class XMLFileHandlers
{
  // to allow access to protected members
#if   USE_XML_LIBRARY == EXPAT
  friend class EFileXMLProcessor;
#elif USE_XML_LIBRARY == MSXML
  friend class MFileXMLProcessor;
#elif USE_XML_LIBRARY == XERCES
  friend class XFileXMLProcessor;
#endif

public:
  XMLFileHandlers();
  virtual ~XMLFileHandlers();

  void SetVariables(PWScore *pcore, const bool &bValidation,
                    const stringT &ImportedPrefix, const TCHAR &delimiter,
                    const bool &bImportPSWDsOnly,
                    UUIDVector *pPossible_Aliases, UUIDVector *pPossible_Shortcuts,
                    MultiCommands *pmulticmds, CReport *prpt);

  bool getIfErrors() {return m_bErrors;}
  int getErrorCode() {return m_iErrorCode;}
  stringT getErrorMessage() {return m_strErrorMessage;}
  stringT getXMLErrors() {return m_strXMLErrors;}
  stringT getSkippedList() {return m_strSkippedList;}
  stringT getPWHErrorList() {return m_strPWHErrorList;}
  stringT getRenameList() {return m_strRenameList;}

  vdb_entries & getVDB_Entries() {return m_ventries;}
  stringT getDefaultAutotypeString() {return m_sDefaultAutotypeString;}
  stringT getDefaultUsername() {return m_sDefaultUsername;}
 
  TCHAR getDelimiter() {return m_delimiter;}
 
  int getNumIterations() {return m_nITER;}
  int getNumEntries() {return m_numEntries;}
  int getNumSkipped() {return m_numEntriesSkipped;}
  int getNumRenamed() {return m_numEntriesRenamed;}
  int getNumPWHErrors() {return m_numEntriesPWHErrors;}
  int getNumRecordsWithUnknownFields() {return m_nRecordsWithUnknownFields;}
 
  bool getDatabaseHeaderErrors() {return m_bDatabaseHeaderErrors;}
  bool getRecordHeaderErrors() {return m_bRecordHeaderErrors;}

protected:
  bool ProcessStartElement(const int icurrent_element);
  void ProcessEndElement(const int icurrent_element);
  void AddEntries();
  void AddDBUnknownFieldsPreferences(UnknownFieldList &uhfl);

  vdb_entries m_ventries;
  pw_entry *cur_entry;
  pwhistory_entry *cur_pwhistory_entry;

  StringX m_strElemContent;
  stringT m_strErrorMessage;
  stringT m_strXMLErrors;
  stringT m_strPWHErrorList;
  stringT m_strRenameList;
  stringT m_strSkippedList;

  int m_nITER;
  int m_numEntries;
  int m_numEntriesSkipped;
  int m_numEntriesRenamed;
  int m_numEntriesPWHErrors;
  int m_nRecordsWithUnknownFields;
  int m_iErrorCode;
  TCHAR m_delimiter;

  bool m_bentrybeingprocessed;
  bool m_bValidation;
  bool m_bErrors, m_bRecordHeaderErrors, m_bDatabaseHeaderErrors;
  bool m_bImportPSWDsOnly;
  unsigned char m_ctype;

  UnknownFieldList m_ukhxl;  // For header unknown fields

private:
  // Local variables
  PWScore *m_pXMLcore;
  UUIDVector *m_pPossible_Aliases;
  UUIDVector *m_pPossible_Shortcuts;
  MultiCommands *m_pmulticmds;
  CReport *m_prpt;

  int m_whichtime, m_ipwh;
  int m_fieldlen;
  bool m_bheader;
  unsigned char * m_pfield;

  // Preferences possibly stored in database
  // Note: boolean is integer to allow an 'not set' value of '-1'
  int prefsinXML[NUMPREFSINXML];
  stringT m_ImportedPrefix;
  stringT m_sDefaultAutotypeString;
  stringT m_sDefaultUsername;
};

#endif /* __XMLFILEHANDLERS_H */
