#include"iplStereo.hpp"
//***********************************************************************************************************************************************************************
//
//		iplStereo on Windows
//
//***********************************************************************************************************************************************************************
//		Static
//***********************************************************************************************************************************************************************
static	FILE *	pOutput		= NULL;

static	bool	bCross		= true;

static	double	fRange		= 10.0;
static	double	fAngle		= DegToRad(0.8);

static	GLuint	uTexture	= 0;

static	void	AppQuit();
static	void	AppDisp();

#ifdef	_WIN32
//***********************************************************************************************************************************************************************
//		_tWinMain()
//			[runs]	for Windows
//			[desc]	EChE̍쐬
//***********************************************************************************************************************************************************************
int __stdcall _tWinMain(HINSTANCE, HINSTANCE, LPTSTR, INT){
	//-----	G[o̓t@Cݒ
	if(NULL == (pOutput = fopen(OUTPUT, "w"))){
		exit(0);
	}
	iplPrint("=== Application on Windows ===\n");

	//-----	I֐`
	atexit(AppQuit);

	//-----	R}hC쐬
	int			cont	= 0;
	LPSTR *		arga	= NULL;
	LPWSTR *	argw	= CommandLineToArgvW(GetCommandLineW(), &cont);
	try{
		arga	= new LPSTR[cont];
		for(int i = 0; i < cont; i++){
			arga[i]	= NULL;
		}
		for(int i = 0, s = 0; i < cont; i++){
			if(0 == (s = WideCharToMultiByte(CP_ACP, 0, argw[i], -1, NULL, 0, NULL, NULL))){
				continue;
			}
			arga[i]	= new char[s + 1];
			if(0 == WideCharToMultiByte(CP_ACP, 0, argw[i], -1, arga[i], s, NULL, NULL)){
				SafeDeleteArray(arga[i]);
				continue;
			}
			arga[i][s]	= '\0';
		}
	}catch(...){
		for(int i = 0, s = 0; i < cont; i++){
			SafeDeleteArray(arga[i]);
		}
		SafeDeleteArray(arga);
		LocalFree(argw);
		exit(0);
	}

	//-----	GLUT (1)
	glutInit(&cont, arga);
	glutInitWindowPosition(0, 0);
	glutInitWindowSize(WINDOW_X, WINDOW_Y);
	glutInitDisplayMode(GLUT_RGBA | GLUT_DOUBLE | GLUT_DEPTH);
	iplPrint("---- > Position (%4d, %4d), Size (%4d, %4d)\n", 0, 0, WINDOW_X, WINDOW_Y);

	//-----	GLUT (2)
	glutCreateWindow("iplStereo");
	glutFullScreen();
	iplPrint("---- > Setup Glut Version 3.7.6 at FullScreen\n");

	//-----	GLUT (3)
	glutIdleFunc(idle);
	glutDisplayFunc(AppDisp);
	glutReshapeFunc(reshape);
	glutMouseFunc(mouse);
	glutKeyboardFunc(keyboard);

	//-----	R}hC
	for(int i = 0, s = 0; i < cont; i++){
		SafeDeleteArray(arga[i]);
	}
	SafeDeleteArray(arga);
	LocalFree(argw);

	mqoInit();

	init();

	//-----	MainLoopJn
	iplPrint("---- > Run glutMainLoop()\n");
	glutMainLoop();

	return (0);
}

#else
//***********************************************************************************************************************************************************************
//		main()
//			[runs]	for Linux
//			[desc]	EChE̍쐬
//***********************************************************************************************************************************************************************
int main(int argc, char *argv[]){
	//-----	G[o̓t@Cݒ
	if(NULL == (pOutput = fopen(OUTPUT, "w"))){
		exit(0);
	}
	iplPrint("=== Application on Linux ===\n");

	//-----	I֐`
	atexit(AppQuit);

	//-----	GLUT (1)
	glutInit(&argc, argv);
	glutInitWindowPosition(0, 0);
	glutInitWindowSize(WINDOW_X, WINDOW_Y);
	glutInitDisplayMode(GLUT_RGBA | GLUT_DOUBLE | GLUT_DEPTH);
	iplPrint("---- > Position (%4d, %4d), Size (%4d, %4d)\n", 0, 0, WINDOW_X, WINDOW_Y);

	//-----	GLUT (2)
	glutCreateWindow("iplStereo");
	glutFullScreen();
	iplPrint("---- > Setup Glut Version 3.7.6 at FullScreen\n");

	//-----	GLUT (3)
	glutIdleFunc(idle);
	glutDisplayFunc(AppDisp);
	glutReshapeFunc(reshape);
	glutMouseFunc(mouse);
	glutKeyboardFunc(keyboard);

	init();

	//-----	MainLoopJn
	iplPrint("---- > Run glutMainLoop()\n");
	glutMainLoop();

	return (0);
}

#endif

//***********************************************************************************************************************************************************************
//		AppQuit()
//			[desc]	EChẺ
//***********************************************************************************************************************************************************************
void AppQuit(){
	quit();

	mqoCleanup();

	iplPrint("---- > End glutMainLoop()\n");
	fclose(pOutput);
}

//***********************************************************************************************************************************************************************
//		AppDisp()
//			[desc]	\
//***********************************************************************************************************************************************************************
void AppDisp(){
	GLint		v	= WINDOW_X >> 1;
	GLdouble	a	= static_cast<double>(WINDOW_X) / static_cast<double>(WINDOW_Y);

	static GLfloat	vLtPosition[4]	= { 0.25f, 1.00f, 0.25f, 0.0f};
	static GLfloat	vLtDiffuse[3]	= { 1.00f, 1.00f, 1.00f };
	static GLfloat	vLtAmbient[3]	= { 0.25f, 0.25f, 0.25f };
	static GLfloat	vLtSpecular[3]	= { 1.00f, 1.00f, 1.00f };

	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	glShadeModel(GL_SMOOTH);
	glLightfv(GL_LIGHT0, GL_POSITION, vLtPosition);
	glLightfv(GL_LIGHT0, GL_DIFFUSE , vLtDiffuse );
	glLightfv(GL_LIGHT0, GL_AMBIENT , vLtAmbient );
	glLightfv(GL_LIGHT0, GL_SPECULAR, vLtSpecular);
	glEnable(GL_DEPTH_TEST);

	glClearDepth(1.0);
	glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	//-----	ڗp
	glViewport(0, 0, v, WINDOW_Y);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(30.0, a, 0.1, 10000.0);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	if(bCross){
		gluLookAt(-fRange * sin(fAngle), 0.0, fRange * cos(fAngle),                   0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
	}else{
		gluLookAt(-fRange * sin(fAngle), 0.0, fRange * cos(fAngle), -fRange * sin(fAngle), 0.0, 0.0, 0.0, 1.0, 0.0);
	}
	display();

	//-----	Eڗp
	glViewport(v, 0, v, WINDOW_Y);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(30.0, a, 0.1, 10000.0);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	if(bCross){
		gluLookAt(+fRange * sin(fAngle), 0.0, fRange * cos(fAngle),                   0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
	}else{
		gluLookAt(+fRange * sin(fAngle), 0.0, fRange * cos(fAngle), +fRange * sin(fAngle), 0.0, 0.0, 0.0, 1.0, 0.0);
	}

	display();

	//-----	ɖ߂
	glViewport(0, 0, WINDOW_X, WINDOW_Y);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(0, WINDOW_X, WINDOW_Y, 0, 0.0, +1.0);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	//-----	\
	glutSwapBuffers();
}

//***********************************************************************************************************************************************************************
//
//		fobOpO\
//
//***********************************************************************************************************************************************************************
//		iplPrint()
//			[desc]	fobOpXe[^X̏
//***********************************************************************************************************************************************************************
void iplPrint(const char *_str, ...){
	va_list	var;
	va_start(var, _str);
	vfprintf(pOutput, _str, var);
	va_end(var);
}

//***********************************************************************************************************************************************************************
//
//		p[^ύX֐
//
//***********************************************************************************************************************************************************************
//		AddRange
//			[desc]	̐ݒ
//***********************************************************************************************************************************************************************
void AddRange(double _r){
	fRange	+= _r;
	if(RANGE_MAX < fRange){
		fRange	= RANGE_MAX;
	}else if(fRange < RANGE_MIN){
		fRange	= RANGE_MIN;
	}
	iplPrint("---- > Range = %7.3f, Angle = %7.3f\n", fRange, RadToDeg(fAngle));
}

//***********************************************************************************************************************************************************************
//		SubRange
//			[desc]	̐ݒ
//***********************************************************************************************************************************************************************
void SubRange(double _r){
	fRange	-= _r;
	if(RANGE_MAX < fRange){
		fRange	= RANGE_MAX;
	}else if(fRange < RANGE_MIN){
		fRange	= RANGE_MIN;
	}
	iplPrint("---- > Range = %7.3f, Angle = %7.3f\n", fRange, RadToDeg(fAngle));
}

//***********************************************************************************************************************************************************************
//		AddAngle
//			[desc]	px̐ݒ
//***********************************************************************************************************************************************************************
void AddAngle(double _r){
	fAngle	+= DegToRad(_r);
	if(DegToRad(ANGLE_MAX) < fAngle){
		fAngle	= DegToRad(ANGLE_MAX);
	}else if(fAngle < DegToRad(ANGLE_MIN)){
		fAngle	= DegToRad(ANGLE_MIN);
	}
	iplPrint("---- > Range = %7.3f, Angle = %7.3f\n", fRange, RadToDeg(fAngle));
}

//***********************************************************************************************************************************************************************
//		SubAngle
//			[desc]	px̐ݒ
//***********************************************************************************************************************************************************************
void SubAngle(double _r){
	fAngle	-= DegToRad(_r);
	if(DegToRad(ANGLE_MAX) < fAngle){
		fAngle	= DegToRad(ANGLE_MAX);
	}else if(fAngle < DegToRad(ANGLE_MIN)){
		fAngle	= DegToRad(ANGLE_MIN);
	}
	iplPrint("---- > Range = %7.3f, Angle = %7.3f\n", fRange, RadToDeg(fAngle));
}

//***********************************************************************************************************************************************************************
//		SetParallel
//			[desc]	s\
//***********************************************************************************************************************************************************************
void SetParallel(){
	bCross	= false;
	iplPrint("---- > SetParallel\n");
}

//***********************************************************************************************************************************************************************
//		SetCrossing
//			[desc]	\
//***********************************************************************************************************************************************************************
void SetCrossing(){
	bCross	= true;
	iplPrint("---- > SetCrossing\n");
}
