#ifndef	_IPL_STEREO_HPP_
#define	_IPL_STEREO_HPP_
#include"iplOption.hpp"
//***********************************************************************************************************************************************************************
//
//		iplStereo (Common Macro)
//
//***********************************************************************************************************************************************************************
#ifndef	SafeDelete
	#define	SafeDelete(p)			{ if(p){ delete    (p); (p) = NULL; } }
#endif
#ifndef	SafeDeleteArray
	#define	SafeDeleteArray(p)		{ if(p){ delete [] (p); (p) = NULL; } }
#endif
#ifndef	DegToRad
	#define	DegToRad(r)				((r) * 0.0174532925199432957692369076849)
#endif
#ifndef	RadToDeg
	#define	RadToDeg(r)				((r) * 57.295779513082320876798154814105)
#endif

#ifdef	_WIN32
//***********************************************************************************************************************************************************************
//
//		iplStereo on Windows
//
//***********************************************************************************************************************************************************************
#pragma	comment(lib, "kernel32.lib")
#pragma	comment(lib, "user32.lib")
#pragma	comment(lib, "gdi32.lib")
#pragma	comment(lib, "winspool.lib")
#pragma	comment(lib, "comdlg32.lib")
#pragma	comment(lib, "advapi32.lib")
#pragma	comment(lib, "shell32.lib")
#pragma	comment(lib, "uuid.lib")
#pragma	comment(lib, "ole32.lib")
#pragma	comment(lib, "oleaut32.lib")
#pragma	comment(lib, "odbc32.lib")
#pragma	comment(lib, "odbccp32.lib")
#pragma	comment(lib, "winmm.lib")

#ifndef	_CRT_SECURE_NO_WARNINGS
	#define	_CRT_SECURE_NO_WARNINGS		(1)
#endif
#include<cmath>
#include<cstdio>
#include<cstdlib>
#include<cstring>
#include<tchar.h>
#include<windows.h>
#include<windowsx.h>
#include<mmsystem.h>

#pragma	warning(disable:4819)
#include"cv/cv.h"
#include"cv/cxcore.h"
#include"cv/highgui.h"
#pragma	warning(default:4819)

#pragma	comment(lib, "cv210.lib")
#pragma	comment(lib, "cxcore210.lib")
#pragma	comment(lib, "highgui210.lib")

#include"gl/glut.h"

#pragma	comment(lib, "glut32.lib")

#else
//***********************************************************************************************************************************************************************
//
//		iplStereo on Linux
//
//***********************************************************************************************************************************************************************
#include<cmath>
#include<cstdio>
#include<cstdlib>
#include<cstring>
#include <stdarg.h>

#include <opencv/cv.h>
#include <opencv/cxcore.h>
#include <opencv/highgui.h>

#include"gl/glut.h"

#endif

//***********************************************************************************************************************************************************************
//
//		f[_
//
//***********************************************************************************************************************************************************************
extern "C" {
	#include"GLMetaseq.h"
};

//***********************************************************************************************************************************************************************
//
//		fobOp֐
//
//***********************************************************************************************************************************************************************
extern	void		iplPrint(const char *, ...);

//***********************************************************************************************************************************************************************
//
//		\p֐
//
//***********************************************************************************************************************************************************************
extern	void		iplColor(double r, double g, double b);

extern	void		iplSphere(double x, double y, double z);
extern	void		iplTeapot(double x, double y, double z, double rx, double ry, double rz);
extern	void		iplCube(double x, double y, double z, double rx, double ry, double rz);
extern	void		iplModel(MQO_MODEL mqo, double x, double y, double z, double rx, double ry, double rz);

extern	void		iplTexture2D(GLuint tex);
extern	GLuint		iplGenTexture(int sz = 1024);

//***********************************************************************************************************************************************************************
//
//		p֐
//
//***********************************************************************************************************************************************************************
extern	void		AddRange(double);
extern	void		SubRange(double);
extern	void		AddAngle(double);
extern	void		SubAngle(double);
extern	void		SetParallel();
extern	void		SetCrossing();

//***********************************************************************************************************************************************************************
//
//		GLUTR[֐
//
//***********************************************************************************************************************************************************************
extern	void		init();
extern	void		quit();

extern	void		idle();
extern	void		display();
extern	void		keyboard(unsigned char, int, int);
extern	void		mouse(int, int, int, int);
extern	void		reshape(int, int);


//***********************************************************************************************************************************************************************
//
//		GLUTR[֐
//
//***********************************************************************************************************************************************************************
extern	int				GetImageSizeW();
extern	int				GetImageSizeH();
extern	unsigned char *	GetImageDataL();
extern	unsigned char *	GetImageDataR();

#endif
