#include"iplStereo.hpp"

//***********************************************************************************************************************************************************************
//		iplColor()
//			[desc]	\FύX
//***********************************************************************************************************************************************************************
void iplColor(double r, double g, double b){
	GLfloat	vDiffuse[3]		= {  0.00f, 0.00f, 0.00f };
	GLfloat	vAmbient[3]		= {  0.15f, 0.15f, 0.15f };
	GLfloat	vSpecular[3]	= {  0.25f, 0.25f, 0.25f };
	GLfloat	vShininess[1]	= { 32.00f };

	vDiffuse[0]	= static_cast<GLfloat>(r);
	vDiffuse[1]	= static_cast<GLfloat>(g);
	vDiffuse[2]	= static_cast<GLfloat>(b);

	glMaterialfv(GL_FRONT, GL_DIFFUSE  , vDiffuse  );
	glMaterialfv(GL_FRONT, GL_AMBIENT  , vAmbient  );
	glMaterialfv(GL_FRONT, GL_SPECULAR , vSpecular );
	glMaterialfv(GL_FRONT, GL_SHININESS, vShininess);
}

//***********************************************************************************************************************************************************************
//		iplSphere()
//			[desc]	̕\
//***********************************************************************************************************************************************************************
void iplSphere(double x, double y, double z){
	glPushMatrix();
	glTranslated(x, y, z);
	glutSolidSphere(0.5, 32, 32);
	glPopMatrix();
}

//***********************************************************************************************************************************************************************
//		iplTeapot()
//			[desc]	eB[|bg\
//***********************************************************************************************************************************************************************
void iplTeapot(double x, double y, double z, double rx, double ry, double rz){
	glPushMatrix();
	glTranslated(x, y, z);
	glRotated(ry, 0, 1, 0);
	glRotated(rx, 1, 0, 0);
	glRotated(rz, 0, 0, 1);
	glutSolidTeapot(0.5);
	glPopMatrix();
}

//***********************************************************************************************************************************************************************
//		iplCube()
//			[desc]	̕\
//***********************************************************************************************************************************************************************
void iplCube(double x, double y, double z, double rx, double ry, double rz){
	glPushMatrix();
	glTranslated(x, y, z);
	glRotated(ry, 0, 1, 0);
	glRotated(rx, 1, 0, 0);
	glRotated(rz, 0, 0, 1);
	glutSolidCube(0.5);
	glPopMatrix();
}

//***********************************************************************************************************************************************************************
//		iplModel()
//			[desc]	f\
//***********************************************************************************************************************************************************************
void iplModel(MQO_MODEL mqo, double x, double y, double z, double rx, double ry, double rz){
	glPushMatrix();
	glTranslated(x, y, z);
	glRotated(ry, 0, 1, 0);
	glRotated(rx, 1, 0, 0);
	glRotated(rz, 0, 0, 1);
	mqoCallModel(mqo);
	glPopMatrix();
}

//***********************************************************************************************************************************************************************
//		iplTexture2D()
//			[desc]	eNX``
//***********************************************************************************************************************************************************************
void iplTexture2D(GLuint tex){
	double	matProj[16];
	double	matView[16];

	glGetDoublev(GL_PROJECTION_MATRIX, matProj);
	glGetDoublev(GL_MODELVIEW_MATRIX,  matView);

	glDisable(GL_DEPTH_TEST);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluOrtho2D(-1, +1, +1, -1);

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	glBindTexture(GL_TEXTURE_2D, tex);
	glEnable(GL_TEXTURE_2D);
	glBegin(GL_QUADS);
		glTexCoord2d(0.0, 1.0);	glVertex3d(-1.0, +1.0, 0.0);
		glTexCoord2d(0.0, 0.0);	glVertex3d(-1.0, -1.0, 0.0);
		glTexCoord2d(1.0, 0.0);	glVertex3d(+1.0, -1.0, 0.0);
		glTexCoord2d(1.0, 1.0);	glVertex3d(+1.0, +1.0, 0.0);
	glEnd();
	glDisable(GL_TEXTURE_2D);
	
	glPopMatrix();

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glMultMatrixd(matProj);

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glMultMatrixd(matView);

	glEnable(GL_DEPTH_TEST);


}

//***********************************************************************************************************************************************************************
//		iplGenTexture()
//			[desc]	eNX`쐬
//***********************************************************************************************************************************************************************
GLuint iplGenTexture(int sz){
	GLuint	uTexture;

	glPixelStorei(GL_PACK_ALIGNMENT, 4);
	glGenTextures(1, &uTexture);
    glBindTexture(GL_TEXTURE_2D, uTexture);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
    glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);

	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, sz, sz, 0, GL_BGR_EXT, GL_UNSIGNED_BYTE, NULL);

	return uTexture;
}

//***********************************************************************************************************************************************************************
//		GetImageSizeW()
//			[desc]	obNobt@(Њp)TCY
//***********************************************************************************************************************************************************************
int GetImageSizeW(){
	return WINDOW_X >> 1;
}

//***********************************************************************************************************************************************************************
//		GetImageSizeH()
//			[desc]	obNobt@(Њp)TCY
//***********************************************************************************************************************************************************************
int GetImageSizeH(){
	return WINDOW_Y;
}

//***********************************************************************************************************************************************************************
//		GetImageDataL()
//			[desc]	obNobt@(p)f[^擾
//***********************************************************************************************************************************************************************
unsigned char * GetImageDataL(){
	static	unsigned char	_image[3 * WINDOW_Y * (WINDOW_X >> 1)]	= { 0 };
	glReadBuffer(GL_BACK);
	glReadPixels(0, 0, WINDOW_X >> 1, WINDOW_Y, GL_BGR_EXT, GL_UNSIGNED_BYTE, _image);
	return _image;
}

//***********************************************************************************************************************************************************************
//		GetImageDataR()
//			[desc]	obNobt@(Ep)f[^擾
//***********************************************************************************************************************************************************************
unsigned char * GetImageDataR(){
	static	unsigned char	_image[3 * WINDOW_Y * (WINDOW_X >> 1)]	= { 0 };
	glReadBuffer(GL_BACK);
	glReadPixels(WINDOW_X >> 1, 0, WINDOW_X >> 1, WINDOW_Y, GL_BGR_EXT, GL_UNSIGNED_BYTE, _image);
	return _image;
}