#include"iplStereo.hpp"

static	double		fViewAngle	= 0.0;

static	GLuint		uTexture;
static	MQO_MODEL	mqomodel;

//***********************************************************************************************************************************************************************
//
//		init ֐
//
//***********************************************************************************************************************************************************************
void init(){
	//-----	wi() -----//
	uTexture	= iplGenTexture(1024);

	IplImage *	img	= cvLoadImage("img/samp1.jpg");
	IplImage *	mat	= cvCreateImage(cvSize(1024, 1024), IPL_DEPTH_8U, 3);

	cvResize(img, mat, CV_INTER_CUBIC);

	glBindTexture(GL_TEXTURE_2D, uTexture);
	glTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, mat->width, mat->height, GL_BGR_EXT, GL_UNSIGNED_BYTE, mat->imageData);

	cvReleaseImage(&img);
	cvReleaseImage(&mat);
	//-----	wi() -----//


	//-----	f() -----//
	mqomodel	= mqoCreateModel("IMG\\object2.mqo", 0.01);
	//-----	f() -----//

}

//***********************************************************************************************************************************************************************
//
//		qnit ֐
//
//***********************************************************************************************************************************************************************
void quit(){

	mqoDeleteModel(mqomodel);

	glDeleteTextures(1, &uTexture);
}

//***********************************************************************************************************************************************************************
//
//		idle ֐
//
//***********************************************************************************************************************************************************************
void idle(){

	glutPostRedisplay();
}

//***********************************************************************************************************************************************************************
//
//		display ֐
//			(glClear, glutSwapBuffers ͎IɎs܂)
//
//***********************************************************************************************************************************************************************
void display(){
	iplTexture2D(uTexture);

	glRotated(fViewAngle, 1.0, 0.0, 0.0);
	
	mqoCallModel(mqomodel);

	iplColor(1.0, 0.0, 0.0);	//-----	
	iplSphere(0.0, 0.0, 0.0);

//	iplColor(1.0, 1.0, 0.0);	//-----	
//	iplCube(0.0, 0.0, 1.0, 0.0, 0.0, 0.0);

//	iplColor(1.0, 0.0, 1.0);	//-----	
//	iplTeapot(0.0, 0.0, -1.0, 90.0, 0.0, 0.0);

//	iplColor(0.0, 1.0, 0.0);	//-----	
//	iplSphere(1.0, 0.0, 0.0);

	glFlush();
}

//***********************************************************************************************************************************************************************
//
//		keyboard ֐
//
//***********************************************************************************************************************************************************************
void keyboard(unsigned char key, int x, int y){
	switch(key){
		case (0x1B):
		case 'q':
		case 'Q':
			exit(0);
			break;
		case 'W':
			AddAngle(1.00);
			break;
		case 'w':
			AddAngle(0.05);
			break;
		case 'N':
			SubAngle(1.00);
			break;
		case 'n':
			SubAngle(0.05);
			break;
		case 'p':
		case 'P':
			SetParallel();
			break;
		case 'c':
		case 'C':
			SetCrossing();
			break;
		case 'z':
		case 'Z':
			fViewAngle	= 0;
			break;
		case 'u':
			if(fViewAngle + 0.05 > +90){
				fViewAngle	= +90;
			}else{
				fViewAngle	+= 0.05;
			}
			break;
		case 'U':
			if(fViewAngle + 1.00 > +90){
				fViewAngle	= +90;
			}else{
				fViewAngle	+= 1.00;
			}
			break;
		case 'd':
			if(fViewAngle - 0.05 < -90){
				fViewAngle	= -90;
			}else{
				fViewAngle	-= 0.05;
			}
			break;
		case 'D':
			if(fViewAngle - 1.00 < -90){
				fViewAngle	= -90;
			}else{
				fViewAngle	-= 1.00;
			}
			break;
		default:
			break;
	}
}

//***********************************************************************************************************************************************************************
//
//		mouse ֐
//
//***********************************************************************************************************************************************************************
void mouse(int button, int state, int x, int y){
}

//***********************************************************************************************************************************************************************
//
//		reshape ֐
//
//***********************************************************************************************************************************************************************
void reshape(int x, int y){
}
