////////////////////////////////////////////////////////////////////////////////
// sudokuki - C++ graphical sudoku game                                       //
// Copyright (C) 2007-2009 Sylvain Vedrenne                                   //
//                                                                            //
// This program is free software; you can redistribute it and/or              //
// modify it under the terms of the GNU General Public License                //
// as published by the Free Software Foundation; either version 2             //
// of the License, or (at your option) any later version.                     //
//                                                                            //
// This program is distributed in the hope that it will be useful,            //
// but WITHOUT ANY WARRANTY; without even the implied warranty of             //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              //
// GNU General Public License for more details.                               //
//                                                                            //
// You should have received a copy of the GNU General Public License along    //
// with this program; if not, write to the Free Software Foundation, Inc.,    //
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.              //
////////////////////////////////////////////////////////////////////////////////
#ifndef UI_STRING_H_
#define UI_STRING_H_
static const char *ui_info =
    "<ui>"
    "  <menubar name='MenuBar'>"
    "    <menu action='GameMenu'>"
    "      <menuitem action='New'/>"
    "      <menuitem action='Print'/>"
    "      <separator/>"
    "      <menuitem action='Open'/>"
    "      <menuitem action='SaveAs'/>"
    "      <separator/>"
    "      <menuitem action='Quit'/>"
    "    </menu>"
    "    <menu action='EditMenu'>"
    "      <menuitem action='Undo'/>"
    "      <menuitem action='Clear'/>"
    "      <separator/>"
    "      <menuitem action='SetupCustomGrid'/>"
    "      <menuitem action='PlayCustomGrid'/>"
    "      <separator/>"
    "      <menuitem action='ResolveCell'/>"
    "      <menuitem action='Resolve'/>"
    "      <separator/>"
    "      <menu action='Preferences'>"
	"        <menu action='LevelMenu'>"
    "	       <menuitem action='Level_1'/>"
    "	       <menuitem action='Level_2'/>"
    "	       <menuitem action='Level_3'/>"
    "	       <menuitem action='Level_4'/>"
    "	       <menuitem action='Level_5'/>"
	"        </menu>"
    "        <menu action='LanguageMenu'>"
    "	       <menuitem action='de'/>"
    "	       <menuitem action='el'/>"
    "	       <menuitem action='en'/>"
    "	       <menuitem action='eo'/>"
    "	       <menuitem action='es'/>"
    "	       <menuitem action='fr'/>"
    "	       <menuitem action='ja'/>"
    "        </menu>"
    "        <menu action='KanjiNumbersMenu'>"
    "	       <menuitem action='Numbers'/>"
    "	       <menuitem action='Kanji'/>"
    "        </menu>"
	"        <menuitem action='PrintSettings'/>"
	"      </menu>"
    "    </menu>"
    "    <menu action='HelpMenu'>"
    "      <menuitem action='About'/>"
    "    </menu>"
    "  </menubar>"
    "  <toolbar name='Toolbar'>"
    "    <toolitem action='New'/>"
    "    <toolitem action='Open'/>"
    "    <toolitem action='SaveAs'/>"
	"    <placeholder name='ToolbarCustomGridButton'/>"
	//    "    <toolitem action='ResolveCell'/>"
    "    <toolitem action='Resolve'/>"
    "    <toolitem action='Quit'/>"
    "  </toolbar>"
    "  <popup name='PopupMenu'>"
    "    <menuitem action='Escape'/>"
    "    <separator/>"
    "    <menuitem action='TryValue_1'/>"
    "    <menuitem action='Unavailable_1'/>"
    "    <menuitem action='TryValue_2'/>"
    "    <menuitem action='Unavailable_2'/>"
    "    <menuitem action='TryValue_3'/>"
    "    <menuitem action='Unavailable_3'/>"
    "    <menuitem action='TryValue_4'/>"
    "    <menuitem action='Unavailable_4'/>"
    "    <menuitem action='TryValue_5'/>"
    "    <menuitem action='Unavailable_5'/>"
    "    <menuitem action='TryValue_6'/>"
    "    <menuitem action='Unavailable_6'/>"
    "    <menuitem action='TryValue_7'/>"
    "    <menuitem action='Unavailable_7'/>"
    "    <menuitem action='TryValue_8'/>"
    "    <menuitem action='Unavailable_8'/>"
    "    <menuitem action='TryValue_9'/>"
    "    <menuitem action='Unavailable_9'/>"
    "    <separator/>"
    "    <menuitem action='ResolveCell'/>"
    "  </popup>"
	"</ui>";

static const char *ui_setup_custom_grid =
    "<ui>"
    "  <toolbar name='Toolbar'>"
	"    <placeholder name='ToolbarCustomGridButton'>"
    "      <toolitem action='SetupCustomGrid'/>"
	"    </placeholder>"
    "  </toolbar>"
	"</ui>";

static const char *ui_play_custom_grid =
    "<ui>"
    "  <toolbar name='Toolbar'>"
	"    <placeholder name='ToolbarCustomGridButton'>"
    "        <toolitem action='PlayCustomGrid'/>"
	"    </placeholder>"
    "  </toolbar>"
	"</ui>";

#endif /*UI_STRING_H_*/
