////////////////////////////////////////////////////////////////////////////////
// sudokuki - C++ graphical sudoku game                                       //
// Copyright (C) 2007-2009 Sylvain Vedrenne                                   //
//                                                                            //
// This program is free software; you can redistribute it and/or              //
// modify it under the terms of the GNU General Public License                //
// as published by the Free Software Foundation; either version 2             //
// of the License, or (at your option) any later version.                     //
//                                                                            //
// This program is distributed in the hope that it will be useful,            //
// but WITHOUT ANY WARRANTY; without even the implied warranty of             //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              //
// GNU General Public License for more details.                               //
//                                                                            //
// You should have received a copy of the GNU General Public License along    //
// with this program; if not, write to the Free Software Foundation, Inc.,    //
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.              //
////////////////////////////////////////////////////////////////////////////////
#ifndef SUDOKUKIMMWINDOW_H_
#define SUDOKUKIMMWINDOW_H_

#include <gtkmm.h> // For the moment. Replace it by several includes when ready

#include "sudokukimm.h"

/* use this to activate all traces in all files */
#define ALL_TRACES 0

class Sudokukimm;

class SudokukimmWindow : public Gtk::Window
{
public:
	SudokukimmWindow( Sudokukimm* psudokukimm );
	virtual ~SudokukimmWindow();

protected:
    void on_cell_resolve();
	void on_game_new();
	void on_game_open();
	void on_game_save();
	void on_game_save_as();
	void on_game_resolve();
	void on_game_quit();
	void on_game_print_generated_grid_in_browser();
	void on_edit_undo();
	void on_edit_copy();
	void on_edit_paste();
	void on_edit_clear();
	void on_edit_setup_custom_grid();
	void on_edit_play_custom_grid();
	void on_edit_print_settings();
	void on_edit_language( std::string );
	void on_edit_level( int level );
	void on_edit_kanjimode( int mode );
	void on_edit_preferences();
	void on_help_about();

	int m_last_cell_with_focus_index;
	bool on_cell_focus_out(GdkEventFocus* event, int li, int co);
	bool on_cell_focus_in(GdkEventFocus* event, int li, int co);
	void on_cell_filled(int li, int co);
	bool on_cell_clicked(GdkEventButton* ev, int li, int co);
	bool on_key_pressed(GdkEventKey* ev);
	void game_complete_end_game();
	void show_dead_end_dialog();
	void on_try_value_in_cell( int val );

private:
	guint m_custom_grid_merge_id;

	Pango::FontDescription* m_pother_font;
	Pango::FontDescription* m_pbold_font;
	Pango::FontDescription* m_pbold_big_font;

	bool m_edit_custom_grid_in_progress; // custom grid is being filled at the moment

	bool discard_grid_confirm_dialog( bool discard );

	sigc::signal<void> signal_reinit_window;

	std::string m_lang;
	bool m_inhibit_edit;
	bool m_deactivate_language_selection;

	static std::string sudokuki_version;

	Gtk::VBox* m_pmainvbox;
	Gtk::MenuBar* m_pmenubar;
	Gtk::Toolbar* m_ptoolbar;
    Gtk::Menu* m_ppopup_menu;
	Gtk::EventBox* m_peventbox;
	Gtk::AspectFrame* m_paspectframe;
	Gtk::VBox* m_pvbx;
	Gtk::Table* m_pbigtable;
	Gdk::Color m_black_5;
	Gdk::Color m_grey_90;
	Gtk::Statusbar* m_pstatusbar;
	Glib::RefPtr<Gtk::ActionGroup> m_rpag;
	std::vector<Glib::RefPtr<Gtk::Action> > m_actions;
	Glib::RefPtr<Gtk::UIManager> m_rpuimgr;
	void add_actions();
	Glib::RefPtr<Gtk::Action> m_gameMenuActionList[32];
	void add_language_selector();
	Gtk::Entry* m_pentries[89];

	bool m_react_when_cell_filled;
	bool m_pop_up_menu_displayed;

	Gtk::MessageDialog* m_pconfirm_on_game_new_dialog;

	void gui_init_grid( bool italic );
	void install_menu_hints(const Glib::RefPtr<Gtk::Action>& action, Gtk::Widget* widget);
	void resolve_cell_action_enable( bool );
	void resolve_cell_action_update();

	static Glib::RefPtr<Gdk::Pixbuf> m_picon;
	static Glib::RefPtr<Gdk::Pixbuf> get_icon();
	static Glib::RefPtr<Gdk::Pixbuf> m_plogo;
	static Glib::RefPtr<Gdk::Pixbuf> get_logo();


	bool m_dead_end;
	bool m_game_resolved;
	short int m_focus_idx;

	static Glib::ustring symbols[];
	int m_kanji_mode;
	int m_level;
	static std::map<char, int> values;
	Sudokukimm* m_psudokukimm;
};

#endif /*SUDOKUKIMMWINDOW_H_*/
