////////////////////////////////////////////////////////////////////////////////
// sudokuki - C++ graphical sudoku game                                       //
// Copyright (C) 2007-2009 Sylvain Vedrenne                                   //
//                                                                            //
// This program is free software; you can redistribute it and/or              //
// modify it under the terms of the GNU General Public License                //
// as published by the Free Software Foundation; either version 2             //
// of the License, or (at your option) any later version.                     //
//                                                                            //
// This program is distributed in the hope that it will be useful,            //
// but WITHOUT ANY WARRANTY; without even the implied warranty of             //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              //
// GNU General Public License for more details.                               //
//                                                                            //
// You should have received a copy of the GNU General Public License along    //
// with this program; if not, write to the Free Software Foundation, Inc.,    //
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.              //
////////////////////////////////////////////////////////////////////////////////
#ifndef SUDOKUKIMM_H_
#define SUDOKUKIMM_H_

#include <gtkmm.h> // For the moment. Replace it by several includes when ready

#include "SudokukimmWindow.h"

#include "../solver/solver.hh"
#include "../solver/player.hh"

/* use this to activate all traces in all files */
#define ALL_TRACES 0

class SudokukimmWindow;

class Sudokukimm
{
public:

	void set_window_position( int x, int y );
	int get_window_x_pos();
	int get_window_y_pos();

	std::string	get_locale();
	bool get_kanji_mode();
	int get_level();
	bool get_grid_resolved();
	bool get_dead_end_state();

	void set_locale( std::string next_locale );
	void set_kanji_mode( int next_kanji_mode );
	void set_level( int next_level );
	void set_grid_resolved( bool next_is_resolved );
	void set_dead_end_state( bool dead_end_state );


	void solver_init();
	void reset_generated_grid();
	void reset_generated_grid( std::string );

	void reinit_window();

	Sudokukimm(std::string locale);
	void run();
	virtual ~Sudokukimm();

	bool player_is_value_possible(int li, int co, int val);
	int solver_get_cell_value(int li, int co);
	int player_get_cell_value(int li, int co);
	int player_set_cell_value(int li, int co, char ch);

	void player_reset();
	void player_reset( std::string );

	unsigned int solver_get_how_many_numbers();
	unsigned int player_get_how_many_numbers();

	void go_back_one_grid();

	void player_fill_additional_moves( std::string game_with_moves );

protected:

private:

	int m_window_x_pos;
	int m_window_y_pos;

	std::string m_locale;
	int m_kanji_mode;
	int m_level;
	bool m_grid_resolved;
	bool m_dead_end_state;
	int m_rating_limit_lower;
	int m_rating_limit_higher;
	void set_rating_limits();

	bool m_running;

	SudokukimmWindow* m_psudokukimm_window;

	static std::string sudokuki_version;
	int* m_argc;
	char*** m_argv;

	solver* m_psolver;
	player* m_pplayer;
	std::string m_grid_string;
	char m_generated_grid[82];

	void remove_spaces( std::string* );
	void generate_grid( std::string& );

	static std::string symbol;
	static std::map<char, int> values;

public:
	int get_current_player_grid_index() { return m_pplayer->get_current_grid_index(); }
	std::map<int, int> get_current_player_values() { return m_pplayer->get_current_grid_values(); }
	std::string get_current_player_values_string() { return m_pplayer->get_current_grid_values_string(); }
	std::string get_generated_grid() { return std::string(m_generated_grid); }
	std::map<int, int> get_solution_values() { return m_psolver->get_current_grid_values(); }

};

#endif /*SUDOKUKIMM_H_*/
