////////////////////////////////////////////////////////////////////////////////
// sudokuki - C++ graphical sudoku game                                       //
// Copyright (C) 2007-2009 Sylvain Vedrenne                                   //
//                                                                            //
// This program is free software; you can redistribute it and/or              //
// modify it under the terms of the GNU General Public License                //
// as published by the Free Software Foundation; either version 2             //
// of the License, or (at your option) any later version.                     //
//                                                                            //
// This program is distributed in the hope that it will be useful,            //
// but WITHOUT ANY WARRANTY; without even the implied warranty of             //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              //
// GNU General Public License for more details.                               //
//                                                                            //
// You should have received a copy of the GNU General Public License along    //
// with this program; if not, write to the Free Software Foundation, Inc.,    //
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.              //
////////////////////////////////////////////////////////////////////////////////
#include "tst_grid.hh"
//#include <iomanip>
#include <iostream>
#include "tst_traces.h"

#define DBGM_TRACES 0
#include "../dbgm_traces.h"

using namespace std;

int
tst_grid::dump( void )
{
	for (int li=0; li<nb_lines; li++) {
		for (int co=0; co<nb_lines; co++) {
			for (int flag=0; flag<nb_flags; flag++) {

				short tmp_val = *(m_pgrid->m_pstart
								// jump over li lines and co columns of cells
								+ nb_flags*(nb_cols*li + co) + flag);

				if ( short(VAL::UNUSED) == tmp_val ) {
					DBGM("X");
				} else if ( short(VAL::EMPTY) == tmp_val ) {
					DBGM("-");
				} else if ( 0 == tmp_val ) {
					DBGM(".");
				} else {
					DBGF("%d", tmp_val);
				}
			}
			DBGM(" ");
		}
		DBGM("\n");
	}
	DBGM("\n");
	return 0;
}
