#ifndef __ANTHY_H__
#define __ANTHY_H__

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

typedef enum {
	ANTHY_MEISHI_KANKUZYOSHI_SETUZOKU = 1 << 0,
	ANTHY_MEISHI_GOKANNOMIDE_BUNSETU = 1 << 1,
	ANTHY_MEISHI_SURU_SETUZOKU = 1 << 2,
	ANTHY_MEISHI_SA_SETUZOKU = 1 << 3,
	ANTHY_MEISHI_NA_SETUZOKU = 1 << 4
} touroku_meishi_attr_list;

typedef enum {
	ANTHY_FUKUSHI_GOKANNOMIDE_BUNSETU = 1 << 0,
	ANTHY_FUKUSHI_SURU_SETUZOKU = 1 << 1,
	ANTHY_FUKUSHI_TARU_SETUZOKU = 1 << 2,
	ANTHY_FUKUSHI_TO_SETUZOKU = 1 << 3
} touroku_fukushi_attr_list;

typedef struct _anthylist {
	char *yomi;
	char *kanji;
	char *code;
	int freq;
	struct _anthylist *next;
} anthylist;

typedef struct _category_code {
	char *code;
	char *description;
	int flag;
} category_code;

int init_anthydic_lib(void);
void read_anthy_priv_dic_list(anthylist **head, int *num);
void free_anthy_priv_dic_list(anthylist *head);
char *find_meishi_code_from_flag(const int flag);
char *find_fukushi_code_from_flag(const int flag);
char *find_hinshi_name_from_code(const char *code);
int add_anthy_priv_dic_with_flags(char *yomi, char *freq, char *kanji, char *hinshi);
int delete_anthy_priv_dic(char *yomi, char *kanji, char *code);
#endif /* __ANTHY_H__ */
