/*
 *  anthyviewwordpane.c
 *  Copyright(C) 2003- Masahito Omote <omote@utyuuzin.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#include <stdlib.h>

#include "anthyviewwordpane.h"
#include "wordlist_view.h"

#include "charset.h"
#include "anthy.h"
#include "intl.h"

/* callbacks */
static void cb_anthy_bt_update(GtkButton *button, AnthyViewWordPane *pane);
static void cb_anthy_bt_delete(GtkButton *button, AnthyViewWordPane *pane);
static void cb_anthy_bt_edit(GtkButton *button, AnthyViewWordPane *pane);

static void cb_anthy_bt_update(GtkButton *button, AnthyViewWordPane *pane) {
    int num, i;
    anthylist *list, *pos;

    read_anthy_priv_dic_list(&list, &num);

    wordlist_view_clear(WORDLIST_VIEW(pane->wordlist_anthy));
/* TODO: these code should be treated in wordlist_view.c */
    for(pos = list; pos != NULL; pos = pos->next) {
	WordlistData *data;
	data = g_new0(WordlistData, 1);
	if(data != NULL) {
	    data->yomi = eucjp_to_utf8(pos->yomi);
	    data->kanji = eucjp_to_utf8(pos->kanji);
	    data->code = eucjp_to_utf8(pos->code);
	    data->freq = pos->freq;
	    data->okuri = FALSE;
	    data->hinshi = eucjp_to_utf8(find_hinshi_name_from_code(pos->code));

	    if(data->yomi != NULL && data->kanji != NULL &&
	       data->code != NULL) {

		wordlist_view_set_values(WORDLIST_VIEW(pane->wordlist_anthy),
					 data);

		g_free(data->yomi);
		g_free(data->kanji);
		g_free(data->code);
		g_free(data->hinshi);
	    }
	    g_free(data);
	}
    }
    free_anthy_priv_dic_list(list);
    gtk_button_set_label(button, _("Reload"));

    for(i = 1;i < 3; i++)
	gtk_widget_set_sensitive(pane->bt_dicfunc[i], TRUE);
}

static void cb_anthy_bt_delete(GtkButton *button, AnthyViewWordPane *pane) {
    gchar *yomi, *kanji, *code;
    GtkWidget *dialog;
    GList *selected_data;
    WordlistData *wordlistdata;

    selected_data = wordlist_view_get_selected_data_list(WORDLIST_VIEW(pane->wordlist_anthy));
    if(selected_data == NULL)
	return;
/* TODO: Must handle multiple selection */
    wordlistdata = selected_data->data;
    yomi = g_strdup(wordlistdata->yomi);
    kanji = g_strdup(wordlistdata->kanji);
    code = g_strdup(wordlistdata->code);

    g_print("Yomi: %s, Kanji: %s, Code: %s\n", yomi, kanji, code);
    delete_anthy_priv_dic(utf8_to_eucjp(yomi),
			  utf8_to_eucjp(kanji),
			  utf8_to_eucjp(code));
/* End of TODO */
    dialog = gtk_message_dialog_new(NULL,
				    GTK_DIALOG_MODAL, GTK_MESSAGE_INFO,
				    GTK_BUTTONS_CLOSE,
				    _("Sorry, not implemented. Just deleting from list"));
    gtk_dialog_run(GTK_DIALOG(dialog));
    gtk_widget_destroy(dialog);

    wordlist_view_remove_selected_data(WORDLIST_VIEW(pane->wordlist_anthy));

    if(yomi != NULL)
	g_free(yomi);
    if(kanji != NULL)
	g_free(kanji);
    if(code != NULL)
	g_free(code);
    if(wordlistdata)
	g_free(wordlistdata);
    g_list_free(selected_data);
}

static void cb_anthy_bt_edit(GtkButton *button, AnthyViewWordPane *pane) {
    GtkWidget *dialog;
    GtkWidget *topwindow;
    topwindow = gtk_widget_get_parent(gtk_widget_get_parent(gtk_widget_get_parent(pane->pane)));

    dialog = gtk_message_dialog_new(GTK_WINDOW(topwindow),
				    GTK_DIALOG_MODAL, GTK_MESSAGE_INFO,
				    GTK_BUTTONS_CLOSE,
				    _("Sorry, not implemented."));
    gtk_dialog_run(GTK_DIALOG(dialog));
    gtk_widget_destroy(dialog);
}

int create_viewwordpane(AnthyViewWordPane *pane) {
    GtkWidget *label;
    GtkWidget *hbox1, *hbox2;
    GtkWidget *vbox1, *vbox2;
    GtkWidget *wordlist;

    gchar *commands[] = { N_("Load"), N_("Edit"), N_("Delete") };
    void *cb_commands[] = { cb_anthy_bt_update,
			    cb_anthy_bt_edit,
			    cb_anthy_bt_delete };
    gint num_commands = 3;

    int i;

    pane->pane = gtk_hbox_new(FALSE, 15);
    gtk_container_set_border_width(GTK_CONTAINER(pane->pane), 15);

    vbox1 = gtk_vbox_new(FALSE, 0);
    gtk_widget_show(vbox1);
    gtk_box_pack_start(GTK_BOX(pane->pane), vbox1, TRUE, TRUE, 0);

    hbox2 = gtk_hbox_new(FALSE, 10);
    gtk_box_pack_start(GTK_BOX(vbox1), hbox2, FALSE, FALSE, 0);
    gtk_widget_show(hbox2);

    /* in hbox */
    wordlist = wordlist_view_new_with_attributes("editable", FALSE,
						 "freq_show", TRUE,
						 NULL);
    gtk_box_pack_start(GTK_BOX(vbox1), wordlist, TRUE, TRUE, 10);
    gtk_widget_show(wordlist);
    pane->wordlist_anthy = wordlist;

    vbox2 = gtk_vbutton_box_new();
    gtk_button_box_set_layout(GTK_BUTTON_BOX(vbox2), GTK_BUTTONBOX_START);
    gtk_box_set_spacing(GTK_BOX(vbox2), 10);
    gtk_box_pack_start(GTK_BOX(pane->pane), vbox2, FALSE, FALSE, 10);
    gtk_widget_show(vbox2);

    /* in vbox2 */
    for(i = 0; i < num_commands; i++) {
	pane->bt_dicfunc[i] = gtk_button_new_with_label(_(commands[i]));
	gtk_box_pack_start(GTK_BOX(vbox2), pane->bt_dicfunc[i], FALSE, FALSE, 5);
	gtk_widget_set_sensitive(pane->bt_dicfunc[i], FALSE);
	g_signal_connect(G_OBJECT(pane->bt_dicfunc[i]), "clicked",
			 G_CALLBACK(cb_commands[i]), pane);
	gtk_widget_show(pane->bt_dicfunc[i]);
    }
    gtk_widget_set_sensitive(pane->bt_dicfunc[0],TRUE);

    /* in hbox2 */
    label = gtk_label_new_with_mnemonic(_("Search:"));
    gtk_box_pack_start(GTK_BOX(hbox2), label, FALSE, FALSE, 5);
    gtk_widget_show(label);

    pane->searchword = gtk_entry_new();
    gtk_box_pack_start(GTK_BOX(hbox2), pane->searchword, FALSE, FALSE, 5);
    gtk_widget_show(pane->searchword);

    return 0;
}
