#include <gtk/gtk.h>

#include "skkcontainer.h"
#include "charset.h"
#include "wordlist_view.h"

#include "skk.h"
#include "intl.h"

/* callbacks */
static void cb_skk_bt_update(GtkButton *button, SKKContainer *container);
static void cb_skk_bt_delete(GtkButton *button, SKKContainer *container);
static void cb_skk_bt_save(GtkButton *button, SKKContainer *container);
static void cb_skk_bt_edit(GtkButton *button, SKKContainer *container);

void cb_skk_bt_update(GtkButton *button, SKKContainer *container) {
    skklist *list, *pos;
    int num = 0;
    int i, ret;
    gboolean okuri;

    wordlist_view_clear(WORDLIST_VIEW(container->wordlist_skk));

    /* TODO: Implement Progressbar Window */
    ret = read_skk_dic(&list, &num);

    if(ret == -1) {
	GtkWidget *dialog;
	dialog = gtk_message_dialog_new(NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
					_("Cannot open $HOME/.skk-jisho."));
	gtk_dialog_run(GTK_DIALOG(dialog));
	gtk_widget_destroy(dialog);
	return;
    }

    g_object_freeze_notify(G_OBJECT(container->wordlist_skk));
    for(pos = list; pos != NULL; pos = pos->next) {
	WordlistData *data;
	data = g_new0(WordlistData, 1);
	if(data != NULL) {
	    if(pos->okuri == 0) {
		okuri = TRUE;
	    }
	    else {
		okuri = FALSE;
	    }

/* TODO: these code should be treated in wordlist_view.c */ 
	    data->yomi = eucjp_to_utf8(pos->yomi);
	    data->kanji = eucjp_to_utf8(pos->kanji);
	    data->okuri = okuri;
	    /* These 3 entries are no longer needed, so input dummy datas */
	    data->hinshi = NULL;
	    data->code = NULL;
	    data->freq = 0;

	    if(data->yomi != NULL && data->kanji != NULL) {
		wordlist_view_set_values(WORDLIST_VIEW(container->wordlist_skk),
				       data);

		g_free(data->yomi);
		g_free(data->kanji);
	    }
	    g_free(data);
	}
    }
    free_skk_dic(list);
    g_object_thaw_notify(G_OBJECT(container->wordlist_skk));

    gtk_button_set_label(button, _("Reload"));
    for(i = 1;i < 4; i++) {
	gtk_widget_set_sensitive(container->bt_dicfunc[i], TRUE);
    }
}

void cb_skk_bt_edit(GtkButton *button, SKKContainer *container) {
/*
	GtkTreeView *treeview = GTK_TREE_VIEW(container->tv_skkwordlist);
	GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
	GtkTreeModel *model = gtk_tree_view_get_model(treeview);
	GtkTreeIter iter;
	gchar *yomi, *kanji;

	if(!gtk_tree_selection_get_selected(selection, &model, &iter))
		return;
	gtk_tree_model_get(model, &iter, SKK_YOMI_COLUMN, &yomi, SKK_KANJI_COLUMN, &kanji, -1);
	g_print("Yomi: %s, Kanjj: %s\n", yomi, kanji);
*/
}

void cb_skk_bt_delete(GtkButton *button, SKKContainer *container) {
    wordlist_view_remove_selected_data(WORDLIST_VIEW(container->wordlist_skk));
}

void cb_skk_bt_save(GtkButton *button, SKKContainer *container) {
    GList *list, *pos;
    WordlistData *wordlistdata;
    skklist *skklist = NULL, *entry = NULL;
    int ret;

    list = wordlist_view_get_all_data_list(WORDLIST_VIEW(container->wordlist_skk));

    for(pos = g_list_first(list); pos != NULL; pos = g_list_next(pos)) {
	wordlistdata = pos->data;

	if(wordlistdata) {
	    if(wordlistdata->okuri == TRUE) {
		entry = skk_dic_list_new(utf8_to_eucjp(wordlistdata->yomi),
					 utf8_to_eucjp(wordlistdata->kanji),
					 0);
	    } else {
		entry = skk_dic_list_new(utf8_to_eucjp(wordlistdata->yomi),
					 utf8_to_eucjp(wordlistdata->kanji),
					 1);
	    }
	}
	skklist = skk_dic_list_append(skklist, entry);
    }

    ret = write_skk_dic(skklist);
    free_skk_dic(skklist);
}

void create_skkcontainer(SKKContainer *container) {
    GtkWidget *wordlist;
    GtkWidget *vbox, *hbox;

    gchar *commands[] = { N_("Load"),
			  N_("Edit"),
			  N_("Delete"),
			  N_("Save") };
    void *cb_commands[] = { cb_skk_bt_update,
			    cb_skk_bt_edit,
			    cb_skk_bt_delete,
			    cb_skk_bt_save };

    int i;

    container->container = gtk_vbox_new(FALSE, 10);
    gtk_container_set_border_width(GTK_CONTAINER(container->container), 10);
    
    hbox = gtk_hbox_new(FALSE, 10);
    gtk_widget_show(hbox);
    gtk_box_pack_start(GTK_BOX(container->container), hbox, TRUE, TRUE, 5);
    
    wordlist = wordlist_view_new_with_attributes("editable", TRUE,
						 "code_show", FALSE,
						 "hinshi_show", FALSE,
						 "freq_show", FALSE,
						 "selection_mode", GTK_SELECTION_MULTIPLE,
						 NULL);
    gtk_widget_show(wordlist);
    gtk_box_pack_start(GTK_BOX(hbox), wordlist, TRUE, TRUE, 10);
    container->wordlist_skk = wordlist;
    
    vbox = gtk_vbutton_box_new();
    gtk_button_box_set_layout(GTK_BUTTON_BOX(vbox), GTK_BUTTONBOX_START);
    gtk_box_set_spacing(GTK_BOX(vbox), 10);
    gtk_widget_show(vbox);
    gtk_box_pack_start(GTK_BOX(hbox), vbox, FALSE, FALSE, 30);

    for(i = 0; i < 4; i++) {
	container->bt_dicfunc[i] = gtk_button_new_with_label(_(commands[i]));
	g_signal_connect(G_OBJECT(container->bt_dicfunc[i]), "clicked",
			 G_CALLBACK(cb_commands[i]), container);
	gtk_box_pack_start(GTK_BOX(vbox), container->bt_dicfunc[i], FALSE, FALSE, 5);
	gtk_widget_show(container->bt_dicfunc[i]);
	gtk_widget_set_sensitive(container->bt_dicfunc[i], FALSE);
    }
    gtk_widget_set_sensitive(container->bt_dicfunc[0],TRUE);
	
}

void show_skkcontainer(SKKContainer *container, gboolean flags) {
    if(flags) {
	gtk_widget_show(container->container);
    }
}

void clean_skkcontainer(SKKContainer *container) {
    return;
}
