/*
 *  anthy.c
 *  Copyright(C) 2003- Masahito Omote <omote@utyuuzin.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  This code is based on Anthy's code.
 */

#include <dlfcn.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "anthy.h"

/* #include "intl.h" */

static category_code meishi_code[]= {
    { "#T00", "", 31 },
//	{ "#T01", "", 31 },
    { "#T02", "", 30 },
//	{ "#T03", "", 29 },
    { "#T04", "", 28 },
    { "#T05", "", 27 },
//	{ "#T06", "", 27 },
    { "#T07", "", 26 },
//	{ "#T08", "", 25 },
    { "#T09", "", 24 },
    { "#T10", "", 23 },
//	{ "#T11", "", 23 },
    { "#T12", "", 22 },
//	{ "#T13", "", 21 },
    { "#T14", "", 20 },
    { "#T15", "", 19 },
//	{ "#T16", "", 19 },
    { "#T17", "", 18 },
//	{ "#T18", "", 17 },
    { "#T19", "", 16 },
    { "#T20", "", 15 },
//	{ "#T21", "", 15 },
    { "#T22", "", 14 },
//	{ "#T23", "", 13 },
    { "#T24", "", 12 },
    { "#T25", "", 11 },
//	{ "#T26", "", 11 },
    { "#T27", "", 10 },
//	{ "#T28", "", 9 },
    { "#T29", "", 8 },
    { "#T30", "", 7 },
//	{ "#T31", "", 7 },
    { "#T32", "", 6 },
//	{ "#T33", "", 5 },
    { "#T34", "", 4 },
    { "#T35", "", 3 },
//	{ "#T36", "", 3 },
    { "#T37", "", 2 },
//	{ "#T38", "", 1 },
    { "#T39", "", 0 }
};

static category_code fukushi_code[] = {
    { "#F00", "", 15 },
    { "#F01", "", 14 },
    { "#F02", "", 13 },
    { "#F03", "", 12 },
    { "#F04", "", 11 },
    { "#F05", "", 10 },
    { "#F06", "", 9 },
    { "#F07", "", 8 },
    { "#F08", "", 7 },
    { "#F09", "", 6 },
    { "#F10", "", 5 },
    { "#F11", "", 4 },
    { "#F12", "", 3 },
    { "#F13", "", 2 },
    { "#F14", "", 1 },
    { "#F15", "", 0 }
};

struct _anthy_dic_api {
    void (*util_init)();
    void (*util_set_personality)(char *);
    const char *(*util_get_anthydir)(void);

    void (*priv_dic_delete)(void);
    int (*priv_dic_select_first_entry)(void);
    int (*priv_dic_select_next_entry)(void);
    int (*priv_dic_select_entry)(char *);

    char *(*priv_dic_get_index)(char *, int);
    int (*priv_dic_get_freq)(void);
    char *(*priv_dic_get_wtype)(char *, int);
    char *(*priv_dic_get_word)(char *, int);

    int (*priv_dic_add_entry)(char *, char *, char *, int);
};
static struct _anthy_dic_api anthy_dic_api;
static void *anthy_dic_lib;

static int get_anthydic_api() {
    anthy_dic_lib = dlopen("libanthydic.so.0", RTLD_GLOBAL |RTLD_NOW);
    if(anthy_dic_lib == NULL) {
	return -1;
    }

    anthy_dic_api.util_init = dlsym(anthy_dic_lib, "anthy_dic_util_init");
    anthy_dic_api.util_set_personality = dlsym(anthy_dic_lib, "anthy_dic_util_set_personality");
    anthy_dic_api.util_get_anthydir = dlsym(anthy_dic_lib, "anthy_dic_util_get_anthydir");

    anthy_dic_api.priv_dic_delete = dlsym(anthy_dic_lib, "anthy_priv_dic_delete");
    anthy_dic_api.priv_dic_select_first_entry = dlsym(anthy_dic_lib, "anthy_priv_dic_select_first_entry");
    anthy_dic_api.priv_dic_select_next_entry = dlsym(anthy_dic_lib, "anthy_priv_dic_select_next_entry");
    anthy_dic_api.priv_dic_select_entry = dlsym(anthy_dic_lib, "anthy_priv_dic_select_entry");

    anthy_dic_api.priv_dic_get_index = dlsym(anthy_dic_lib, "anthy_priv_dic_get_index");
    anthy_dic_api.priv_dic_get_freq = dlsym(anthy_dic_lib, "anthy_priv_dic_get_freq");
    anthy_dic_api.priv_dic_get_wtype = dlsym(anthy_dic_lib, "anthy_priv_dic_get_wtype");
    anthy_dic_api.priv_dic_get_word = dlsym(anthy_dic_lib, "anthy_priv_dic_get_word");

    anthy_dic_api.priv_dic_add_entry = dlsym(anthy_dic_lib, "anthy_priv_dic_add_entry");

    if(!anthy_dic_api.util_init && !anthy_dic_api.util_set_personality
       && !anthy_dic_api.util_get_anthydir && !anthy_dic_api.priv_dic_delete
       && !anthy_dic_api.priv_dic_select_first_entry
       && !anthy_dic_api.priv_dic_select_next_entry
       && !anthy_dic_api.priv_dic_select_entry
       && !anthy_dic_api.priv_dic_get_index
       && !anthy_dic_api.priv_dic_get_freq
       && !anthy_dic_api.priv_dic_get_wtype
       && !anthy_dic_api.priv_dic_get_word
       && !anthy_dic_api.priv_dic_add_entry) {
	dlclose(anthy_dic_lib);
	return -1;
    }
    return 0;
}

int anthydic_init(void) {
    if(get_anthydic_api() == -1)
	return -1;
    anthy_dic_api.util_init();
    return 0;
}

int anthydic_close(void) {
    if(anthy_dic_lib)
	return dlclose(anthy_dic_lib);
    else
	return -1;
}

int read_anthy_priv_dic_list(word **head) {
    char phon[100], desc[100], cclass_code[100];
    int ret = 0;

    if(anthy_dic_api.priv_dic_select_first_entry() == -1) {
	*head = NULL;
	return -1;
    }

    while(ret == 0) {
	if(anthy_dic_api.priv_dic_get_index(phon, 100)
	   && anthy_dic_api.priv_dic_get_wtype(cclass_code, 100)
	   && anthy_dic_api.priv_dic_get_word(desc, 100)) {

	    word_append(head, WORD_TYPE_ANTHY,
			phon, desc, cclass_code, 
			anthy_dic_api.priv_dic_get_freq(),
			0, NULL);
	}
	ret = anthy_dic_api.priv_dic_select_next_entry();
    }
    return 0;
}

char *find_meishi_code_from_flag(const int flag) {
    int meishi_code_num = sizeof(meishi_code) / sizeof(meishi_code[0]);
    int i;
    char *code = NULL;

    for(i = 0; i < meishi_code_num; i++) {
	if(flag == meishi_code[i].flag) {
	    code = strdup(meishi_code[i].code);
	    break;
	}
    }

    return code;
}

char *find_fukushi_code_from_flag(const int flag) {
    int fukushi_code_num = sizeof(fukushi_code) / sizeof(fukushi_code[0]);
    int i;
    char *code = NULL;

    for(i = 0; i < fukushi_code_num; i++) {
	if(flag == fukushi_code[i].flag) {
	    code = strdup(fukushi_code[i].code);
	    break;
	}
    }
    return code;
}

char *find_hinshi_name_from_code(const char *code) {
    char *hinshi = NULL;
/* Need to be more smart */
    if(strncmp(code, "#JNM", 4) == 0) {
	hinshi = strdup("\xbf\xcd\xcc\xbe"); /* Zinmei */
	return hinshi;
    } else if(strncmp(code, "#CN", 3) == 0) {
	hinshi = strdup("\xc3\xcf\xcc\xbe"); /* Chimei */
	return hinshi;
    }

    switch(code[1]) {
    case 'T':
	hinshi = strdup("\xcc\xbe\xbb\xec"); /* Meishi */
	break;
    case 'F':
	hinshi = strdup("\xc9\xfb\xbb\xec"); /* Fukushi */
	break;
    case 'K':
	hinshi = strdup("\xb7\xc1\xcd\xc6\xbb\xec"); /* Keiyoushi */
	break;
    default:
	hinshi = strdup("\xc6\xb0\xbb\xec"); /* Doushi */
	break;
    }
    return hinshi;
}

int add_anthy_priv_dic_with_flags(char *phon, char *desc,
				  char *cclass_code, int freq)
{
    if((strlen(phon) == 0) ||
       (strlen(desc) == 0) ||
       (strlen(cclass_code) == 0)) {
	return -1;
    }

    return anthy_dic_api.priv_dic_add_entry(phon, desc,
					    cclass_code, freq);
}

int delete_anthy_priv_dic(char *phon, char *desc, char *cclass_code) {
/*
	char idx[100], wt[100], w[100];
	int ret = 0;

	dic_api.priv_dic_select_first_entry();
	while(ret == 0) {
		if(dic_api.priv_dic_get_index(idx, 100)
			&& dic_api.priv_dic_get_wtype(wt, 100)
			&& dic_api.priv_dic_get_word(w, 100)) {
			if(!strncmp(idx, yomi, strlen(idx))
				&& !strncmp(w, kanji, strlen(w))
				&& !strncmp(wt, code, strlen(wt))) {
				dic_api.priv_dic_delete();
				ret = 1;
				break;
			}
		}
		ret = dic_api.priv_dic_select_next_entry();
	}

	return ret;
*/
    return 0;
}
