/*
 *  canna.h
 *  Copyright(C) 2003- Masahito Omote <omote@utyuuzin.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  This code is based on canna's code. For more information about canna,
 *  visit http://canna.sourceforge.jp/ . Canna license is as follows,
 *
 * Copyright (c) 2002 Canna Project. All rights reserved.
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice
 * appear in supporting documentation, and that the name of the
 * author and contributors not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission.  The author and contributors no representations
 * about the suitability of this software for any purpose.  It is
 * provided "as is" without express or implied warranty.
 *
 * THE AUTHOR AND CONTRIBUTORS DISCLAIMS ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE AUTHOR AND CONTRIBUTORS BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Copyright 1994 NEC Corporation, Tokyo, Japan.
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice
 * appear in supporting documentation, and that the name of NEC
 * Corporation not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.	NEC Corporation makes no representations about the
 * suitability of this software for any purpose.  It is provided "as
 * is" without express or implied warranty.
 *
 * NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#include "word.h"

typedef struct {
    int ylen;		/* yomigana no nagasa (in byte) */
    int klen;		/* kanji no nagasa (in byte) */
    int rownum;		/* row number */
    int colnum;		/* column number */
    int dicnum;		/* dic number */
} RkLex;

typedef struct {
    int bunnum;		/* bunsetsu bangou */
    int candnum;	/* kouho bangou */
    int maxcand;	/* sou kouho suu */
    int diccand;	/* jisho ni aru kouho suu */
    int ylen;		/* yomigana no nagasa (in byte) */
    int klen;		/* kanji no nagasa (in byte) */
    int tlen;		/* tango no kosuu */
} RkStat;

struct DicInfo {
    unsigned char	*di_dic;
    unsigned char	*di_file;
    int			di_kind;
    int			di_form;
    unsigned		di_count;
    int			di_mode;
    long		di_time;
};

struct _canna_api {
    int	  (*GetProtocolVersion)(int *, int *);
    char *(*GetServerName)    (void);
    int	  (*GetServerVersion) (int *, int *);
    int	  (*Initialize)	      (char *);
    void  (*Finalize)	      (void);
    int	  (*CreateContext)    (void);
    int	  (*DuplicateContext) (int);
    int	  (*CloseContext)     (int);
    int	  (*SetDicPath)	      (int, char *);
    int	  (*CreateDic)	      (int, unsigned char *, int);
    int	  (*SyncDic)	      (int, char *);
    int	  (*GetDicList)	      (int, char *, int);
    int	  (*GetMountList)     (int, char *, int);
    int	  (*MountDic)	      (int, char *, int);
    int	  (*RemountDic)	      (int, char *, int);
    int	  (*UnmountDic)	      (int, char *);
    int	  (*DefineDic)	      (int, char *, char *);
    int	  (*DeleteDic)	      (int, char *, char *);
    int	  (*GetHinshi)	      (int, unsigned char *, int);
    int	  (*GetKanji)	      (int, unsigned char *, int);
    int	  (*GetYomi)	      (int, unsigned char *, int);
    int	  (*GetLex)	      (int, RkLex *, int);
    int	  (*GetStat)	      (int, RkStat *);
    int	  (*GetKanjiList)     (int, unsigned char *, int);
    int	  (*FlushYomi)	      (int);
    int	  (*GetLastYomi)      (int, char *, int);
    int	  (*RemoveBun)	      (int, int);
    int	  (*SubstYomi)	      (int, int, int, char *, int);
    int	  (*BgnBun)	      (int, char *, int, int);
    int	  (*EndBun)	      (int, int);
    int	  (*GoTo)	      (int, int);
    int	  (*Left)	      (int);
    int	  (*Right)	      (int);
    int	  (*Next)	      (int);
    int	  (*Prev)	      (int);
    int	  (*Nfer)	      (int);
    int	  (*Xfer)	      (int, int);
    int	  (*Resize)	      (int, int);
    int	  (*Enlarge)	      (int);
    int	  (*Shorten)	      (int);
    int	  (*StoreYomi)	      (int, char *, int);
    int	  (*SetAppName)	      (int, char *);
    int	  (*SetUserInfo)      (char *, char *, char *);
    int	  (*QueryDic)	      (int, char *, char *, struct DicInfo *);
    int	  (*CopyDic)	      (int, char *, char *, char *, int);
    int	  (*ListDic)	      (int, char *, char *, int);
    int	  (*RemoveDic)	      (int, char *, int);
    int	  (*RenameDic)	      (int, char *, char *, int);
    int	  (*ChmodDic)	      (int, char *, int);
    int	  (*GetWordTextDic)   (int, unsigned char *, unsigned char *,
			       unsigned char *, int);
    int	  (*GetSimpleKanji)   (int, char *, unsigned char *, int,
			       unsigned char *, int, char *, int);
};

/* prototypes */
int   canna_init   (char *);
void  canna_close  (void);

int   canna_get_word_text_dic	   (unsigned char *, unsigned char *, word **);
word *canna_get_word_text_priv_dic (void);
int   canna_define_dic	           (unsigned char *, unsigned char *);
int   canna_delete_dic	           (unsigned char *, unsigned char *);
