/*
 *  $Id: uimconfig.h 9 2004-02-06 06:24:52Z omote $
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __UIM_CONFIG_H__
#define __UIM_CONFIG_H__

struct _uim_config_global {
    char *default_im;
    char *cand_win_pos;
    int   enable_im_switch;
};

struct _uim_config_anthy {
    int  dummy;
};

struct _uim_config_canna {
    char *cannaserver;
};

struct _uim_config_prime {
    int  dummy;
};

struct _uim_config_skk {
    char *skk_style;
    char *skk_dic_filename;
    char *skk_userdic_filename;
    char *skk_uim_userdic_filename;
    int   recursive_learning;
};

struct _uim_config {
    struct _uim_config_global global;
    struct _uim_config_anthy  anthy;
    struct _uim_config_canna  canna;
    struct _uim_config_prime  prime;
    struct _uim_config_skk    skk;
};

int init_uim_config  (struct _uim_config *);
int write_uim_config (struct _uim_config *);
#endif /* __UIM_CONFIG_H__ */
