/*
  +----------------------------------------------------------------------+
  | Author: yoya@awm.jp                                                  |
  +----------------------------------------------------------------------+
*/

#include <stdio.h>
#include <string.h>
#include "bitstream.h"
#include "swf_tag_sound.h"
#include "swf_object.h"

swf_tag_detail_handler_t sound_detail_handler;

swf_tag_detail_handler_t *
swf_tag_sound_detail_handler(void) {
    sound_detail_handler.create   = swf_tag_sound_create_detail;
    sound_detail_handler.identity = swf_tag_sound_identity_detail;
    sound_detail_handler.output   = swf_tag_sound_output_detail;
    sound_detail_handler.print    = swf_tag_sound_print_detail;
    sound_detail_handler.destroy  = swf_tag_sound_destroy_detail;
    return &sound_detail_handler;
}

void *
swf_tag_sound_create_detail(unsigned char *data, unsigned long length,
                           swf_tag_t *tag,
                           struct swf_object_ *swf) {
    swf_tag_sound_detail_t *swf_tag_sound;
    bitstream_t *bs;
    unsigned long sound_data_len;
    unsigned char *sound_data;
    (void) tag;
    (void) swf;
    swf_tag_sound = calloc(sizeof(*swf_tag_sound), 1);
    if (swf_tag_sound == NULL) {
        fprintf(stderr, "ERROR: swf_tag_sound_create_detail: can't calloc\n");
        return NULL;
    }
    bs = bitstream_open();
    bitstream_input(bs, data, length);
    swf_tag_sound->sound_id = bitstream_getbytesLE(bs, 2);
    swf_tag_sound->sound_format    = bitstream_getbits(bs, 4);
    swf_tag_sound->sound_rate      = bitstream_getbits(bs, 2);
    swf_tag_sound->sound_is_16bits = bitstream_getbit(bs);
    swf_tag_sound->sound_is_stereo = bitstream_getbit(bs);
    swf_tag_sound->sound_samples_count = bitstream_getbytesLE(bs, 4);
    sound_data_len = bitstream_length(bs) - bitstream_getbytepos(bs);
    swf_tag_sound->sound_data = malloc(sound_data_len);
    if (swf_tag_sound->sound_data == NULL) {
        fprintf(stderr, "swf_tag_sound_create_detail: swf_tag_sound->sound_data == NULL at line(%d): sound_data_len=%lu\n",
                __LINE__, sound_data_len);
        bitstream_close(bs);
        return NULL;
    }
    sound_data = bitstream_buffer(bs, bitstream_getbytepos(bs));
    memcpy(swf_tag_sound->sound_data, sound_data, sound_data_len);
    swf_tag_sound->sound_data_len = sound_data_len;
    bitstream_close(bs);
    return (void *) swf_tag_sound;
}

int
swf_tag_sound_identity_detail(unsigned char *data, int id, swf_tag_t *tag) {
    int sound_id;
    if (tag->detail) {
        swf_tag_sound_detail_t *swf_tag_sound = (swf_tag_sound_detail_t *) tag->detail;        
        if (swf_tag_sound->sound_id == id) {
            return 0;
        }        
        return 1;
    }
    if (data == NULL) {
        fprintf(stderr, "swf_tag_sound_identity_detail: data==NULL\n");
        return 1;
    }
    sound_id = GetUShortLE(data);
    if (id == sound_id) {
        return 0;
    }        
    return 1;
}

unsigned char *
swf_tag_sound_output_detail(void *detail, unsigned long *length,
                           swf_tag_t *tag,
                           struct swf_object_ *swf) {
    swf_tag_sound_detail_t *swf_tag_sound = (swf_tag_sound_detail_t *) detail;
    bitstream_t *bs;
    unsigned char *data;
    (void) tag;
    (void) swf;
    *length = 0;
    bs = bitstream_open();
    bitstream_putbytesLE(bs, swf_tag_sound->sound_id, 2);
    bitstream_putbits(bs, swf_tag_sound->sound_format, 4);
    bitstream_putbits(bs, swf_tag_sound->sound_rate, 2);
    bitstream_putbit(bs, swf_tag_sound->sound_is_16bits);
    bitstream_putbit(bs, swf_tag_sound->sound_is_stereo);
    bitstream_putbytesLE(bs, swf_tag_sound->sound_samples_count, 4);
    bitstream_putstring(bs, swf_tag_sound->sound_data,
                        swf_tag_sound->sound_data_len);
    data = bitstream_steal(bs, length);
    bitstream_close(bs);
    return data;
}

void
swf_tag_sound_print_detail(void *detail,
                          swf_tag_t *tag,
                          struct swf_object_ *swf) {
    swf_tag_sound_detail_t *swf_tag_sound = (swf_tag_sound_detail_t *) detail;
    char *format_name = "Unknown";
    (void) tag;
    (void) swf;
    switch(swf_tag_sound->sound_format) {
    case 0:
        format_name = "Raw";
        break;
    case 1:
        format_name = "ADPCM";
        break;
    case 2:
        format_name = "MP3";
        break;
    case 3:
        format_name = "Uncompressed";
        break;
    case 6:
        format_name = "Nellymoser";
        break;
        
    }
    printf("\tsound_id=%d\n", swf_tag_sound->sound_id);
    
    printf("\tformat=%u(%s) rate=%u is_16bits=%u is_stereo=%u samples_count=%lu\n",
           swf_tag_sound->sound_format, format_name,
           swf_tag_sound->sound_rate,
           swf_tag_sound->sound_is_16bits?1:0,
           swf_tag_sound->sound_is_stereo?1:0,
           swf_tag_sound->sound_samples_count);
    printf("\tsound_data(length=%lu)\n",
           swf_tag_sound->sound_data_len);
    return ;
}

void
swf_tag_sound_destroy_detail(void *detail) {
    swf_tag_sound_detail_t *swf_tag_sound = (swf_tag_sound_detail_t *) detail;
    free(swf_tag_sound->sound_data);
    free(swf_tag_sound);
    return ;
}


char *
swf_tag_sound_get_data(void *detail, int sound_id) {
    (void) detail;
    (void) sound_id;
    // dummy
    return NULL;
}
int
swf_tag_sound_replace_data(void *detail, int sound_id,
                           unsigned char *data,
                           unsigned long data_len) {
    (void) detail;
    (void) sound_id;
    (void) data;
    (void) data_len;
        // dummy
    return -1;
}
