package jp.ac.do_johodai.j314.sw.lms;

import java.util.*;
import org.w3c.dom.*;
import javax.xml.*;
import javax.xml.xpath.*;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

class Util {
    public static Document loadXML(String xml_url) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            //dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document d = db.parse(xml_url);
            return d;
        } catch(Exception e) {
            return null;
        }
    }

    //最初，namespaceもちゃんと認識するようにしようとしたけど，
    //SCORM1.2でもSCORM2004でも動くようにするのと，SCORM2004に限っても
    //xsiのネームスペースを扱わないようにした．
    //一応ネームスペース対応のプログラムも残してあるので
    //コメントを外せば使える．その場合
    //以下のメソッドに与えるqueryでデフォルトネームスペースを
    //使う場合には「:manifest」のように書かないといけない。

    //xpathでNodeを抽出するためのメソッド．
    //必ずNodeのセットが帰るようなqueryを引数に与えなければならない．
    static Node[] xpath(String query,Document doc) {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            //xpath.setNamespaceContext(new MyNamespaceContext());
            XPathExpression expr = xpath.compile(query);
            NodeList nl = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);

            org.w3c.dom.Node ret[] = new org.w3c.dom.Node[nl.getLength()];
            for (int i=0;i<nl.getLength();i++) {
                ret[i] = nl.item(i);
            }
            return ret;
        } catch (XPathExpressionException e) {
            return null;
        }
    }
    //xpathで数(int)を出力させるためのメソッド．
    //必ず数が帰るようなqueryを引数に与えなければならない．
    static double xpath_num(String query,Document doc) {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            //xpath.setNamespaceContext(new MyNamespaceContext());
            XPathExpression expr = xpath.compile(query);
            return ((Double)expr.evaluate(doc, XPathConstants.NUMBER)).doubleValue();
        } catch (XPathExpressionException e) {
            return Double.NaN;
        }
    }
    //xpathで真偽値(boolean)を出力させるためのメソッド．
    //必ず真偽値が帰るようなqueryを引数に与えなければならない．
    static boolean xpath_bool(String query,Document doc) {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            //xpath.setNamespaceContext(new MyNamespaceContext());
            XPathExpression expr = xpath.compile(query);
            return ((Boolean)expr.evaluate(doc, XPathConstants.BOOLEAN)).booleanValue();
        } catch (XPathExpressionException e) {
            //??? gaha ???
            return false;
        }
    }

    //xpathで文字列(String)を出力させるためのメソッド．
    //必ず文字列が帰るようなqueryを引数に与えなければならない．
    static String xpath_str(String query,Document doc) {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            //xpath.setNamespaceContext(new MyNamespaceContext());
            XPathExpression expr = xpath.compile(query);
            return ((String)expr.evaluate(doc, XPathConstants.STRING));
        } catch (XPathExpressionException e) {
            return null;
        }
    }
    //xpathで文字列(String)を出力させるためのメソッド．
    //どんなqueryでも文字列で値を返す．
    static String xpath_str2(String query,Document doc) {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            //xpath.setNamespaceContext(new MyNamespaceContext());
            XPathExpression expr = xpath.compile(query);
            return expr.evaluate(doc);
        } catch (XPathExpressionException e) {
            return null;
        }
    }
}

//xpathで使用するネームスペースのプレフィックスを特定するためのクラス
//http://www-06.ibm.com/jp/developerworks/java/060906/j_x-javaxpathapi.shtml
//http://java.sun.com/javase/ja/6/docs/ja/api/javax/xml/namespace/NamespaceContext.html
class MyNamespaceContext implements NamespaceContext {
    public String getNamespaceURI(String prefix) {
//System.out.println("prefix:'"+prefix+"'");
        if (prefix == null) throw new IllegalArgumentException("Null prefix");
        else if (prefix.equals("")) return "http://www.imsproject.org/xsd/ims_cp_rootv1p1";
        else if (prefix.equals("adlcp")) return "http://www.adlnet.org/xsd/adl_cp_rootv1p1";
        else if (prefix.equals("xsi")) return "http://www.w3.org/2001/XMLSchema-instance";
        else if (prefix.equals("imsss")) return "http://www.imsproject.org/xsd/ims_cp_rootv1p1";
        else if (prefix.equals("xml")) return XMLConstants.XML_NS_URI;
        else if (prefix.equals("xmlns")) return XMLConstants.XMLNS_ATTRIBUTE_NS_URI;
        return XMLConstants.NULL_NS_URI;
    }

    public String getPrefix(String uri) {
        throw new UnsupportedOperationException();
    }
    public Iterator getPrefixes(String uri) {
        throw new UnsupportedOperationException();
    }
}
