//=====================================================================
// bxPawn in Bouyadakarasa version 2.0.0
//
//							Auther: strangelove
//
// Special Thanks: UnrealWiki, unrealscript ML, MOD Developer ML
//=====================================================================

class bxPawn extends xPawn;


/* BotDodge()
returns appropriate vector for dodge in direction Dir (which should be normalized)
*/
/*
function vector BotDodge(Vector Dir)
{
  local vector Vel;

  Vel = DodgeSpeedFactor*GroundSpeed*Dir;
  Vel.Z = DodgeSpeedZ;
  return Vel;
}
*/

function bool Dodge(eDoubleClickDir DoubleClickMove)
{
  local vector X,Y,Z, TraceStart, TraceEnd;
  local float VelocityZ;
  local name Anim;

  if ( bIsCrouched || bWantsToCrouch || (Physics != PHYS_Walking && Physics != PHYS_Falling) )
    return false;

  GetAxes(Rotation,X,Y,Z);

  if ( Physics == PHYS_Falling ) {	//󒆂łhbW\
    if (DoubleClickMove == DCLICK_Forward) {
      Velocity = DodgeSpeedFactor*GroundSpeed*X + (Velocity Dot Y)*Y;
      TraceEnd = -X;
    } else if (DoubleClickMove == DCLICK_Back) {
      Velocity = -DodgeSpeedFactor*GroundSpeed*X + (Velocity Dot Y)*Y;
      TraceEnd = X;
    } else if (DoubleClickMove == DCLICK_Left) {
      Velocity = -DodgeSpeedFactor*GroundSpeed*Y + (Velocity Dot X)*X;
      TraceEnd = Y;
    }  else if (DoubleClickMove == DCLICK_Right) {
      Velocity = DodgeSpeedFactor*GroundSpeed*Y + (Velocity Dot X)*X;
      TraceEnd = -Y;
    }
    Velocity.Z = VelocityZ + DodgeSpeedZ;
    CurrentDir = DoubleClickMove;
    SetPhysics(PHYS_Falling);
    PlayOwnedSound(GetSound(EST_Dodge), SLOT_Pain, GruntVolume,,80);

    TraceStart = Location - CollisionHeight*Vect(0,0,1) + TraceEnd*CollisionRadius;
    TraceEnd = TraceStart + TraceEnd*32.0;
    if (FastTrace(TraceEnd, TraceStart)) {
      return false;
    } else {
      if (DoubleClickMove == DCLICK_Forward)
        Anim = WallDodgeAnims[0];
      else if (DoubleClickMove == DCLICK_Back)
        Anim = WallDodgeAnims[1];
      else if (DoubleClickMove == DCLICK_Left)
        Anim = WallDodgeAnims[2];
      else if (DoubleClickMove == DCLICK_Right)
        Anim = WallDodgeAnims[3];

      if ( PlayAnim(Anim, 1.0, 0.1) )
        bWaitForAnim = true;
      AnimAction = Anim;

      if (Velocity.Z < -DodgeSpeedZ*0.5)
        Velocity.Z += DodgeSpeedZ*0.5;
    }
//      return true;
  }

  VelocityZ = Velocity.Z;

  if (DoubleClickMove == DCLICK_Forward)
    Velocity = DodgeSpeedFactor*GroundSpeed*X + (Velocity Dot Y)*Y;
  else if (DoubleClickMove == DCLICK_Back)
    Velocity = -DodgeSpeedFactor*GroundSpeed*X + (Velocity Dot Y)*Y;
  else if (DoubleClickMove == DCLICK_Left)
    Velocity = -DodgeSpeedFactor*GroundSpeed*Y + (Velocity Dot X)*X;
  else if (DoubleClickMove == DCLICK_Right)
    Velocity = DodgeSpeedFactor*GroundSpeed*Y + (Velocity Dot X)*X;

  Velocity.Z = VelocityZ + DodgeSpeedZ;
  CurrentDir = DoubleClickMove;
  SetPhysics(PHYS_Falling);
  PlayOwnedSound(GetSound(EST_Dodge), SLOT_Pain, GruntVolume,,80);
  return false;	//hbW\
}

/*
function DoDoubleJump( bool bUpdating )
{
  PlayDoubleJump();

  if ( !bIsCrouched && !bWantsToCrouch )
    {
//      if ( !IsLocallyControlled() )
//        MultiJumpRemaining -= 1;
        Velocity.Z = JumpZ + MultiJumpBoost;
      SetPhysics(PHYS_Falling);
      if ( !bUpdating )
        PlayOwnedSound(GetSound(EST_DoubleJump), SLOT_Pain, GruntVolume,,80);
    }
}
*/
/*
function bool CanDoubleJump()
{
  return ( (MultiJumpRemaining > 0) && (Physics == PHYS_Falling) );
}
*/

function bool DoJump( bool bUpdating )
{
  // This extra jump allows a jumping or dodging pawn to jump again mid-air
  // (via thrusters). The pawn must be within +/- 100 velocity units of the
  // apex of the jump to do this special move.
  MultiJumpRemaining = 2147483647;
  if ( !bUpdating && CanDoubleJump() && IsLocallyControlled())
    {
      if ( PlayerController(Controller) != None )
        PlayerController(Controller).bDoubleJump = true;
      DoDoubleJump(bUpdating);
      //MultiJumpRemaining -= 1;
      return true;
    }

  if ( Super.DoJump(bUpdating) )
    {
      if ( !bUpdating )
        PlayOwnedSound(GetSound(EST_Jump), SLOT_Pain, GruntVolume,,80);
      return true;
    }
  return false;
}

