package jp.sourceforge.sxdbutils.bean;

import java.beans.PropertyDescriptor;
import java.util.Map;

import jp.sourceforge.sxdbutils.util.CaseInsensitiveHashMap;

/**
 * 中間マッピング名にプロパティ名、カラム名がそのまま使用される {@link NameMapping}実装です。
 * 
 * @author chinpei
 * 
 */
public class ColumnNameMapping implements NameMapping {

	public String toIntermediateName(PropertyDescriptor propertyDescriptor) {
		return propertyDescriptor.getName();
	}

	public Map createIntermediateMap() {
		return new CaseInsensitiveHashMap();
	}

	public String toIntermediateName(String columnName) {
		return columnName;
	}
	public String toColumnName(PropertyDescriptor propertyDescriptor) {
		return propertyDescriptor.getName();
	}

}
