package jp.sourceforge.sxdbutils.bean;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.sourceforge.sxdbutils.util.CaseInsensitiveHashMap;
import jp.sourceforge.sxdbutils.util.ReflectionUtil;

/**
 * 定数アノテーションにより、カラム名が指定できる {@link NameMapping}です。
 * 
 * @author chinpei
 * 
 */
public class ConstantAnnoNameMapping implements NameMapping {
	private static final NameMapping DEFAULT_COMVERSION = new ColumnNameMapping();

	private static final String ANNOTATION_SUFFIC = "_COLUMN";
	private final OverwriteNameMapping delegateNameMapping;

	public ConstantAnnoNameMapping(Class beanClass) {
		this(beanClass, DEFAULT_COMVERSION);
	}

	public ConstantAnnoNameMapping(Class beanClass,
			NameMapping defaultNameMapping) {
		Map columnToPropertyMap = new HashMap();
		Field[] fields = getAnnotationFields(beanClass);
		for (int i = 0; i < fields.length; i++) {
			Field field = fields[i];
			String propertyName = ReflectionUtil.removalSuffixFieldName(field,
					ANNOTATION_SUFFIC);
			String columnName = getColumnNameFromAnnotation(field);
			columnToPropertyMap.put(propertyName, columnName);
		}
		this.delegateNameMapping = new OverwriteNameMapping(
				columnToPropertyMap, defaultNameMapping);
	}
	
	protected final String getColumnNameFromAnnotation(Field field){
		return ReflectionUtil.getString(field);
	}
	/**
	 * アノテーションを保持したフィールドを返します。
	 * @param beanClass
	 * @return
	 */
	protected final Field[] getAnnotationFields(Class beanClass) {
		List list = new ArrayList();
		readAnnotationFieldsToList(beanClass, list);
		return (Field[]) list.toArray(new Field[list.size()]);
	}

	protected void readAnnotationFieldsToList(Class beanClass, List list) {
		if("java.lang.Object".equals(beanClass.getName()))
			return;
		readAnnotationFieldsToList(beanClass.getSuperclass(), list);
		Field[] fields = beanClass.getDeclaredFields();
		for (int i = 0; i < fields.length; i++) {
			Field field = fields[i];
			if (isColumnAnnotation(field))
				list.add(field);
		}
	}

	public String toIntermediateName(PropertyDescriptor propertyDescriptor) {
		return this.delegateNameMapping.toIntermediateName(propertyDescriptor);
	}

	public final Map createIntermediateMap() {
		return new CaseInsensitiveHashMap();
	}

	public String toIntermediateName(String columnName) {
		return this.delegateNameMapping.toIntermediateName(columnName);
	}

	public String toColumnName(PropertyDescriptor propertyDescriptor) {
		return this.delegateNameMapping.toColumnName(propertyDescriptor);
	}

	/**
	 * カラムアノテーションの判定
	 * 
	 * @param field
	 * @return
	 */
	private boolean isColumnAnnotation(Field field) {
		if (!ReflectionUtil.isPublicStaticFinalString(field)) {
			return false;
		}
		if (field.getName().endsWith(ANNOTATION_SUFFIC)) {
			return true;
		}
		return false;
	}
}
