package jp.sourceforge.sxdbutils.tiger.processors;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import jp.sourceforge.sxdbutils.tiger.SxRowProcessor;

public class SxRowProcessorDelegate<S> implements SxRowProcessor<S> {
	protected final jp.sourceforge.sxdbutils.SxRowProcessor delegate;

	public SxRowProcessorDelegate(
			jp.sourceforge.sxdbutils.SxRowProcessor delegate) {
		this.delegate = delegate;
	}

	public void init(ResultSetMetaData rsmd) throws SQLException {
		delegate.init(rsmd);
	}

	public S process(ResultSet rs) throws SQLException {
		@SuppressWarnings("unchecked")
		S result =(S) delegate.process(rs);
		return result;
	}

}
