package jp.sourceforge.sxdbutils.processors;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import jp.sourceforge.sxdbutils.SxRowProcessor;
import jp.sourceforge.sxdbutils.TypeMappings;
import jp.sourceforge.sxdbutils.ValueType;

public class ValueRowProcessor implements SxRowProcessor {

	private int columnIndex;
	private String columnName;
	private Class type;

	private ValueType valueType;

	public ValueRowProcessor(int columnIndex) {
		this.columnIndex = columnIndex;
	}

	public ValueRowProcessor(String columnName) {
		this.columnName = columnName;
	}

	public ValueRowProcessor(int columnIndex, Class type) {
		this.columnIndex = columnIndex;
		this.type = type;
	}

	public ValueRowProcessor(String columnName, Class type) {
		this.columnName = columnName;
		this.type = type;
	}

	public Object process(ResultSet rs) throws SQLException {
		return this.valueType.getValue(rs, this.columnIndex);
	}

	public void init(ResultSetMetaData rsmd) throws SQLException {

		if (columnName != null) {
			boolean exists = false;
			for (int i = 0, index = 1; i < rsmd.getColumnCount(); i++, index++) {
				if (columnName.equalsIgnoreCase(rsmd.getColumnLabel(index))) {
					this.columnIndex = index;
					exists = true;
					break;
				}
			}
			if (!exists)
				throw new SQLException("指定されたカラム名が見つかりません。columnName="
						+ columnName);
		}
		this.valueType = getValueType(rsmd.getColumnType(columnIndex));
	}

	protected ValueType getValueType(int sqlType) {
		return (type == null) ? TypeMappings.getValueType(sqlType)
				: TypeMappings.getValueType(type, sqlType);
	}

}
