package jp.sourceforge.sxdbutils.query;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

import jp.sourceforge.sxdbutils.ValueType;
import jp.sourceforge.sxdbutils.mapping.NameMapping;
import jp.sourceforge.sxdbutils.meta.AttributeDescpriotr;
import jp.sourceforge.sxdbutils.meta.BasicPersistenceEntry;
import jp.sourceforge.sxdbutils.meta.PersistenceEntry;
import jp.sourceforge.sxdbutils.meta.PropertyAttributeDescpritor;
import jp.sourceforge.sxdbutils.util.ReflectionUtil;

/**
 * BeanQueryFactoryのビルダーです。
 * 
 * @author chinpei
 * 
 */
public class BeanQueryFactoryBuilder<E> extends AttributeQueryFactoryBuilder<E> {

	public BeanQueryFactoryBuilder(Class<E> baseClass) {
		super(baseClass);
	}

	public BeanQueryFactoryBuilder(Class<E> baseClass, NameMapping nameMapping) {
		super(baseClass, nameMapping);
	}
	@Deprecated
	public BeanQueryFactoryBuilder<E> excludeColumn(String excludeColumn) {
		return this.excludeColumns(excludeColumn);
	}

	public BeanQueryFactoryBuilder<E> excludeColumns(String... excludeColumns) {
		for (String excludeColumn : excludeColumns) {
			this.excludeColumnSet.add(excludeColumn.toLowerCase());
		}
		return this;
	}

	public BeanQueryFactoryBuilder<E> excludeColumns(List<String> excludeColumns) {
		for (String excludeColumn : excludeColumns) {
			this.excludeColumnSet.add(excludeColumn.toLowerCase());
		}
		return this;
	}

	public BeanQueryFactoryBuilder<E> tableName(String tableName) {
		this.tableName = tableName;
		return this;
	}

	public BeanQueryFactoryBuilder<E> versionColumnName(String versionColumnName) {
		this.versionColumnName = versionColumnName;
		return this;
	}

	public BeanQueryFactoryBuilder<E> columnType(String columnName, int sqlType) {
		this.columnTypeMap.put(columnName.toLowerCase(), new Integer(sqlType));
		return this;
	}

	public BeanQueryFactoryBuilder<E> whereKeyColumn(String... columnNames) {
		if (this.whereKeyColumnSet == null) {
			this.whereKeyColumnSet = new LinkedHashSet<String>();
		}
		for (String columnName : columnNames) {
			this.whereKeyColumnSet.add(columnName.toLowerCase());
		}
		return this;
	}

	protected PersistenceEntry[] toPersistenceEntries() {
		PropertyDescriptor[] propertyDescriptors = ReflectionUtil.propertyDescriptors(baseClass);

		List<PersistenceEntry> persistenceEntries = new ArrayList<PersistenceEntry>();
		for (int i = 0; i < propertyDescriptors.length; i++) {
			AttributeDescpriotr attributeDescpriotr = new PropertyAttributeDescpritor(propertyDescriptors[i]);
			if (!attributeDescpriotr.isReadable() || "class".equals(attributeDescpriotr.getName()))
				continue;

			String columnName = this.nameMapping.toColumnNameFromAttrName(attributeDescpriotr.getName());
			if (excludeColumnSet.contains(columnName.toLowerCase()))
				continue;

			// ValueType取得
			Integer sqlType = (Integer) columnTypeMap.get(columnName.toLowerCase());

			ValueType valueType = getValueType(attributeDescpriotr, sqlType);

//			System.out.println(columnName + " - " + valueType.getClass().getName());

			BasicPersistenceEntry entry = new BasicPersistenceEntry(columnName, valueType, attributeDescpriotr);

			persistenceEntries.add(entry);
		}
		return (PersistenceEntry[]) persistenceEntries.toArray(new PersistenceEntry[persistenceEntries.size()]);
	}

}
