package jp.sourceforge.sxdbutils.query;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

import jp.sourceforge.sxdbutils.ValueType;
import jp.sourceforge.sxdbutils.mapping.NameMapping;
import jp.sourceforge.sxdbutils.meta.AttributeDescpriotr;
import jp.sourceforge.sxdbutils.meta.BasicPersistenceEntry;
import jp.sourceforge.sxdbutils.meta.FieldAttributeDescpriotr;
import jp.sourceforge.sxdbutils.meta.PersistenceEntry;

/**
 * AttributeQueryFactoryのビルダーです。
 * 
 * @author chinpei
 * 
 */
public class FieldQueryFactoryBuilder<E> extends AttributeQueryFactoryBuilder<E> {

	public FieldQueryFactoryBuilder(Class<E> baseClass) {
		super(baseClass);
	}

	public FieldQueryFactoryBuilder(Class<E> baseClass, NameMapping nameMapping) {
		super(baseClass, nameMapping);
	}
	@Deprecated
	public FieldQueryFactoryBuilder<E> excludeColumn(String excludeColumn) {
		return this.excludeColumns(excludeColumn);
	}

	public FieldQueryFactoryBuilder<E> excludeColumns(String... excludeColumns) {
		for (String excludeColumn : excludeColumns) {
			this.excludeColumnSet.add(excludeColumn.toLowerCase());
		}
		return this;
	}

	public FieldQueryFactoryBuilder<E> excludeColumns(List<String> excludeColumns) {
		for (int i = 0; i < excludeColumns.size(); i++)
			this.excludeColumns(excludeColumns.get(i));
		return this;
	}

	public FieldQueryFactoryBuilder<E> tableName(String tableName) {
		this.tableName = tableName;
		return this;
	}

	public FieldQueryFactoryBuilder<E> versionColumnName(String versionColumnName) {
		this.versionColumnName = versionColumnName;
		return this;
	}

	public FieldQueryFactoryBuilder<E> columnType(String columnName, int sqlType) {
		this.columnTypeMap.put(columnName.toLowerCase(), new Integer(sqlType));
		return this;
	}

	public FieldQueryFactoryBuilder<E> whereKeyColumn(String... columnNames) {
		if (this.whereKeyColumnSet == null) {
			this.whereKeyColumnSet = new LinkedHashSet<String>();
		}
		for (String columnName : columnNames) {
			this.whereKeyColumnSet.add(columnName.toLowerCase());
		}
		return this;
	}

	protected PersistenceEntry[] toPersistenceEntries() {

		Field[] fields = baseClass.getFields();

		List<PersistenceEntry> persistenceEntries = new ArrayList<PersistenceEntry>();
		for (int i = 0; i < fields.length; i++) {
			AttributeDescpriotr attributeDescpriotr = new FieldAttributeDescpriotr(fields[i]);
			String columnName = this.nameMapping.toColumnNameFromAttrName(attributeDescpriotr.getName());

			if (excludeColumnSet.contains(columnName.toLowerCase()))
				continue;

			// ValueType取得
			Integer sqlType = (Integer) columnTypeMap.get(columnName.toLowerCase());

			ValueType valueType = getValueType(attributeDescpriotr, sqlType);

			BasicPersistenceEntry entry = new BasicPersistenceEntry(columnName, valueType, attributeDescpriotr);

			persistenceEntries.add(entry);
		}
		return (PersistenceEntry[]) persistenceEntries.toArray(new PersistenceEntry[persistenceEntries.size()]);
	}

}
