package jp.sourceforge.sxdbutils.rstable;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import jp.sourceforge.sxdbutils.util.JdbcMetaUtil;

public class BasicResultColumnMetaData implements ResultColumnMetaData {
	private final String columnName;
	private final String columnClassName;
	private final String catalogName;
	private final int columnDisplaySize;
	private final int columnType;
	private final String columnTypeName;
	private final int precision;
	private final int scale;
	private final String schemaName;
	private final String tableName;
	private final boolean signed;

	public BasicResultColumnMetaData(ResultSetMetaData meta, int columnNo) throws SQLException {
		this.columnName = JdbcMetaUtil.getColumnName(meta, columnNo).toUpperCase();
		this.columnClassName = meta.getColumnClassName(columnNo);
		this.catalogName = meta.getCatalogName(columnNo);
		this.columnDisplaySize = meta.getColumnDisplaySize(columnNo);
		this.columnType = meta.getColumnType(columnNo);
		this.columnTypeName = meta.getColumnTypeName(columnNo);
		this.precision = meta.getPrecision(columnNo);
		this.scale = meta.getScale(columnNo);
		this.schemaName = meta.getSchemaName(columnNo);
		this.tableName = meta.getTableName(columnNo);
		this.signed = meta.isSigned(columnNo);
	}

	/* (non-Javadoc)
	 * @see jp.sourceforge.sxdbutils.rstable.ResultColumnMetaData#getColumnName()
	 */
	public String getColumnName() {
		return columnName;
	}

	/* (non-Javadoc)
	 * @see jp.sourceforge.sxdbutils.rstable.ResultColumnMetaData#getColumnClassName()
	 */
	public String getColumnClassName() {
		return columnClassName;
	}

	/* (non-Javadoc)
	 * @see jp.sourceforge.sxdbutils.rstable.ResultColumnMetaData#getCatalogName()
	 */
	public String getCatalogName() {
		return catalogName;
	}

	/* (non-Javadoc)
	 * @see jp.sourceforge.sxdbutils.rstable.ResultColumnMetaData#getColumnDisplaySize()
	 */
	public int getColumnDisplaySize() {
		return columnDisplaySize;
	}

	/* (non-Javadoc)
	 * @see jp.sourceforge.sxdbutils.rstable.ResultColumnMetaData#getColumnType()
	 */
	public int getColumnType() {
		return columnType;
	}

	/* (non-Javadoc)
	 * @see jp.sourceforge.sxdbutils.rstable.ResultColumnMetaData#getColumnTypeName()
	 */
	public String getColumnTypeName() {
		return columnTypeName;
	}

	/* (non-Javadoc)
	 * @see jp.sourceforge.sxdbutils.rstable.ResultColumnMetaData#getPrecision()
	 */
	public int getPrecision() {
		return precision;
	}

	/* (non-Javadoc)
	 * @see jp.sourceforge.sxdbutils.rstable.ResultColumnMetaData#getScale()
	 */
	public int getScale() {
		return scale;
	}

	/* (non-Javadoc)
	 * @see jp.sourceforge.sxdbutils.rstable.ResultColumnMetaData#getSchemaName()
	 */
	public String getSchemaName() {
		return schemaName;
	}

	/* (non-Javadoc)
	 * @see jp.sourceforge.sxdbutils.rstable.ResultColumnMetaData#getTableName()
	 */
	public String getTableName() {
		return tableName;
	}

	/* (non-Javadoc)
	 * @see jp.sourceforge.sxdbutils.rstable.ResultColumnMetaData#isSigned()
	 */
	public boolean isSigned() {
		return signed;
	}

}
