package jp.sourceforge.sxdbutils.rstable;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

import jp.sourceforge.sxdbutils.util.SqlDateUtils;

public class TimeColumn extends AbstractColumn/*<Time>*/{

	public TimeColumn(int columnIndex, ResultColumnMetaData columnMeta) {
		super(columnIndex, columnMeta);
	}

	public Object valueOf(ResultSet rset) throws SQLException {
		return rset.getTime(columnIndex + 1);
	}

	public BigDecimal getBigDecimal(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return BigDecimal.valueOf(((Time) value).getTime());
	}

	public boolean getBoolean(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		return value != null;
	}

	public Boolean getBooleanObject(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return Boolean.valueOf(value != null);

	}

	public byte getByte(Object[] rowdata) {
		return 0;
	}

	public Byte getByteObject(Object[] rowdata) {
		return null;
	}

	public byte[] getBytes(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return new byte[0];

	}

	public char getChar(Object[] rowdata) {
		return '\u0000';
	}

	public Character getCharacter(Object[] rowdata) {
		return null;
	}

	public Date getDate(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		return ((Time) value);
	}

	public double getDouble(Object[] rowdata) {
		return 0d;
	}

	public Double getDoubleObject(Object[] rowdata) {
		return null;
	}

	public float getFloat(Object[] rowdata) {
		return 0f;
	}

	public Float getFloatObject(Object[] rowdata) {
		return null;
	}

	public int getInt(Object[] rowdata) {
		return 0;
	}

	public Integer getInteger(Object[] rowdata) {
		return null;
	}

	public long getLong(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return 0L;
		return ((Time) value).getTime();
	}

	public Long getLongObject(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return new Long(((Time) value).getTime());
	}

	public short getShort(Object[] rowdata) {
		return (short) 0;
	}

	public Short getShortObject(Object[] rowdata) {
		return null;
	}

	public java.sql.Date getSqlDate(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return SqlDateUtils.toSqlDate(((Time) value).getTime());
	}

	public String getString(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return value.toString();
	}

	public Time getTime(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return ((Time) value);
	}

	public Timestamp getTimestamp(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return new Timestamp(((Time) value).getTime());
	}

}
