package jp.sourceforge.sxdbutils.template;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

import jp.sourceforge.sxdbutils.query.Query;
import jp.sourceforge.sxdbutils.SxQueryRunner;
import jp.sourceforge.sxdbutils.SxRowProcessor;
import jp.sourceforge.sxdbutils.handlers.ListHandler;
import jp.sourceforge.sxdbutils.handlers.SingleHandler;

public abstract class AbstractSelectTemplate<E> implements SelectTemplate<E> {
	protected abstract Connection getConnection() throws SQLException;

	protected abstract Class<E> getEntityClass();

	protected abstract <X extends E> SxRowProcessor<X> createRowProcessor(Class<X> entityClass);

	protected <X extends E> SingleHandler<X> createSingleHandler(Class<X> entityClass) {
		return new SingleHandler<X>(createRowProcessor(entityClass));
	}

	protected <X extends E> ListHandler<X> createListHandler(Class<X> entityClass) {
		return new ListHandler<X>(createRowProcessor(entityClass));
	}

	public E executeQueryToBean(Query query) throws SQLException {
		SxQueryRunner runner = new SxQueryRunner();
		return runner.query(getConnection(), query, createSingleHandler(getEntityClass()));
	}

	public List<E> executeQueryToEntityList(Query query) throws SQLException {
		SxQueryRunner runner = new SxQueryRunner();
		return runner.query(getConnection(), query, createListHandler(getEntityClass()));
	}

	public <X extends E> X executeQueryToEntity(Query query, Class<X> entityClass) throws SQLException {
		SxQueryRunner runner = new SxQueryRunner();
		return runner.query(getConnection(), query, createSingleHandler(entityClass));
	}

	public <X extends E> List<X> executeQueryToEntityList(Query query, Class<X> entityClass) throws SQLException {
		SxQueryRunner runner = new SxQueryRunner();
		return runner.query(getConnection(), query, createListHandler(entityClass));
	}

}
