<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DB_Mysql.php,v 1.4 2006/12/11 11:59:19 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * DB饹MySQL
 *
 * MySQL 4.1ʾ
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DB_Mysql.php,v 1.4 2006/12/11 11:59:19 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DB_Mysql extends SyL_DB
{
    /**
     * DB³¹
     * 
     * @access public
     * @param string ǡ١̾
     * @param string 桼̾
     * @param string ѥ
     * @param string ۥ̾
     * @param string ݡֹ
     * @param bool ³Ū³Ԥ
     * @return boolean ³OK: true, ³NG: false
     */
    function openConnection($dbname, $user, $passwd, $host, $port, $persistent)
    {
        if ($host == '') {
            $host = 'localhost';
        }
        if ($port != '') {
            $host .= ':' . $port;
        }
        $this->connection = ($persistent) ? mysql_pconnect($host, $user, $passwd) : mysql_connect($host, $user, $passwd);
        return (is_resource($this->connection) ? mysql_select_db($dbname, $this->connection) : false);
    }

    /**
     * DB³λ
     * 
     * @access public
     */
    function closeConnection()
    {
        if (is_resource($this->connection)) {
            mysql_close($this->connection);
            $this->connection = null;
        }
    }

    /**
     * Ǹ˵ä顼å
     *
     * @access public
     * @return string Ǹ˵ä顼å
     */
    function getLastError()
    {
        $error_message = mysql_error($this->connection);
        $this->convertDecode($error_message);
        return $error_message;
    }

    /**
     * ѥ᡼˥̵˽
     * 
     * @access public
     * @param string ˥оʸ
     * @return string ˥ʸ
     */
    function sanitize($parameter)
    {
        if (!is_numeric($parameter)) {
            if (function_exists('mysql_real_escape_string')) {
                return mysql_real_escape_string($parameter, $this->connection);
            } else {
                return mysql_escape_string($parameter);
            }
        } else {
            return $parameter;
        }
    }

    /**
     * ȥ󥶥󳫻
     *
     * @access public
     */
    function begin()
    {
        parent::begin();
        @mysql_query('SET AUTOCOMMIT=0', $this->connection);
        @mysql_query('BEGIN', $this->connection);
    }

    /**
     * ȥ󥶥˴
     *
     * @access public
     */
    function rollback()
    {
        @mysql_query('SET AUTOCOMMIT=1', $this->connection);
        @mysql_query('ROLLBACK', $this->connection);
        parent::rollback();
    }

    /**
     * ȥ󥶥
     *
     * @access public
     */
    function commit()
    {
        @mysql_query('SET AUTOCOMMIT=1', $this->connection);
        @mysql_query('COMMIT', $this->connection);
        parent::commit();
    }

    /**
     * SQL¹ԤDB꥽
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹OK: DB꥽, ¹NG: false
     */
    function executeSelect($sql)
    {
        // ʸɥС
        $this->convertEncode($sql);
        $result = @mysql_query($sql, $this->connection);
        if ($result !== false) {
            return $result;
        } else {
            $this->trigger_error_db($this->getLastError());
            return false;
        }
    }

    /**
     * SQL¹Ԥ¹Է̱ƶ
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹OK: ¹Է̱ƶ, ¹NG: false
     */
    function executeUpdate($sql)
    {
        // ʸɥС
        $this->convertEncode($sql);
        $result = @mysql_query($sql, $this->connection);
        if ($result !== false) {
            return mysql_affected_rows($this->connection);
        } else {
            $this->trigger_error_db($this->getLastError());
            return false;
        }
    }

    /**
     * SQL¹ԤΤ
     *
     * @access public
     * @param string SQLʸ
     * @return boolean ¹OK: true, ¹NG: false
     */
    function executeNoReturn($sql)
    {
        // ʸɥС
        $this->convertEncode($sql);
        $result = @mysql_query($sql, $this->connection);
        if ($result !== false) {
            return true;
        } else {
            $this->trigger_error_db($this->getLastError());
            return false;
        }
    }

    /**
     * SQL¹Ԥ̥ǡ
     *
     * 3ѥ᡼'one'ξ
     *    ǽ1ʸȤƼ
     * 3ѥ᡼'record'ξ
     *    ǽ1쥳ɤȤƼ
     * 3ѥ᡼'all'ξ
     *    쥳ɤȤƼ
     *
     * @access public
     * @param string SQLʸ
     * @param mixed  ¹Է̤
     * @param string ̼ե饰
     * @return boolean ¹OK: true, ¹NG: false
     */
    function executeGet($sql, &$data, $get='all')
    {
        // SQL¸
        $this->setLog($sql);
        // ʸɥС
        $this->convertEncode($sql);
        // SQL¹
        $query = @mysql_query($sql, $this->connection);
    
        // ¹Ի顼Ƚ
        if (is_resource($query)) {
            switch ($get) {
            case 'one':
                if (mysql_num_rows($query) > 0) {
                    list($data) = mysql_fetch_row($query);
                    $this->convertDecode($data);
                } else {
                    $data = '';
                }
                break;
            case 'record':
                $data = mysql_fetch_assoc($query);
                if ($data === false) {
                    $data = array();
                } else {
                    $data = $this->changeFieldName($data);
                    $this->convertDecode($data);
                }
                break;
            case 'all':
                $data = array();
                while ($result = mysql_fetch_assoc($query)) {
                    $result = $this->changeFieldName($result);
                    $this->convertDecode($result);
                    $data[] = $result;
                }
                break;
            }
            mysql_free_result($query);
            return true;
        } else {
            $this->trigger_error_db($this->getLastError());
            return false;
        }
    }

    /**
     * SQL¹Ԥڡ˥ǡ
     * ¹ˡinitializePageץ᥽åɼ¹ɬ
     * SQLʸΡFROM׶ľ˥ʸɬܡʤʳΥʸԲġ
     *
     * @access public
     * @param string SQLʸ
     * @param array ¹Է̳Ǽ
     * @param object ڡ֥
     * @param int 1ڡɽ
     * @param int ɽоݥڡ 
     * @return bool ¹Է
     */
    function executePage($sql, &$result, &$page_control, $limit, $page=1)
    {
        // ڡ楯饹
        include_once dirname(dirname(__FILE__)) . DIRECTORY_SEPARATOR . 'SyL_PageControl.php';
        $page_control = new SyL_PageControl();
        $page_control->setCount($limit);
        $page_control->setPage($page);

        // SQL
        $sql_count = "SELECT COUNT(*) FROM (" . $sql . ") AS SyL$";
        // SQL¹
        if (!$this->executeGet($sql_count, $record, 'one')) return false;
        $page_control->setCountAll( $record );

        // ڡñ̥쥳ɼ
        $sql_page  = $sql;
        $sql_page .= ' LIMIT ' . $page_control->getStartRecord() . ', ' . $page_control->getCount();

        // ǡSQL¹
        return $this->executeGet($sql_page, $result, 'all');
    }

    /**
     * ʸ򥯥饤ʸɤ˥ǥɤ
     *
     * @access public
     * @param string ǥʸ
     */
    function convertEncode(&$values)
    {
        if ($this->server_encode != $this->client_encode) {
            if (is_array($values)) {
                foreach ($values as $key => $value) {
                    $values[$key] = $this->convertEncode( $values[$key] );
                }
            } else {
                $values = mb_convert_encoding($values, $this->server_encode, $this->client_encode);
            }
        }
    }

    /**
     * ʸ򥯥饤ʸɤ˥ǥɤ
     *
     * @access public
     * @param string ǥʸ
     */
    function convertDecode(&$values)
    {
        if ($this->server_encode != $this->client_encode) {
            if (is_array($values)) {
                foreach ($values as $key => $value) {
                    $values[$key] = $this->convertDecode( $values[$key] );
                }
            } else {
                $values = mb_convert_encoding($values, $this->client_encode, $this->server_encode);
            }
        }
    }

    /**
     * եեޥåȴؿ̾
     *
     * @access public
     *
     * @param string ̾
     * @param string շեޥå  YYYY/MM/DD YYYY/MM/DD HH24:MI:SS
     * @return string եեޥåȴؿ̾
     */
    function getSqlDateFormat($column_name, $format='%Y-%m-%d %H:%i:%s')
    {
        return "DATE_FORMAT('{$column_name}', '{$format}')";
    }

    /**
     * ơ֥
     *
     * @access public
     *
     * @return array ơ֥ꥹ
     */
    function getTableList()
    {
        $tables     = array();
        $tables_tmp = array();
        $this->executeGet( "SHOW TABLES", $tables_tmp );
        foreach ($tables_tmp as $table) {
            list($key, $value) = each($table);
            $tables[] = $value;
        }
        return $tables;
    }

    /**
     * 
     *
     * @access public
     *
     * @param string ơ֥̾
     * @return array ꥹ
     */
    function getColumnList( $table_name )
    {
        $columns     = array();
        $columns_tmp = array();
        $this->executeGet( "SHOW COLUMNS FROM " . $table_name, $columns_tmp );
        foreach ($columns_tmp as $column) {
            $columns[] = $column['FIELD'];
        }
        return $columns;
    }
}

?>
