<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_MailSendmail.php,v 1.4 2006/12/11 11:59:19 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

define('SYL_MAIL_SENDMAIL_PATH', '/usr/lib/sendmail');

/**
 *  Sendmail᡼饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_MailSendmail.php,v 1.4 2006/12/11 11:59:19 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_MailSendmail extends SyL_Mail
{
    /**
     * Sendmailѥ
     *
     * @access private
     * @var string
     */
    var $sendmail_path = SYL_MAIL_SENDMAIL_PATH;

    /**
     * 󥹥ȥ饯
     *
     * @access private
     */
    function SyL_MailSendmail()
    {
        parent::SyL_Mail();
    }

    /**
     * Sendmailޥɥѥ򥻥å
     * 
     * @access public
     * @param string Sendmailޥɥѥ
     */
    function setSendmailPath($sendmail_path)
    {
        $this->sendmail_path = $sendmail_path;
    }

    /**
     * ᡼
     *
     * @access public
     * @param array ᡼°
     * @param bool ե饰
     * @return OK: true, NG: false
     */
    function init($attributes=array(), $all=false)
    {
        $attributes = array_change_key_case($attributes, CASE_LOWER);
        parent::init($attributes, $all);
        // Sendmailѥ
        if (isset($attributes['sendmail'])) {
            $this->sendmail_path = $attributes['sendmail'];
        }
        return true;
    }

    /**
     * ᡼¹
     *
     * @access public
     * @return OK: null, NG: SyL_Error_Parameter֥
     */
    function send()
    {
        if (!parent::send()) {
            return false;
        }

        // Pathɬ
        if ($this->sendmail_path == '') {
            $this->error_message = "[SyL error] Sendmail path not found";
            return false;
        }

        // ᡼إåޤʸ
        $data = $this->getHeaderMessage($this->body);

       // ꥿ѥΥå
       if ($this->headers['MAIL_FROM'] != '') {
           $additional_parameters = ' -f' . $this->headers['MAIL_FROM'];
       } else {
           $additional_parameters = '';
       }

        // ᡼¹ ----------------------------------------------------------

        $pmail = popen($this->sendmail_path . ' -t -i' . $additional_parameters, 'w');
        if (!$pmail) {
            $this->error_message = "[SyL error] Sendmail command execute error";
            return false;
        }
        fputs($pmail, $data);
        pclose($pmail);

        // 
        $this->init();

        return true;
    }
}

?>
