<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DB_Mysql.php,v 1.8 2007/01/21 08:14:45 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * DB饹MySQL
 *
 * MySQL 4.1ʾ
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DB_Mysql.php,v 1.8 2007/01/21 08:14:45 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DB_Mysql extends SyL_DB
{
    /**
     * 󥳡Ѵơ֥
     *
     *  MySQL    <=> PHP
     *  (client)     (client)
     * 
     * ƾʸǵ
     *
     * @access protected
     * @var string
     */
    var $encode_table = array(
      // PHP, DB
      array('eucjp-win', 'ujis'),
      array('euc-jp',    'ujis'),
      array('sjis-win',  'sjis' ),
      array('sjis',      'sjis'),
      array('utf-8',     'utf8')
    );

    /**
     * DB³¹
     * 
     * @access public
     * @param string ǡ١̾
     * @param string 桼̾
     * @param string ѥ
     * @param string ۥ̾
     * @param string ݡֹ
     * @param bool ³Ū³Ԥ
     * @return boolean ³OK: true, ³NG: false
     */
    function openConnection($dbname, $user, $passwd, $host, $port, $persistent)
    {
        if ($host == '') {
            $host = 'localhost';
        }
        if ($port != '') {
            $host .= ':' . $port;
        }
        $this->connection = ($persistent) ? mysql_pconnect($host, $user, $passwd) : mysql_connect($host, $user, $passwd);
        if (is_resource($this->connection) && mysql_select_db($dbname, $this->connection)) {
            $this->setClientEncoding();
            return true;
        } else {
            return false;
        }
    }

    /**
     * 饤¦ʸ󥳡ƥ
     * 
     * @access public
     * @param string ʸ
     */
    function setClientEncoding($client_encode='')
    {
        parent::setClientEncoding($client_encode);
        if ($this->client_encode)
            @mysql_query("SET NAMES {$this->client_encode}", $this->connection);
        }
    }

    /**
     * DB³λ
     * 
     * @access public
     */
    function closeConnection()
    {
        if (is_resource($this->connection)) {
            mysql_close($this->connection);
            $this->connection = null;
        }
    }

    /**
     * Ǹ˵ä顼å
     *
     * @access public
     * @return string Ǹ˵ä顼å
     */
    function getLastError()
    {
        $error_no = mysql_errno($this->connection);
        $error_message = '';
        if ($error_no != 0) {
            $error_message = "[Error No {$error_no}] " . mysql_error($this->connection);
        }
        return $error_message;
    }

    /**
     * ѥ᡼˥̵˽
     * 
     * @access public
     * @param string ˥оʸ
     * @return string ˥ʸ
     */
    function sanitize($parameter)
    {
        return !is_numeric($parameter) ? mysql_real_escape_string($parameter, $this->connection) : $parameter;
    }

    /**
     * ȥ󥶥󳫻
     *
     * @access public
     */
    function begin()
    {
        parent::begin();
        @mysql_query('SET AUTOCOMMIT=0', $this->connection);
        @mysql_query('BEGIN', $this->connection);
    }

    /**
     * ȥ󥶥˴
     *
     * @access public
     */
    function rollback()
    {
        @mysql_query('ROLLBACK', $this->connection);
        @mysql_query('SET AUTOCOMMIT=1', $this->connection);
        parent::rollback();
    }

    /**
     * ȥ󥶥
     *
     * @access public
     */
    function commit()
    {
        @mysql_query('COMMIT', $this->connection);
        @mysql_query('SET AUTOCOMMIT=1', $this->connection);
        parent::commit();
    }

    /**
     * SQL¹ԤDB꥽
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹OK: DB꥽, ¹NG: false
     */
    function executeSelect($sql)
    {
        $result = @mysql_query($sql, $this->connection);
        if ($result !== false) {
            return $result;
        } else {
            $this->executeTriggerError($this->getLastError());
            return false;
        }
    }

    /**
     * SQL¹Ԥ¹Է̱ƶ
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹OK: ¹Է̱ƶ, ¹NG: false
     */
    function executeUpdate($sql)
    {
        $result = @mysql_query($sql, $this->connection);
        if ($result !== false) {
            return mysql_affected_rows($this->connection);
        } else {
            $this->executeTriggerError($this->getLastError());
            return false;
        }
    }

    /**
     * SQL¹ԤΤ
     *
     * @access public
     * @param string SQLʸ
     * @return boolean ¹OK: true, ¹NG: false
     */
    function executeNoReturn($sql)
    {
        $result = @mysql_query($sql, $this->connection);
        if ($result !== false) {
            return true;
        } else {
            $this->executeTriggerError($this->getLastError());
            return false;
        }
    }

    /**
     * SQL¹Ԥ̥ǡ
     *
     * 3ѥ᡼'one'ξ
     *    ǽ1ʸȤƼ
     * 3ѥ᡼'record'ξ
     *    ǽ1쥳ɤȤƼ
     * 3ѥ᡼'all'ξ
     *    쥳ɤȤƼ
     *
     * @access public
     * @param string SQLʸ
     * @param mixed  ¹Է̤
     * @param string ̼ե饰
     * @return boolean ¹OK: true, ¹NG: false
     */
    function executeGet($sql, &$data, $get='all')
    {
        // SQL¹
        $this->execute($sql, $query);
    
        // ¹Ի顼Ƚ
        if (is_resource($query)) {
            switch ($get) {
            case 'one':
                if (mysql_num_rows($query) > 0) {
                    list($data) = mysql_fetch_row($query);
                } else {
                    $data = '';
                }
                break;
            case 'record':
                $data = mysql_fetch_assoc($query);
                if ($data === false) {
                    $data = array();
                } else {
                    $data = $this->changeFieldName($data);
                }
                break;
            case 'all':
                $data = array();
                while ($result = mysql_fetch_assoc($query)) {
                    $result = $this->changeFieldName($result);
                    $data[] = $result;
                }
                break;
            }
            mysql_free_result($query);
            return true;
        } else {
            $this->executeTriggerError($this->getLastError());
            return false;
        }
    }

    /**
     * SQL¹Ԥڡ˥ǡ
     * ¹ˡinitializePageץ᥽åɼ¹ɬ
     * SQLʸΡFROM׶ľ˥ʸɬܡʤʳΥʸԲġ
     *
     * @access public
     * @param string SQLʸ
     * @param array ¹Է̳Ǽ
     * @param object ڡ֥
     * @param int 1ڡɽ
     * @param int ɽоݥڡ 
     * @return bool ¹Է
     */
    function executePage($sql, &$result, &$page_control, $limit, $page=1)
    {
        // ڡ楯饹
        include_once dirname(dirname(__FILE__)) . '/SyL_Pager.php';
        $page_control = new SyL_Pager();
        $page_control->setCount($limit);
        $page_control->setPage($page);

        // SQL
        $sql_count = "SELECT COUNT(*) FROM (" . $sql . ") AS SyL$";
        // SQL¹
        if (!$this->executeGet($sql_count, $record, 'one')) return false;
        $page_control->setCountAll( $record );

        // ڡñ̥쥳ɼ
        $sql_page  = $sql;
        $sql_page .= ' LIMIT ' . $page_control->getStartRecord() . ', ' . $page_control->getCount();

        // ǡSQL¹
        return $this->executeGet($sql_page, $result, 'all');
    }

    /**
     * եեޥåȴؿ̾
     *
     * @access public
     *
     * @param string ̾
     * @param string շեޥå  YYYY/MM/DD YYYY/MM/DD HH24:MI:SS
     * @return string եեޥåȴؿ̾
     */
    function getSqlDateFormat($column_name, $format='%Y-%m-%d %H:%i:%s')
    {
        return "DATE_FORMAT('{$column_name}', '{$format}')";
    }

    /**
     * ơ֥
     *
     * @access public
     *
     * @return array ơ֥ꥹ
     */
    function getTableList()
    {
        $tables     = array();
        $tables_tmp = array();
        $this->executeGet( "SHOW TABLES", $tables_tmp );
        foreach ($tables_tmp as $table) {
            list($key, $value) = each($table);
            $tables[] = $value;
        }
        return $tables;
    }

    /**
     * 
     *
     * @access public
     *
     * @param string ơ֥̾
     * @return array ꥹ
     */
    function getColumnList( $table_name )
    {
        $columns     = array();
        $columns_tmp = array();
        $this->executeGet( "SHOW COLUMNS FROM " . $table_name, $columns_tmp );
        foreach ($columns_tmp as $column) {
            $columns[] = $column['FIELD'];
        }
        return $columns;
    }
}

?>
