/**
 * 󥹥ȥ饯
 */
function SyL_Ajax()
{
  this.method      = 'GET';
  this.async       = true;
  this.loadingFunc = null;
  this.loadedFunc  = null;
  this.loadingElementId = null;
  this.loadedElementId  = null;
  this.parameters  = new Array();
  this.request = this.getXMLHttpObject();
  this.timeout = 60000;
}

SyL_Ajax.prototype = {
  /**
   * HTTP᥽åɤ򥻥å
   *
   * @param string GET or POST
   */
  setMethod: function(method)
  {
    this.method = method;
  },
  /**
   * ƱƱ̿򥻥å
   *
   * @param bool true: Ʊfalse: Ʊ
   */
  setAsync: function(async)
  {
    this.async = (async == false) ? false : true;
  },
  /**
   * ꥯΥ٥ȴؿ򥻥å
   *
   * @param object ꥯΥ٥ȴؿ
   */
  setLoadingFunc: function(loadingFunc)
  {
    this.loadingFunc = loadingFunc;
  },
  /**
   * ꥯȸΥ٥ȴؿ򥻥å
   *
   * @param object ꥯȸΥ٥ȴؿ
   */
  setLoadedFunc: function(loadedFunc)
  {
    this.loadedFunc = loadedFunc;
  },
  /**
   * ɽID򥻥å
   *
   * @param string ɽID
   */
  setLoadingElementId: function(loadingElementId)
  {
    this.loadingElementId = loadingElementId;
  },
  /**
   * ɽID򥻥å
   *
   * @param string ɽID
   */
  setLoadedElementId: function(loadedElementId)
  {
    this.loadedElementId = loadedElementId;
  },
  /**
   * HTTPꥯȥѥ᡼򥻥å
   *
   * @param string 
   * @param string 
   */
  setParameter: function(key, value)
  {
    this.parameters[key] = value;
  },
  /**
   * XMLHttp֥Ȥ
   *
   * @param string ꥯURL
   * @param string ꥯȴλ˼¹Ԥؿ̾
   * @param string ꥯ˼¹Ԥؿ̾
   */
  getXMLHttpObject: function()
  {
    var request = null;
    if (window.ActiveXObject) {
      try {
        request = new ActiveXObject("Msxml2.XMLHTTP");
      } catch(e) {
        try {
          request = new ActiveXObject("Microsoft.XMLHTTP");
        } catch(e) {
          request = null;
        }
      }
    } else if (window.XMLHttpRequest) {
      request = new XMLHttpRequest();
      if (request.overrideMimeType) {
        request.overrideMimeType('text/plain');
      }
    }

    if (request == null) {
      alert("XMLHTTP object not found");
    }

    return request;
  },
  /**
   * HTTPꥯȤ
   * 
   * readyState
   *   0: UNINITIALIZED openƤФƤʤ 
   *   1: LOADING       sendƤФƤʤ 
   *   2: LOADED        responseƤʤ 
   *   3: INTERACTIVE   ʬŪ˱ 
   *   4: COMPLETED     λ 
   *
   * @param string ꥯURL
   * @param string ꥯȴλ˼¹Ԥؿ̾
   * @param string ꥯ˼¹Ԥؿ̾
   */
  sendRequest: function(url)
  {
    if ((this.loadedFunc == null) && (this.loadedElementId == null)) {
      alert('undefined Loaded Function or Element ID');
      return;
    }

    var parameter = '';
    for (var key in this.parameters) {
      if (parameter != '') {
        parameter += '&';
      }
      parameter += encodeURIComponent(key) + "=" + encodeURIComponent(this.parameters[key]);
    }

    var loadedFunc  = this.loadedFunc;
    var loadingFunc = this.loadingFunc;
    var loadingElementId = this.loadingElementId;
    var loadedElementId  = this.loadedElementId;
    var request = this.request;

    request.onreadystatechange = function()
    {
      switch (request.readyState) {
      case 4:
        switch (request.status) {
        case 200:
          var data;
          if (request.getResponseHeader('Content-Type').match(/json/i)) {
              data = eval('(' + request.responseText + ')');
          } else {
              data = request.responseText;
          }

          if (loadedElementId) {
            document.getElementById(loadedElementId).innerHTML = data;
          } else {
            loadedFunc(data);
          }
          break;

        case 500:
          alert('500 Internal Server Error: \\n' + request.responseText);
          break;

        default:
          alert('Response Error: ' + request.status + ' ' + request.statusText);
        }
        break;

      case 3:
        if (loadingElementId) {
          document.getElementById(loadingElementId).innerHTML = data;
        } else if (loadingFunc) {
          loadingFunc();
        }
        break;
      }
    };

    var timer = setInterval(function()
    {
      if (request.readyState == 0 || request.readyState == 4) {
        return;
      }
      clearInterval(timer);
      request.abort();
    },
    this.timeout);

    if (this.method == 'POST') {
      request.open(this.method, url, this.async);
      request.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
      request.send(parameter);
    } else {
      request.open(this.method, url + '?' + parameter, this.async);
      request.send(null);
    }
  },
  /**
   * ꥯȤ򥭥󥻥
   *
   */
  cancel: function()
  {
    if (typeof(this.request) == "object") {
      if (this.request.readyState == 0 || this.request.readyState == 4) {
        return;
      }
      this.request.abort();
    }
  }
}

/**
 * SyL_Ajaxꥯȥ饹
 *
 */
var SyL_AjaxRequest = {
  sendSyncGet: function(url, action, loadedFunc, loadingFunc, parameters)
  {
    SyL_AjaxRequest.send(url, action, {loaded: loadedFunc, loading: loadingFunc, async: false, method: 'GET', parameters: parameters});
  },
  sendSyncPost: function(url, action, loadedFunc, loadingFunc, parameters)
  {
    SyL_AjaxRequest.send(url, action, {loaded: loadedFunc, loading: loadingFunc, async: false, method: 'POST', parameters: parameters});
  },
  sendAsyncGet: function(url, action, loadedFunc, loadingFunc, parameters)
  {
    SyL_AjaxRequest.send(url, action, {loaded: loadedFunc, loading: loadingFunc, async: true, method: 'GET', parameters: parameters});
  },
  sendAsyncPost: function(url, action, loadedFunc, loadingFunc, parameters)
  {
    SyL_AjaxRequest.send(url, action, {loaded: loadedFunc, loading: loadingFunc, async: true, method: 'POST', parameters: parameters});
  },

  /**
   * {
   *   loaded  : (value)
   *   loading : (value)
   *   method  : (value)
   *   async   : (value)
   * }
   */
  send: function(url, action, arg)
  {
    if (!action) {
      alert('action not found');
      return;
    }

    if (!url) {
      alert('url undefined');
      return;
    }

    var sid        = '<?= $sid ?>';
    var action_key = '<?= $action_key ?>';

    var ajax = new SyL_Ajax();
    ajax.setParameter(action_key, action);
    if (sid != '') {
      var tmp = sid.split('=', 2);
      ajax.setParameter(tmp[0], tmp[1]);
    }

    if (typeof(arg) == "object") {
      if (arg.loaded) {
        switch (typeof(arg.loaded)) {
        case "function":
          ajax.setLoadedFunc(arg.loaded);
          break;
        case "string":
          ajax.setLoadedElementId(arg.loaded);
          break;
        }
      }
      if (arg.loading) {
        switch (typeof(arg.loading)) {
        case "function":
          ajax.setLoadingFunc(arg.loading);
          break;
        case "string":
          ajax.setLoadingElementId(arg.loading);
          break;
        }
      }
      if (arg.method) {
        ajax.setMethod(arg.method);
      }
      if ((arg.async != undefined) && (arg.async != null)) {
        ajax.setAsync(arg.async);
      }
      if (arg.url) {
        url = arg.url;
      }
      if (arg.parameters) {
        for (var i in arg.parameters) {
          ajax.setParameter(i, arg.parameters[i]);
        }
      }
    }

    ajax.sendRequest(url);
  }
}

