<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FilterAuth.php,v 1.1 2007/03/17 13:53:07 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ե륿饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Filter.php';
/**
 * ǧڥ饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Auth.php';

/**
 * ǧڥե륿饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FilterAuth.php,v 1.1 2007/03/17 13:53:07 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_FilterAuth extends SyL_Filter
{
    /**
     * ǧڥ֥
     * 
     * @access private
     * @var object
     */
    var $auth = null;
    /**
     * ǧڼ¹Ƚե饰
     * 
     * @access private
     * @var bool
     */
    var $login = null;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param object ꥯȥ֥
     * @param string ؿ̾
     */
    function SyL_FilterAuth()
    {
        // ǧڥ֥Ⱥ
        $this->auth =& SyL_Auth::getInstance();
        list($username, $password) = explode(':', SYL_AUTH_LOGIN_PARAMETER, 2);
        // ǧڥѥ᡼̾å
        $this->auth->setUserParamaterName($username);
        $this->auth->setPasswordParamaterName($password);
    }

    /**
     * ǧȽ or ǧڼ¹
     *
     * @access public
     */
    function preAction()
    {
        // ǧڥꥢȽ
        if ($this->auth->isAuthArea()) {
            // ֤Ƚ
            if (!$this->auth->isLogin()) {
                // å󥨥顼̤إ쥯
                $this->auth->redirectSessionError();
            }
        } else {
            // ̤ξ
            // 󥢥Ƚ
            if ($this->auth->isLoginAction()) {
                // ¹
                $this->login = $this->auth->doLogin();
            }
        }
    }

    /**
     * ϡTOP̤˥쥯
     *
     * @access public
     * @param object ǡޥ͡㥪֥
     */
    function postAction(&$dm)
    {
        // ǧڥꥢȽ
        if (is_bool($this->login)) {
            if ($this->login) {
                if (SYL_ENV_TYPE == 'web') {
                    // TOPإ쥯
                    $this->auth->redirect();
                } else {
                    $dm->setParameter('_auth_url', $this->auth->getRedirectUrl());
                }
            }

            if (SYL_ENV_TYPE == 'js') {
                // 󥢥󤬤ϡJSONӥ塼ѹ
                $dm->setViewParameter('viewtype', 'json');
            }
            $dm->setParameter('_auth_login', $this->login);
        }
    }
}

?>
