<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilProgress.php,v 1.3 2007/03/17 13:53:07 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ꥯȥ饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Request.php';

/**
 * ץ쥹Сѥ桼ƥƥ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilProgress.php,v 1.3 2007/03/17 13:53:07 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_UtilProgress
{
    /**
     * ץ쥹̾
     *
     * @access private
     * @var string
     */
    var $name = '';
    /**
     * вƬ
     *
     * @access private
     * @var string
     */
    var $prefix = '__syl_ps_';
    /**
     * MAXƬ
     *
     * @access private
     * @var string
     */
    var $prefix_max = '__syl_ps_max_';
    /**
     * å󥪥֥
     *
     * @access private
     * @var object
     */
    var $session = null;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_UtilProgress()
    {
        $request =& SyL_Request::getInstance();
        $this->session =& $request->getSessionObject();
        $this->session->closeSession();
    }

    /**
     * ץ쥹̾򥻥å
     * 
     * @access public
     * @param string ץ쥹̾
     */
    function setProgressName($name)
    {
        $this->name = $name;
    }

    /**
     * вͤ򥻥å
     * 
     * @access public
     * @param int в
     */
    function setProgressValue($value)
    {
        if (!is_numeric($value) || ($value < 0)) {
            trigger_error("[SyL error] Progress parameter is not integer ($value)", E_USER_ERROR);
        }
        // Ƭɲ
        $name = $this->prefix . $this->name;
        $this->session->writeCloseSession(array($name => $value));
    }

    /**
     * ͤ򥻥å
     * 
     * @access public
     * @param int 
     */
    function setProgressMaxValue($value)
    {
        if (!is_numeric($value) || ($value < 0)) {
            trigger_error("[SyL error] Progress max parameter is not integer ($value)", E_USER_ERROR);
        }
        // Ƭɲ
        $name = $this->prefix_max . $this->name;
        $this->session->writeCloseSession(array($name => $value));
    }

    /**
     * вͤ%Ǥ
     * 
     * @access public
     * @param string в
     */
    function getProgressValue()
    {
        $name     = $this->prefix . $this->name;
        $name_max = $this->prefix_max . $this->name;
        $this->session->startSession();
        $value = $this->session->getParameter($name);
        $value_max = $this->session->getParameter($name_max);
        $this->session->closeSession();
        
        if (($value === null) || ($value_max === null)) {
            // ѥ᡼¸ߤʤ
            return 0;
        }
        if (($value == 100) || ($value_max == 0)) {
            // MAXͤ0 or value100ξ
            return 100;
        }

        return ceil(($value/$value_max)*100);
    }

    /**
     * ѥ᡼򥻥å
     * 
     * @access public
     * @param string ѥ᡼̾
     * @param string ѥ᡼
     */
    function setParameter($name, $value)
    {
        $name = $this->prefix . $this->name . $name;
        $this->session->writeCloseSession(array($name => $value));
    }

    /**
     * ѥ᡼
     * 
     * @access public
     * @param string ѥ᡼̾
     * @return string ѥ᡼
     */
    function getParameter($name)
    {
        $name = $this->prefix . $this->name . $name;
        $this->session->startSession();
        $value = $this->session->getParameter($name);
        $this->session->closeSession();

        return $value;
    }

    /**
     * ѥ᡼
     * 
     * @access public
     */
    function finish()
    {
        $name = $this->prefix . $this->name;
        $name_max = $this->prefix_max . $this->name;

        $this->session->startSession();
        $this->session->deleteParameter($name);
        $this->session->deleteParameter($name_max);
        $this->session->closeSession();
    }
}

?>
